/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.CypherQueryCommand;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;

public class CypherQueryResource
extends Resource {
    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return "cypher".equals(part);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        if (!this.securityContext.isSuperUser()) {
            throw new NotAllowedException("Use of the cypher endpoint is restricted to admin users");
        }
        try {
            String queryObject = this.securityContext.getRequest().getParameter("query");
            if (queryObject != null) {
                String query = queryObject.toString();
                List resultList = ((CypherQueryCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(CypherQueryCommand.class)).execute(query, Collections.EMPTY_MAP);
                return new Result(resultList, Integer.valueOf(resultList.size()), true, false);
            }
        }
        catch (org.structr.api.NotFoundException nfe) {
            throw new NotFoundException("Entity not found for the given query");
        }
        return new Result(Collections.EMPTY_LIST, Integer.valueOf(0), false, false);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (!this.securityContext.isSuperUser()) {
            throw new NotAllowedException("Use of the cypher endpoint is restricted to admin users");
        }
        try {
            RestMethodResult result = new RestMethodResult(200);
            Object queryObject = propertySet.get("query");
            if (queryObject != null) {
                String query = queryObject.toString();
                List resultList = ((CypherQueryCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(CypherQueryCommand.class)).execute(query, propertySet);
                for (GraphObject obj : resultList) {
                    result.addContent(obj);
                }
            }
            return result;
        }
        catch (org.structr.api.NotFoundException nfe) {
            throw new NotFoundException("Entity not found for the given query");
        }
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    @Override
    public String getUriPart() {
        return "cypher";
    }

    public Class getEntityClass() {
        return null;
    }

    @Override
    public String getResourceSignature() {
        return "cypher";
    }

    @Override
    public boolean isCollectionResource() throws FrameworkException {
        return true;
    }
}

