/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Value;
import org.structr.core.property.PropertyKey;
import org.structr.rest.GraphObjectGSONAdapter;

public class ResultGSONAdapter
implements JsonSerializer<Result>,
JsonDeserializer<Result> {
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private GraphObjectGSONAdapter graphObjectGsonAdapter = null;

    public ResultGSONAdapter(Value<String> propertyView, int outputNestingDepth) {
        this.graphObjectGsonAdapter = new GraphObjectGSONAdapter(propertyView, outputNestingDepth);
    }

    public JsonElement serialize(Result src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement element;
        long t0 = System.nanoTime();
        JsonObject result = new JsonObject();
        List results = src.getResults();
        Integer page = src.getPage();
        Integer pageCount = src.getPageCount();
        Integer pageSize = src.getPageSize();
        String queryTime = src.getQueryTime();
        Integer resultCount = src.getRawResultCount();
        String searchString = src.getSearchString();
        String sortKey = src.getSortKey();
        String sortOrder = src.getSortOrder();
        GraphObject metaData = src.getMetaData();
        if (page != null) {
            result.add("page", (JsonElement)new JsonPrimitive((Number)page));
        }
        if (pageCount != null) {
            result.add("page_count", (JsonElement)new JsonPrimitive((Number)pageCount));
        }
        if (pageSize != null) {
            result.add("page_size", (JsonElement)new JsonPrimitive((Number)pageSize));
        }
        if (queryTime != null) {
            result.add("query_time", (JsonElement)new JsonPrimitive(queryTime));
        }
        if (resultCount != null) {
            result.add("result_count", (JsonElement)new JsonPrimitive((Number)resultCount));
        }
        if (results != null) {
            if (results.isEmpty()) {
                result.add("result", (JsonElement)new JsonArray());
            } else if (src.isPrimitiveArray()) {
                JsonArray resultArray = new JsonArray();
                for (GraphObject graphObject : results) {
                    Object value = graphObject.getProperty((PropertyKey)GraphObject.id);
                    if (value == null) continue;
                    resultArray.add((JsonElement)new JsonPrimitive(value.toString()));
                }
                result.add("result", (JsonElement)resultArray);
            } else {
                if (results.size() > 1 && !src.isCollection()) {
                    throw new IllegalStateException(src.getClass().getSimpleName() + " is not a collection resource, but result set has size " + results.size());
                }
                long startTime = System.currentTimeMillis();
                if (src.isCollection()) {
                    JsonArray resultArray = new JsonArray();
                    for (GraphObject graphObject : results) {
                        JsonElement element2 = this.graphObjectGsonAdapter.serialize(graphObject, startTime);
                        if (element2 != null) {
                            resultArray.add(element2);
                            continue;
                        }
                        result.add("status", (JsonElement)new JsonPrimitive("Serialization aborted due to timeout"));
                        src.setHasPartialContent(true);
                        break;
                    }
                    result.add("result", (JsonElement)resultArray);
                } else {
                    result.add("result", this.graphObjectGsonAdapter.serialize((GraphObject)results.get(0), startTime));
                }
            }
        }
        if (searchString != null) {
            result.add("search_string", (JsonElement)new JsonPrimitive(searchString));
        }
        if (sortKey != null) {
            result.add("sort_key", (JsonElement)new JsonPrimitive(sortKey));
        }
        if (sortOrder != null) {
            result.add("sort_order", (JsonElement)new JsonPrimitive(sortOrder));
        }
        if (metaData != null && (element = this.graphObjectGsonAdapter.serialize(metaData, System.currentTimeMillis())) != null) {
            result.add("meta_data", element);
        }
        result.add("serialization_time", (JsonElement)new JsonPrimitive(this.decimalFormat.format((double)(System.nanoTime() - t0) / 1.0E9)));
        return result;
    }

    public Result deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return null;
    }

    public GraphObjectGSONAdapter getGraphObjectGSONAdapter() {
        return this.graphObjectGsonAdapter;
    }
}

