/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.runtime.linq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ssssssss.script.functions.MapExtension;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.runtime.Variables;
import org.ssssssss.script.runtime.function.MagicScriptLambdaFunction;
import org.ssssssss.script.runtime.handle.OperatorHandle;
import org.ssssssss.script.runtime.linq.JoinValue;
import org.ssssssss.script.runtime.linq.LinQJoinValue;
import org.ssssssss.script.runtime.linq.LinQOrder;
import org.ssssssss.script.runtime.linq.OrderValue;
import org.ssssssss.script.runtime.linq.Record;
import org.ssssssss.script.runtime.linq.SelectField;
import org.ssssssss.script.runtime.linq.SelectValue;

public class LinQBuilder {
    private final Variables variables;
    private static final Object[] EMPTY_PARAMETER = new Object[0];
    private List<Object> fromObjects;
    private int fromAliasIndex;
    private final List<SelectField> selects = new ArrayList<SelectField>();
    private MagicScriptLambdaFunction where;
    private MagicScriptLambdaFunction having;
    private final List<MagicScriptLambdaFunction> groups = new ArrayList<MagicScriptLambdaFunction>();
    private final List<LinQJoinValue> joins = new ArrayList<LinQJoinValue>();
    private int joinSize = 0;
    private final List<LinQOrder> orders = new ArrayList<LinQOrder>();
    private long limit = Long.MIN_VALUE;
    private long offset = Long.MIN_VALUE;

    private LinQBuilder(Variables variables) {
        this.variables = variables;
    }

    public static LinQBuilder create(Variables variables) {
        return new LinQBuilder(variables);
    }

    public LinQBuilder where(MagicScriptLambdaFunction condition) {
        this.where = condition;
        return this;
    }

    public LinQBuilder from(Object object, int aliasIndex) {
        this.fromAliasIndex = aliasIndex;
        this.fromObjects = this.convertToList(object);
        return this;
    }

    private List<Object> convertToList(Object object) {
        if (object instanceof Map) {
            return MapExtension.asList((Map)object, entry -> Collections.singletonMap(entry[0], entry[1]));
        }
        try {
            return StreamExtension.arrayLikeToList(object);
        }
        catch (Exception e) {
            return Collections.singletonList(object);
        }
    }

    public LinQBuilder group(MagicScriptLambdaFunction function) {
        this.groups.add(function);
        return this;
    }

    public LinQBuilder join(MagicScriptLambdaFunction condition, Object object, boolean isLeftJoin, int aliasIndex) {
        this.joins.add(new LinQJoinValue(condition, this.convertToList(object), isLeftJoin, aliasIndex));
        ++this.joinSize;
        return this;
    }

    public LinQBuilder having(MagicScriptLambdaFunction condition) {
        this.having = condition;
        return this;
    }

    public LinQBuilder order(MagicScriptLambdaFunction function, int order) {
        this.orders.add(new LinQOrder(function, order));
        return this;
    }

    public LinQBuilder select(MagicScriptLambdaFunction function, String aliasName, int aliasIndex) {
        this.selects.add(new SelectField(function, aliasName, aliasIndex));
        return this;
    }

    public Object executeAndFetchFirst() {
        List<?> list = this.execute();
        return list.isEmpty() ? null : list.get(0);
    }

    public LinQBuilder limit(Object limit) {
        this.limit = ObjectConvertExtension.asLong(limit, Long.MIN_VALUE);
        return this;
    }

    public LinQBuilder offset(Object offset) {
        this.offset = ObjectConvertExtension.asLong(offset, Long.MIN_VALUE);
        return this;
    }

    public List<?> execute() {
        List<Record> records = new ArrayList<Record>();
        for (Object object : this.fromObjects) {
            this.variables.setValue(this.fromAliasIndex, object);
            records.addAll(this.processWhere(this.processJoin(object), object));
        }
        records = this.processGroup(records);
        List<SelectValue> result = this.processSelect(records);
        Stream<Map> stream = result.stream().sorted().map(SelectValue::getValue);
        if (this.offset > 0L) {
            stream = stream.skip(this.offset);
        }
        if (this.limit > 0L) {
            stream = stream.limit(this.limit);
        }
        return stream.collect(Collectors.toList());
    }

    private void processRow(Object item, Map<String, Object> row, SelectField field) {
        if (item instanceof Map) {
            row.putAll((Map)item);
        } else if (field.isWhole() && item instanceof List) {
            row.putAll((Map)StreamExtension.first(item));
        } else {
            row.put(field.getAliasName(), item);
        }
    }

    private List<SelectValue> processSelect(List<Record> records) {
        ArrayList<SelectValue> result = new ArrayList<SelectValue>(records.size());
        int fieldSize = this.selects.size();
        for (Record record : records) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(fieldSize);
            this.variables.setValue(this.fromAliasIndex, record.getValue());
            record.setVariableValue(this.variables);
            for (SelectField field : this.selects) {
                MagicScriptLambdaFunction function = field.getFunction();
                if (function == null) {
                    this.processRow(record.getValue(), row, field);
                    record.getJoinValues().forEach(item -> this.processRow(item, row, field));
                    continue;
                }
                this.processRow(this.apply(function, this.variables, EMPTY_PARAMETER), row, field);
            }
            ArrayList<OrderValue> orderValues = new ArrayList<OrderValue>();
            if (!this.orders.isEmpty()) {
                for (LinQOrder order : this.orders) {
                    orderValues.add(new OrderValue(this.apply(order.getFunction(), this.variables, EMPTY_PARAMETER), order.getOrder()));
                }
            }
            result.add(new SelectValue(row, orderValues));
            record.removeVariableValue(this.variables);
        }
        return result;
    }

    private List<Record> processGroup(List<Record> records) {
        if (!this.groups.isEmpty()) {
            LinkedHashMap<List, List> group = new LinkedHashMap<List, List>();
            for (Record record : records) {
                this.variables.setValue(this.fromAliasIndex, record.getValue());
                record.setVariableValue(this.variables);
                List keys = this.groups.stream().map(field -> this.apply((MagicScriptLambdaFunction)field, this.variables, EMPTY_PARAMETER)).collect(Collectors.toList());
                group.computeIfAbsent(keys, k -> new ArrayList()).add(record);
            }
            records = new ArrayList<Record>();
            for (Map.Entry entry : group.entrySet()) {
                List value = (List)entry.getValue();
                HashMap<Integer, List> joinMap = new HashMap<Integer, List>();
                ArrayList<JoinValue> joinValues = new ArrayList<JoinValue>();
                value.stream().map(Record::getJoinValues).flatMap(Collection::stream).forEach(item -> joinMap.computeIfAbsent(item.getIndex(), k -> new ArrayList()).add(item.getValue()));
                joinMap.forEach((key, joinValue) -> joinValues.add(new JoinValue((int)key, joinValue)));
                Record record = new Record(value.stream().map(Record::getValue).collect(Collectors.toList()), joinValues);
                boolean valid = true;
                if (this.having != null) {
                    this.variables.setValue(this.fromAliasIndex, record.getValue());
                    record.setVariableValue(this.variables);
                    valid = OperatorHandle.isTrue(this.apply(this.having, this.variables, EMPTY_PARAMETER));
                }
                if (!valid) continue;
                records.add(record);
            }
        }
        return records;
    }

    private List<Record> processWhere(List<Record> records, Object object) {
        if (this.where != null) {
            this.variables.setValue(this.fromAliasIndex, object);
            return records.stream().peek(record -> record.setVariableValue(this.variables)).filter(record -> OperatorHandle.isTrue(this.apply(this.where, this.variables, EMPTY_PARAMETER))).collect(Collectors.toList());
        }
        return records;
    }

    private Object apply(MagicScriptLambdaFunction function, Variables variables, Object[] args) {
        return function.apply(variables, args);
    }

    private boolean processOtherJoin(int index, Map<Integer, List<Object>> container) {
        if (index < this.joinSize) {
            LinQJoinValue join = this.joins.get(index);
            boolean matched = false;
            for (Object joinItem : join.getTarget()) {
                this.variables.setValue(join.getAliasIndex(), joinItem);
                if (!OperatorHandle.isTrue(this.apply(join.getCondition(), this.variables, EMPTY_PARAMETER))) continue;
                matched = true;
                if (this.processOtherJoin(index + 1, container)) continue;
                container.get(join.getAliasIndex()).add(joinItem);
            }
            this.variables.setValue(join.getAliasIndex(), Collections.emptyMap());
            if (!matched) {
                if (!join.isLeftJoin()) {
                    return true;
                }
                return this.processOtherJoin(index + 1, container);
            }
        }
        return false;
    }

    private List<Record> processJoin(Object object) {
        if (this.joinSize == 0) {
            return Collections.singletonList(new Record(object));
        }
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>(this.joinSize);
        this.joins.forEach(join -> map.put(join.getAliasIndex(), new ArrayList()));
        if (this.processOtherJoin(0, map)) {
            return Collections.emptyList();
        }
        int maxSize = map.values().stream().mapToInt(Collection::size).max().getAsInt();
        if (maxSize == 0) {
            return Collections.singletonList(new Record(object, map.keySet().stream().map(objects -> new JoinValue((int)objects, Collections.emptyMap())).collect(Collectors.toList())));
        }
        ArrayList<Record> records = new ArrayList<Record>(maxSize);
        Set entries = map.entrySet();
        for (int i = 0; i < maxSize; ++i) {
            ArrayList<JoinValue> joinValues = new ArrayList<JoinValue>(entries.size());
            for (Map.Entry entry : entries) {
                List item = (List)entry.getValue();
                int size = item.size();
                if (size <= 0) continue;
                if (size > i) {
                    joinValues.add(new JoinValue((Integer)entry.getKey(), item.get(i)));
                    continue;
                }
                joinValues.add(new JoinValue((Integer)entry.getKey(), Collections.emptyMap()));
            }
            records.add(new Record(object, joinValues));
        }
        return records;
    }
}

