/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast;

import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.runtime.handle.OperatorHandle;

public class TernaryOperation
extends Expression {
    private final Expression condition;
    private final Expression trueExpression;
    private final Expression falseExpression;

    public TernaryOperation(Expression condition, Expression trueExpression, Expression falseExpression) {
        super(new Span(condition.getSpan(), falseExpression.getSpan()));
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.condition.visitMethod(compiler);
        this.trueExpression.visitMethod(compiler);
        this.falseExpression.visitMethod(compiler);
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        Label end = new Label();
        Label falseValue = new Label();
        compiler.compile(this.condition).invoke(184, OperatorHandle.class, "isTrue", Boolean.TYPE, Object.class).jump(153, falseValue).visit(this.trueExpression).jump(167, end).label(falseValue).visit(this.falseExpression).label(end);
    }
}

