/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.runtime;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ssssssss.script.MagicScriptContext;

public class Variables {
    private final Object[] elements;
    private Variables parent;
    private int[] args;
    private int argLength = -1;
    private int scopeIndex = -1;

    public Variables(int size) {
        this.elements = new Object[size];
    }

    public Variables(Object[] elements, int scopeIndex, int[] args) {
        int len = elements.length;
        this.scopeIndex = scopeIndex;
        this.elements = new Object[len];
        this.args = args;
        this.argLength = args.length;
    }

    public Object getValue(int index) {
        Object value = this.elements[index];
        if (value == null) {
            return this.parent == null ? null : this.parent.getValue(index);
        }
        return value;
    }

    public void setScopeValue(int index, Object value) {
        if (index > -1) {
            this.elements[index] = value;
        }
    }

    public void setValue(int index, Object value) {
        if (index > -1) {
            this.elements[index] = value;
            Variables target = this.parent;
            while (target != null && this.argLength > -1 && target.scopeIndex != this.scopeIndex) {
                for (int i = 0; i < this.argLength; ++i) {
                    if (index != this.args[i]) continue;
                    return;
                }
                target.elements[index] = value;
                target = target.parent;
            }
        }
    }

    public Variables copy(Object[] target, int scopeIndex, int ... args) {
        int len;
        Variables variables = new Variables(this.elements, scopeIndex, args);
        variables.parent = this;
        int n = len = target == null ? 0 : Math.min(args.length, target.length);
        for (int i = 0; i < len; ++i) {
            variables.setValue(args[i], target[i]);
        }
        return variables;
    }

    public Map<String, Object> getVariables(MagicScriptContext context) {
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(context.getRootVariables());
        Variables p = this.parent;
        ArrayList<Object[]> elements = new ArrayList<Object[]>();
        elements.add(this.elements);
        while (p != null) {
            elements.add(p.elements);
            p = p.parent;
        }
        String[] varNames = context.getVarNames();
        for (int j = elements.size() - 1; j >= 0; --j) {
            Object[] element = (Object[])elements.get(j);
            int len = element.length;
            for (int i = 0; i < len; ++i) {
                Object value = element[i];
                if (value == null) continue;
                variables.put(varNames[i], value);
            }
        }
        variables.remove("-anonymous");
        return variables;
    }
}

