/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.Collections;
import java.util.List;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.parsing.ast.statement.VariableDefine;

public class TryStatement
extends Node {
    private final VarIndex exceptionVarNode;
    private final List<Node> tryBlock;
    private final List<VariableDefine> tryResources;
    private final List<Node> catchBlock;
    private final List<Node> finallyBlock;

    public TryStatement(Span span, VarIndex exceptionVarNode, List<Node> tryBlock, final List<VariableDefine> tryResources, List<Node> catchBlock, List<Node> finallyBlock) {
        super(span);
        this.exceptionVarNode = exceptionVarNode;
        this.tryBlock = tryBlock;
        this.tryResources = tryResources;
        Collections.reverse(this.tryResources);
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
        this.finallyBlock.add(0, new Node(new Span("auto close")){

            @Override
            public void visitMethod(MagicScriptCompiler compiler) {
                tryResources.forEach(it -> it.visitMethod(compiler));
            }

            @Override
            public void compile(MagicScriptCompiler compiler) {
                tryResources.forEach(it -> compiler.load(it.getVarIndex()).invoke(184, TryStatement.class, "autoClose", Void.TYPE, Object.class));
            }
        });
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.tryBlock.forEach(it -> it.visitMethod(compiler));
        this.catchBlock.forEach(it -> it.visitMethod(compiler));
        this.finallyBlock.forEach(it -> it.visitMethod(compiler));
    }

    public static void autoClose(Object object) {
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        boolean hasFinally;
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        Label l4 = new Label();
        Label l5 = new Label();
        Label end = new Label();
        boolean hasCatch = this.exceptionVarNode != null;
        boolean bl = hasFinally = !this.finallyBlock.isEmpty();
        if (hasFinally) {
            compiler.putFinallyBlock(this.finallyBlock);
        }
        compiler.label(l0).compile(this.tryResources).compile(this.tryBlock).label(l1);
        if (hasFinally) {
            compiler.compile(this.finallyBlock).jump(167, end);
        }
        compiler.label(l2).store(3).load3().insn(191);
        if (hasCatch) {
            compiler.label(l3).store(3).pre_store(this.exceptionVarNode).load3().store(this.exceptionVarNode).compile(this.catchBlock);
        }
        if (hasFinally) {
            compiler.label(l5).compile(this.finallyBlock).jump(167, end);
            compiler.label(l4).store(3).compile(this.finallyBlock).load3().insn(191);
            compiler.getFinallyBlock();
        }
        compiler.label(end);
        compiler.tryCatch(l0, l1, l2, MagicExitException.class);
        if (hasCatch) {
            compiler.tryCatch(l0, l1, l3, Throwable.class);
        }
        if (hasFinally) {
            compiler.tryCatch(l0, l1, l4, null);
            compiler.tryCatch(l2, l5, l4, null);
        }
    }
}

