/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Literal;

public class ByteLiteral
extends Literal {
    private byte value;

    public ByteLiteral(Span literal) {
        super(literal);
        try {
            this.value = Byte.parseByte(literal.getText().substring(0, literal.getText().length() - 1).replace("_", ""));
        }
        catch (NumberFormatException e) {
            MagicScriptError.error("\u5b9a\u4e49byte\u53d8\u91cf\u503c\u4e0d\u5408\u6cd5", literal, e);
        }
    }

    public ByteLiteral(Span span, Object value) {
        super(span, value);
        this.value = ((Number)value).byteValue();
    }

    @Override
    public void compile(MagicScriptCompiler context) {
        context.bipush(this.value).invoke(184, Byte.class, "valueOf", Byte.class, Byte.TYPE);
    }
}

