/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.runtime.handle;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.ssssssss.script.runtime.handle.MethodCallSite;

public class ArithmeticHandle {
    private static final MethodHandle FALLBACK;
    private static final Map<String, String> OPERATORS;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, int count) {
        MethodCallSite callSite = new MethodCallSite(caller, name, type, ArithmeticHandle.class);
        MethodHandle fallback = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
        callSite.setTarget(fallback);
        callSite.fallback = fallback;
        return callSite;
    }

    public static Object fallback(MethodCallSite callSite, Object[] args) throws Throwable {
        MethodHandle target;
        Class<Object> arg1Class = args[0] == null ? Object.class : args[0].getClass();
        Class<Object> arg2Class = args[1] == null ? Object.class : args[1].getClass();
        try {
            target = callSite.findStatic(MethodType.methodType(Object.class, arg1Class, arg2Class));
        }
        catch (Throwable ignored) {
            try {
                target = callSite.findStatic(callSite.methodName + "_fallback", MethodType.methodType(Object.class, Object.class, Object.class));
            }
            catch (Throwable t) {
                return ArithmeticHandle.reject(args[0], args[1], OPERATORS.getOrDefault(callSite.methodName, callSite.methodName));
            }
        }
        target = target.asType(MethodType.methodType(Object.class, Object.class, Object.class));
        target = MethodHandles.catchException(target, ClassCastException.class, MethodHandles.dropArguments(callSite.fallback, 0, new Class[]{ClassCastException.class}));
        callSite.setTarget(target);
        return target.invokeWithArguments(args);
    }

    public static Object plus(Byte a, Byte b) {
        return a + b;
    }

    public static Object plus(Byte a, Short b) {
        return a + b;
    }

    public static Object plus(Byte a, Integer b) {
        return a + b;
    }

    public static Object plus(Byte a, Float b) {
        return Float.valueOf((float)a.byteValue() + b.floatValue());
    }

    public static Object plus(Byte a, Double b) {
        return (double)a.byteValue() + b;
    }

    public static Object plus(Byte a, Long b) {
        return (long)a.byteValue() + b;
    }

    public static Object plus(Byte a, BigDecimal b) {
        return b.add(new BigDecimal(a.byteValue()));
    }

    public static Object plus(Byte a, BigInteger b) {
        return b.add(BigInteger.valueOf(a.byteValue()));
    }

    public static Object plus(Byte a, String b) {
        return a + b;
    }

    public static Object plus(Short a, Byte b) {
        return a + b;
    }

    public static Object plus(Short a, Short b) {
        return a + b;
    }

    public static Object plus(Short a, Integer b) {
        return a + b;
    }

    public static Object plus(Short a, Float b) {
        return Float.valueOf((float)a.shortValue() + b.floatValue());
    }

    public static Object plus(Short a, Double b) {
        return (double)a.shortValue() + b;
    }

    public static Object plus(Short a, Long b) {
        return (long)a.shortValue() + b;
    }

    public static Object plus(Short a, BigDecimal b) {
        return b.add(new BigDecimal(a.shortValue()));
    }

    public static Object plus(Short a, BigInteger b) {
        return b.add(BigInteger.valueOf(a.shortValue()));
    }

    public static Object plus(Short a, String b) {
        return a + b;
    }

    public static Object plus(Integer a, Byte b) {
        return a + b;
    }

    public static Object plus(Integer a, Short b) {
        return a + b;
    }

    public static Object plus(Integer a, Integer b) {
        return a + b;
    }

    public static Object plus(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() + b.floatValue());
    }

    public static Object plus(Integer a, Double b) {
        return (double)a.intValue() + b;
    }

    public static Object plus(Integer a, Long b) {
        return (long)a.intValue() + b;
    }

    public static Object plus(Integer a, BigDecimal b) {
        return b.add(new BigDecimal(a));
    }

    public static Object plus(Integer a, BigInteger b) {
        return b.add(BigInteger.valueOf(a.intValue()));
    }

    public static Object plus(Integer a, String b) {
        return a + b;
    }

    public static Object plus(Float a, Byte b) {
        return Float.valueOf(a.floatValue() + (float)b.byteValue());
    }

    public static Object plus(Float a, Short b) {
        return Float.valueOf(a.floatValue() + (float)b.shortValue());
    }

    public static Object plus(Float a, Integer b) {
        return Float.valueOf(a.floatValue() + (float)b.intValue());
    }

    public static Object plus(Float a, Float b) {
        return Float.valueOf(a.floatValue() + b.floatValue());
    }

    public static Object plus(Float a, Double b) {
        return (double)a.floatValue() + b;
    }

    public static Object plus(Float a, Long b) {
        return Float.valueOf(a.floatValue() + (float)b.longValue());
    }

    public static Object plus(Float a, BigDecimal b) {
        return b.add(new BigDecimal(a.toString()));
    }

    public static Object plus(Float a, BigInteger b) {
        return new BigDecimal(b).add(new BigDecimal(a.toString()));
    }

    public static Object plus(Float a, String b) {
        return a + b;
    }

    public static Object plus(Double a, Byte b) {
        return a + (double)b.byteValue();
    }

    public static Object plus(Double a, Short b) {
        return a + (double)b.shortValue();
    }

    public static Object plus(Double a, Integer b) {
        return a + (double)b.intValue();
    }

    public static Object plus(Double a, Float b) {
        return a + (double)b.floatValue();
    }

    public static Object plus(Double a, Double b) {
        return a + b;
    }

    public static Object plus(Double a, Long b) {
        return a + (double)b.longValue();
    }

    public static Object plus(Double a, BigDecimal b) {
        return b.add(new BigDecimal(a.toString()));
    }

    public static Object plus(Double a, BigInteger b) {
        return new BigDecimal(b).add(new BigDecimal(a.toString()));
    }

    public static Object plus(Double a, String b) {
        return a + b;
    }

    public static Object plus(Long a, Byte b) {
        return a + (long)b.byteValue();
    }

    public static Object plus(Long a, Short b) {
        return a + (long)b.shortValue();
    }

    public static Object plus(Long a, Integer b) {
        return a + (long)b.intValue();
    }

    public static Object plus(Long a, Float b) {
        return Float.valueOf((float)a.longValue() + b.floatValue());
    }

    public static Object plus(Long a, Double b) {
        return (double)a.longValue() + b;
    }

    public static Object plus(Long a, Long b) {
        return a + b;
    }

    public static Object plus(Long a, BigDecimal b) {
        return b.add(new BigDecimal(a));
    }

    public static Object plus(Long a, BigInteger b) {
        return b.add(BigInteger.valueOf(a));
    }

    public static Object plus(Long a, String b) {
        return a + b;
    }

    public static Object plus(BigDecimal a, Byte b) {
        return a.add(new BigDecimal(b.byteValue()));
    }

    public static Object plus(BigDecimal a, Short b) {
        return a.add(new BigDecimal(b.shortValue()));
    }

    public static Object plus(BigDecimal a, Integer b) {
        return a.add(new BigDecimal(b));
    }

    public static Object plus(BigDecimal a, Float b) {
        return a.add(new BigDecimal(b.toString()));
    }

    public static Object plus(BigDecimal a, Double b) {
        return a.add(new BigDecimal(b.toString()));
    }

    public static Object plus(BigDecimal a, Long b) {
        return a.add(new BigDecimal(b));
    }

    public static Object plus(BigDecimal a, BigDecimal b) {
        return a.add(b);
    }

    public static Object plus(BigDecimal a, BigInteger b) {
        return a.add(new BigDecimal(b));
    }

    public static Object plus(BigDecimal a, String b) {
        return a + b;
    }

    public static Object plus(BigInteger a, Byte b) {
        return a.add(BigInteger.valueOf(b.byteValue()));
    }

    public static Object plus(BigInteger a, Short b) {
        return a.add(BigInteger.valueOf(b.shortValue()));
    }

    public static Object plus(BigInteger a, Integer b) {
        return a.add(BigInteger.valueOf(b.intValue()));
    }

    public static Object plus(BigInteger a, Float b) {
        return new BigDecimal(a).add(new BigDecimal(b.toString()));
    }

    public static Object plus(BigInteger a, Double b) {
        return new BigDecimal(a).add(new BigDecimal(b.toString()));
    }

    public static Object plus(BigInteger a, Long b) {
        return a.add(BigInteger.valueOf(b));
    }

    public static Object plus(BigInteger a, BigDecimal b) {
        return new BigDecimal(a).add(b);
    }

    public static Object plus(BigInteger a, BigInteger b) {
        return a.add(b);
    }

    public static Object plus(BigInteger a, String b) {
        return a + b;
    }

    public static Object plus(String a, Byte b) {
        return a + b;
    }

    public static Object plus(String a, Short b) {
        return a + b;
    }

    public static Object plus(String a, Integer b) {
        return a + b;
    }

    public static Object plus(String a, Float b) {
        return a + b;
    }

    public static Object plus(String a, Double b) {
        return a + b;
    }

    public static Object plus(String a, Long b) {
        return a + b;
    }

    public static Object plus(String a, BigDecimal b) {
        return a + b;
    }

    public static Object plus(String a, BigInteger b) {
        return a + b;
    }

    public static Object plus(String a, String b) {
        return a + b;
    }

    public static Object plus(String a, Object b) {
        return a + b;
    }

    public static Object plus_fallback(Object a, Object b) {
        if (a == null && b == null) {
            return null;
        }
        return "" + a + b;
    }

    public static Object minus(Byte a, Byte b) {
        return a - b;
    }

    public static Object minus(Byte a, Short b) {
        return a - b;
    }

    public static Object minus(Byte a, Integer b) {
        return a - b;
    }

    public static Object minus(Byte a, Float b) {
        return Float.valueOf((float)a.byteValue() - b.floatValue());
    }

    public static Object minus(Byte a, Double b) {
        return (double)a.byteValue() - b;
    }

    public static Object minus(Byte a, Long b) {
        return (long)a.byteValue() - b;
    }

    public static Object minus(Byte a, BigDecimal b) {
        return new BigDecimal(a.byteValue()).subtract(b);
    }

    public static Object minus(Byte a, BigInteger b) {
        return BigInteger.valueOf(a.byteValue()).subtract(b);
    }

    public static Object minus(Short a, Byte b) {
        return a - b;
    }

    public static Object minus(Short a, Short b) {
        return a - b;
    }

    public static Object minus(Short a, Integer b) {
        return a - b;
    }

    public static Object minus(Short a, Float b) {
        return Float.valueOf((float)a.shortValue() - b.floatValue());
    }

    public static Object minus(Short a, Double b) {
        return (double)a.shortValue() - b;
    }

    public static Object minus(Short a, Long b) {
        return (long)a.shortValue() - b;
    }

    public static Object minus(Short a, BigDecimal b) {
        return new BigDecimal(a.shortValue()).subtract(b);
    }

    public static Object minus(Short a, BigInteger b) {
        return BigInteger.valueOf(a.shortValue()).subtract(b);
    }

    public static Object minus(Integer a, Byte b) {
        return a - b;
    }

    public static Object minus(Integer a, Short b) {
        return a - b;
    }

    public static Object minus(Integer a, Integer b) {
        return a - b;
    }

    public static Object minus(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() - b.floatValue());
    }

    public static Object minus(Integer a, Double b) {
        return (double)a.intValue() - b;
    }

    public static Object minus(Integer a, Long b) {
        return (long)a.intValue() - b;
    }

    public static Object minus(Integer a, BigDecimal b) {
        return new BigDecimal(a).subtract(b);
    }

    public static Object minus(Integer a, BigInteger b) {
        return BigInteger.valueOf(a.intValue()).subtract(b);
    }

    public static Object minus(Float a, Byte b) {
        return Float.valueOf(a.floatValue() - (float)b.byteValue());
    }

    public static Object minus(Float a, Short b) {
        return Float.valueOf(a.floatValue() - (float)b.shortValue());
    }

    public static Object minus(Float a, Integer b) {
        return Float.valueOf(a.floatValue() - (float)b.intValue());
    }

    public static Object minus(Float a, Float b) {
        return Float.valueOf(a.floatValue() - b.floatValue());
    }

    public static Object minus(Float a, Double b) {
        return (double)a.floatValue() - b;
    }

    public static Object minus(Float a, Long b) {
        return Float.valueOf(a.floatValue() - (float)b.longValue());
    }

    public static Object minus(Float a, BigDecimal b) {
        return new BigDecimal(a.toString()).subtract(b);
    }

    public static Object minus(Float a, BigInteger b) {
        return new BigDecimal(b).subtract(new BigDecimal(a.toString()));
    }

    public static Object minus(Double a, Byte b) {
        return a - (double)b.byteValue();
    }

    public static Object minus(Double a, Short b) {
        return a - (double)b.shortValue();
    }

    public static Object minus(Double a, Integer b) {
        return a - (double)b.intValue();
    }

    public static Object minus(Double a, Float b) {
        return a - (double)b.floatValue();
    }

    public static Object minus(Double a, Double b) {
        return a - b;
    }

    public static Object minus(Double a, Long b) {
        return a - (double)b.longValue();
    }

    public static Object minus(Double a, BigDecimal b) {
        return new BigDecimal(a.toString()).subtract(b);
    }

    public static Object minus(Double a, BigInteger b) {
        return new BigDecimal(a.toString()).subtract(new BigDecimal(b));
    }

    public static Object minus(Long a, Byte b) {
        return a - (long)b.byteValue();
    }

    public static Object minus(Long a, Short b) {
        return a - (long)b.shortValue();
    }

    public static Object minus(Long a, Integer b) {
        return a - (long)b.intValue();
    }

    public static Object minus(Long a, Float b) {
        return Float.valueOf((float)a.longValue() - b.floatValue());
    }

    public static Object minus(Long a, Double b) {
        return (double)a.longValue() - b;
    }

    public static Object minus(Long a, Long b) {
        return a - b;
    }

    public static Object minus(Long a, BigDecimal b) {
        return new BigDecimal(a).subtract(b);
    }

    public static Object minus(BigDecimal a, Byte b) {
        return a.subtract(new BigDecimal(b.byteValue()));
    }

    public static Object minus(BigDecimal a, Short b) {
        return a.subtract(new BigDecimal(b.shortValue()));
    }

    public static Object minus(BigDecimal a, Integer b) {
        return a.subtract(new BigDecimal(b));
    }

    public static Object minus(BigDecimal a, Float b) {
        return a.subtract(new BigDecimal(b.toString()));
    }

    public static Object minus(BigDecimal a, Double b) {
        return a.subtract(new BigDecimal(b.toString()));
    }

    public static Object minus(BigDecimal a, Long b) {
        return a.subtract(new BigDecimal(b));
    }

    public static Object minus(BigDecimal a, BigDecimal b) {
        return a.subtract(b);
    }

    public static Object minus(BigDecimal a, BigInteger b) {
        return a.subtract(new BigDecimal(b));
    }

    public static Object minus(BigInteger a, Byte b) {
        return a.subtract(BigInteger.valueOf(b.byteValue()));
    }

    public static Object minus(BigInteger a, Short b) {
        return a.subtract(BigInteger.valueOf(b.shortValue()));
    }

    public static Object minus(BigInteger a, Integer b) {
        return a.subtract(BigInteger.valueOf(b.intValue()));
    }

    public static Object minus(BigInteger a, Float b) {
        return new BigDecimal(a).subtract(new BigDecimal(b.toString()));
    }

    public static Object minus(BigInteger a, Double b) {
        return new BigDecimal(a).subtract(new BigDecimal(b.toString()));
    }

    public static Object minus(BigInteger a, Long b) {
        return a.subtract(BigInteger.valueOf(b));
    }

    public static Object minus(BigInteger a, BigDecimal b) {
        return new BigDecimal(a).subtract(b);
    }

    public static Object minus(BigInteger a, BigInteger b) {
        return a.subtract(b);
    }

    public static Object mul(Byte a, Byte b) {
        return a * b;
    }

    public static Object mul(Byte a, Short b) {
        return a * b;
    }

    public static Object mul(Byte a, Integer b) {
        return a * b;
    }

    public static Object mul(Byte a, Float b) {
        return Float.valueOf((float)a.byteValue() * b.floatValue());
    }

    public static Object mul(Byte a, Double b) {
        return (double)a.byteValue() * b;
    }

    public static Object mul(Byte a, Long b) {
        return (long)a.byteValue() * b;
    }

    public static Object mul(Byte a, BigDecimal b) {
        return new BigDecimal(a.byteValue()).multiply(b);
    }

    public static Object mul(Byte a, BigInteger b) {
        return BigInteger.valueOf(a.byteValue()).multiply(b);
    }

    public static Object mul(Short a, Byte b) {
        return a * b;
    }

    public static Object mul(Short a, Short b) {
        return a * b;
    }

    public static Object mul(Short a, Integer b) {
        return a * b;
    }

    public static Object mul(Short a, Float b) {
        return Float.valueOf((float)a.shortValue() * b.floatValue());
    }

    public static Object mul(Short a, Double b) {
        return (double)a.shortValue() * b;
    }

    public static Object mul(Short a, Long b) {
        return (long)a.shortValue() * b;
    }

    public static Object mul(Short a, BigDecimal b) {
        return new BigDecimal(a.shortValue()).multiply(b);
    }

    public static Object mul(Short a, BigInteger b) {
        return BigInteger.valueOf(a.shortValue()).multiply(b);
    }

    public static Object mul(Integer a, Byte b) {
        return a * b;
    }

    public static Object mul(Integer a, Short b) {
        return a * b;
    }

    public static Object mul(Integer a, Integer b) {
        return a * b;
    }

    public static Object mul(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() * b.floatValue());
    }

    public static Object mul(Integer a, Double b) {
        return (double)a.intValue() * b;
    }

    public static Object mul(Integer a, Long b) {
        return (long)a.intValue() * b;
    }

    public static Object mul(Integer a, BigDecimal b) {
        return new BigDecimal(a).multiply(b);
    }

    public static Object mul(Integer a, BigInteger b) {
        return BigInteger.valueOf(a.intValue()).multiply(b);
    }

    public static Object mul(Float a, Byte b) {
        return Float.valueOf(a.floatValue() * (float)b.byteValue());
    }

    public static Object mul(Float a, Short b) {
        return Float.valueOf(a.floatValue() * (float)b.shortValue());
    }

    public static Object mul(Float a, Integer b) {
        return Float.valueOf(a.floatValue() * (float)b.intValue());
    }

    public static Object mul(Float a, Float b) {
        return Float.valueOf(a.floatValue() * b.floatValue());
    }

    public static Object mul(Float a, Double b) {
        return (double)a.floatValue() * b;
    }

    public static Object mul(Float a, Long b) {
        return Float.valueOf(a.floatValue() * (float)b.longValue());
    }

    public static Object mul(Float a, BigDecimal b) {
        return b.multiply(new BigDecimal(a.toString()));
    }

    public static Object mul(Float a, BigInteger b) {
        return new BigDecimal(b).multiply(new BigDecimal(a.toString()));
    }

    public static Object mul(Double a, Byte b) {
        return a * (double)b.byteValue();
    }

    public static Object mul(Double a, Short b) {
        return a * (double)b.shortValue();
    }

    public static Object mul(Double a, Integer b) {
        return a * (double)b.intValue();
    }

    public static Object mul(Double a, Float b) {
        return a * (double)b.floatValue();
    }

    public static Object mul(Double a, Double b) {
        return a * b;
    }

    public static Object mul(Double a, Long b) {
        return a * (double)b.longValue();
    }

    public static Object mul(Double a, BigDecimal b) {
        return new BigDecimal(a.toString()).multiply(b);
    }

    public static Object mul(Double a, BigInteger b) {
        return new BigDecimal(a.toString()).multiply(new BigDecimal(b));
    }

    public static Object mul(Long a, Byte b) {
        return a * (long)b.byteValue();
    }

    public static Object mul(Long a, Short b) {
        return a * (long)b.shortValue();
    }

    public static Object mul(Long a, Integer b) {
        return a * (long)b.intValue();
    }

    public static Object mul(Long a, Float b) {
        return Float.valueOf((float)a.longValue() * b.floatValue());
    }

    public static Object mul(Long a, Double b) {
        return (double)a.longValue() * b;
    }

    public static Object mul(Long a, Long b) {
        return a * b;
    }

    public static Object mul(Long a, BigDecimal b) {
        return new BigDecimal(a).multiply(b);
    }

    public static Object mul(Long a, BigInteger b) {
        return BigInteger.valueOf(a).multiply(b);
    }

    public static Object mul(BigDecimal a, Byte b) {
        return a.multiply(new BigDecimal(b.byteValue()));
    }

    public static Object mul(BigDecimal a, Short b) {
        return a.multiply(new BigDecimal(b.shortValue()));
    }

    public static Object mul(BigDecimal a, Integer b) {
        return a.multiply(new BigDecimal(b));
    }

    public static Object mul(BigDecimal a, Float b) {
        return a.multiply(new BigDecimal(b.toString()));
    }

    public static Object mul(BigDecimal a, Double b) {
        return a.multiply(new BigDecimal(b.toString()));
    }

    public static Object mul(BigDecimal a, Long b) {
        return a.multiply(new BigDecimal(b));
    }

    public static Object mul(BigDecimal a, BigDecimal b) {
        return a.multiply(b);
    }

    public static Object mul(BigDecimal a, BigInteger b) {
        return a.multiply(new BigDecimal(b));
    }

    public static Object mul(BigInteger a, Byte b) {
        return a.multiply(BigInteger.valueOf(b.byteValue()));
    }

    public static Object mul(BigInteger a, Short b) {
        return a.multiply(BigInteger.valueOf(b.shortValue()));
    }

    public static Object mul(BigInteger a, Integer b) {
        return a.multiply(BigInteger.valueOf(b.intValue()));
    }

    public static Object mul(BigInteger a, Float b) {
        return new BigDecimal(a).multiply(new BigDecimal(b.toString()));
    }

    public static Object mul(BigInteger a, Double b) {
        return new BigDecimal(a).multiply(new BigDecimal(b.toString()));
    }

    public static Object mul(BigInteger a, Long b) {
        return a.multiply(BigInteger.valueOf(b));
    }

    public static Object mul(BigInteger a, BigDecimal b) {
        return new BigDecimal(a).multiply(b);
    }

    public static Object mul(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    public static Object divide(Byte a, Byte b) {
        return a / b;
    }

    public static Object divide(Byte a, Short b) {
        return a / b;
    }

    public static Object divide(Byte a, Integer b) {
        return a / b;
    }

    public static Object divide(Byte a, Float b) {
        return Float.valueOf((float)a.byteValue() / b.floatValue());
    }

    public static Object divide(Byte a, Double b) {
        return (double)a.byteValue() / b;
    }

    public static Object divide(Byte a, Long b) {
        return (long)a.byteValue() / b;
    }

    public static Object divide(Byte a, BigDecimal b) {
        return new BigDecimal(a.byteValue()).divide(b);
    }

    public static Object divide(Byte a, BigInteger b) {
        return BigInteger.valueOf(a.byteValue()).divide(b);
    }

    public static Object divide(Short a, Byte b) {
        return a / b;
    }

    public static Object divide(Short a, Short b) {
        return a / b;
    }

    public static Object divide(Short a, Integer b) {
        return a / b;
    }

    public static Object divide(Short a, Float b) {
        return Float.valueOf((float)a.shortValue() / b.floatValue());
    }

    public static Object divide(Short a, Double b) {
        return (double)a.shortValue() / b;
    }

    public static Object divide(Short a, Long b) {
        return (long)a.shortValue() / b;
    }

    public static Object divide(Short a, BigDecimal b) {
        return new BigDecimal(a.shortValue()).divide(b);
    }

    public static Object divide(Short a, BigInteger b) {
        return BigInteger.valueOf(a.shortValue()).divide(b);
    }

    public static Object divide(Integer a, Byte b) {
        return a / b;
    }

    public static Object divide(Integer a, Short b) {
        return a / b;
    }

    public static Object divide(Integer a, Integer b) {
        return a / b;
    }

    public static Object divide(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() / b.floatValue());
    }

    public static Object divide(Integer a, Double b) {
        return (double)a.intValue() / b;
    }

    public static Object divide(Integer a, Long b) {
        return (long)a.intValue() / b;
    }

    public static Object divide(Integer a, BigDecimal b) {
        return new BigDecimal(a).divide(b);
    }

    public static Object divide(Integer a, BigInteger b) {
        return BigInteger.valueOf(a.intValue()).divide(b);
    }

    public static Object divide(Float a, Byte b) {
        return Float.valueOf(a.floatValue() / (float)b.byteValue());
    }

    public static Object divide(Float a, Short b) {
        return Float.valueOf(a.floatValue() / (float)b.shortValue());
    }

    public static Object divide(Float a, Integer b) {
        return Float.valueOf(a.floatValue() / (float)b.intValue());
    }

    public static Object divide(Float a, Float b) {
        return Float.valueOf(a.floatValue() / b.floatValue());
    }

    public static Object divide(Float a, Double b) {
        return (double)a.floatValue() / b;
    }

    public static Object divide(Float a, Long b) {
        return Float.valueOf(a.floatValue() / (float)b.longValue());
    }

    public static Object divide(Float a, BigDecimal b) {
        return new BigDecimal(a.toString()).divide(b);
    }

    public static Object divide(Float a, BigInteger b) {
        return new BigDecimal(a.toString()).divide(new BigDecimal(b));
    }

    public static Object divide(Double a, Byte b) {
        return a / (double)b.byteValue();
    }

    public static Object divide(Double a, Short b) {
        return a / (double)b.shortValue();
    }

    public static Object divide(Double a, Integer b) {
        return a / (double)b.intValue();
    }

    public static Object divide(Double a, Float b) {
        return a / (double)b.floatValue();
    }

    public static Object divide(Double a, Double b) {
        return a / b;
    }

    public static Object divide(Double a, Long b) {
        return a / (double)b.longValue();
    }

    public static Object divide(Double a, BigDecimal b) {
        return new BigDecimal(a.toString()).divide(b);
    }

    public static Object divide(Double a, BigInteger b) {
        return new BigDecimal(a.toString()).divide(new BigDecimal(b));
    }

    public static Object divide(Long a, Byte b) {
        return a / (long)b.byteValue();
    }

    public static Object divide(Long a, Short b) {
        return a / (long)b.shortValue();
    }

    public static Object divide(Long a, Integer b) {
        return a / (long)b.intValue();
    }

    public static Object divide(Long a, Float b) {
        return Float.valueOf((float)a.longValue() / b.floatValue());
    }

    public static Object divide(Long a, Double b) {
        return (double)a.longValue() / b;
    }

    public static Object divide(Long a, Long b) {
        return a / b;
    }

    public static Object divide(Long a, BigDecimal b) {
        return new BigDecimal(a).divide(b);
    }

    public static Object divide(Long a, BigInteger b) {
        return BigInteger.valueOf(a).divide(b);
    }

    public static Object divide(BigDecimal a, Byte b) {
        return a.divide(new BigDecimal(b.byteValue()));
    }

    public static Object divide(BigDecimal a, Short b) {
        return a.divide(new BigDecimal(b.shortValue()));
    }

    public static Object divide(BigDecimal a, Integer b) {
        return a.divide(new BigDecimal(b));
    }

    public static Object divide(BigDecimal a, Float b) {
        return a.divide(new BigDecimal(b.toString()));
    }

    public static Object divide(BigDecimal a, Double b) {
        return a.divide(new BigDecimal(b.toString()));
    }

    public static Object divide(BigDecimal a, Long b) {
        return a.divide(new BigDecimal(b));
    }

    public static Object divide(BigDecimal a, BigDecimal b) {
        return a.divide(b);
    }

    public static Object divide(BigDecimal a, BigInteger b) {
        return a.divide(new BigDecimal(b));
    }

    public static Object divide(BigInteger a, Byte b) {
        return a.divide(BigInteger.valueOf(b.byteValue()));
    }

    public static Object divide(BigInteger a, Short b) {
        return a.divide(BigInteger.valueOf(b.shortValue()));
    }

    public static Object divide(BigInteger a, Integer b) {
        return a.divide(BigInteger.valueOf(b.intValue()));
    }

    public static Object divide(BigInteger a, Float b) {
        return new BigDecimal(a).divide(new BigDecimal(b.toString()));
    }

    public static Object divide(BigInteger a, Double b) {
        return new BigDecimal(a).divide(new BigDecimal(b.toString()));
    }

    public static Object divide(BigInteger a, Long b) {
        return a.divide(BigInteger.valueOf(b));
    }

    public static Object divide(BigInteger a, BigDecimal b) {
        return new BigDecimal(a).divide(b);
    }

    public static Object divide(BigInteger a, BigInteger b) {
        return a.divide(b);
    }

    public static Object divideAndRemainder(Byte a, Byte b) {
        return a % b;
    }

    public static Object divideAndRemainder(Byte a, Short b) {
        return a % b;
    }

    public static Object divideAndRemainder(Byte a, Integer b) {
        return a % b;
    }

    public static Object divideAndRemainder(Byte a, Float b) {
        return Float.valueOf((float)a.byteValue() % b.floatValue());
    }

    public static Object divideAndRemainder(Byte a, Double b) {
        return (double)a.byteValue() % b;
    }

    public static Object divideAndRemainder(Byte a, Long b) {
        return (long)a.byteValue() % b;
    }

    public static Object divideAndRemainder(Byte a, BigDecimal b) {
        return new BigDecimal(a.byteValue()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Short a, Byte b) {
        return a % b;
    }

    public static Object divideAndRemainder(Short a, Short b) {
        return a % b;
    }

    public static Object divideAndRemainder(Short a, Integer b) {
        return a % b;
    }

    public static Object divideAndRemainder(Short a, Float b) {
        return Float.valueOf((float)a.shortValue() % b.floatValue());
    }

    public static Object divideAndRemainder(Short a, Double b) {
        return (double)a.shortValue() % b;
    }

    public static Object divideAndRemainder(Short a, Long b) {
        return (long)a.shortValue() % b;
    }

    public static Object divideAndRemainder(Short a, BigDecimal b) {
        return new BigDecimal(a.shortValue()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Short a, BigInteger b) {
        return BigInteger.valueOf(a.shortValue()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Integer a, Byte b) {
        return a % b;
    }

    public static Object divideAndRemainder(Integer a, Short b) {
        return a % b;
    }

    public static Object divideAndRemainder(Integer a, Integer b) {
        return a % b;
    }

    public static Object divideAndRemainder(Integer a, Float b) {
        return Float.valueOf((float)a.intValue() % b.floatValue());
    }

    public static Object divideAndRemainder(Integer a, Double b) {
        return (double)a.intValue() % b;
    }

    public static Object divideAndRemainder(Integer a, Long b) {
        return (long)a.intValue() % b;
    }

    public static Object divideAndRemainder(Integer a, BigDecimal b) {
        return new BigDecimal(a).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Integer a, BigInteger b) {
        return BigInteger.valueOf(a.intValue()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Float a, Byte b) {
        return Float.valueOf(a.floatValue() % (float)b.byteValue());
    }

    public static Object divideAndRemainder(Float a, Short b) {
        return Float.valueOf(a.floatValue() % (float)b.shortValue());
    }

    public static Object divideAndRemainder(Float a, Integer b) {
        return Float.valueOf(a.floatValue() % (float)b.intValue());
    }

    public static Object divideAndRemainder(Float a, Float b) {
        return Float.valueOf(a.floatValue() % b.floatValue());
    }

    public static Object divideAndRemainder(Float a, Double b) {
        return (double)a.floatValue() % b;
    }

    public static Object divideAndRemainder(Float a, Long b) {
        return Float.valueOf(a.floatValue() % (float)b.longValue());
    }

    public static Object divideAndRemainder(Float a, BigDecimal b) {
        return new BigDecimal(a.toString()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Float a, BigInteger b) {
        return new BigDecimal(a.toString()).divideAndRemainder(new BigDecimal(b));
    }

    public static Object divideAndRemainder(Double a, Byte b) {
        return a % (double)b.byteValue();
    }

    public static Object divideAndRemainder(Double a, Short b) {
        return a % (double)b.shortValue();
    }

    public static Object divideAndRemainder(Double a, Integer b) {
        return a % (double)b.intValue();
    }

    public static Object divideAndRemainder(Double a, Float b) {
        return a % (double)b.floatValue();
    }

    public static Object divideAndRemainder(Double a, Double b) {
        return a % b;
    }

    public static Object divideAndRemainder(Double a, Long b) {
        return a % (double)b.longValue();
    }

    public static Object divideAndRemainder(Double a, BigDecimal b) {
        return new BigDecimal(a.toString()).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Double a, BigInteger b) {
        return new BigDecimal(a.toString()).divideAndRemainder(new BigDecimal(b));
    }

    public static Object divideAndRemainder(Long a, Byte b) {
        return a % (long)b.byteValue();
    }

    public static Object divideAndRemainder(Long a, Short b) {
        return a % (long)b.shortValue();
    }

    public static Object divideAndRemainder(Long a, Integer b) {
        return a % (long)b.intValue();
    }

    public static Object divideAndRemainder(Long a, Float b) {
        return Float.valueOf((float)a.longValue() % b.floatValue());
    }

    public static Object divideAndRemainder(Long a, Double b) {
        return (double)a.longValue() % b;
    }

    public static Object divideAndRemainder(Long a, Long b) {
        return a % b;
    }

    public static Object divideAndRemainder(Long a, BigDecimal b) {
        return new BigDecimal(a).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(Long a, BigInteger b) {
        return BigInteger.valueOf(a).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(BigDecimal a, Byte b) {
        return a.divideAndRemainder(new BigDecimal(b.byteValue()));
    }

    public static Object divideAndRemainder(BigDecimal a, Short b) {
        return a.divideAndRemainder(new BigDecimal(b.shortValue()));
    }

    public static Object divideAndRemainder(BigDecimal a, Integer b) {
        return a.divideAndRemainder(new BigDecimal(b));
    }

    public static Object divideAndRemainder(BigDecimal a, Float b) {
        return a.divideAndRemainder(new BigDecimal(b.toString()));
    }

    public static Object divideAndRemainder(BigDecimal a, Double b) {
        return a.divideAndRemainder(new BigDecimal(b.toString()));
    }

    public static Object divideAndRemainder(BigDecimal a, Long b) {
        return a.divideAndRemainder(new BigDecimal(b));
    }

    public static Object divideAndRemainder(BigDecimal a, BigDecimal b) {
        return a.divideAndRemainder(b);
    }

    public static Object divideAndRemainder(BigDecimal a, BigInteger b) {
        return a.divideAndRemainder(new BigDecimal(b));
    }

    public static Object divideAndRemainder(BigInteger a, Byte b) {
        return a.divideAndRemainder(BigInteger.valueOf(b.byteValue()));
    }

    public static Object divideAndRemainder(BigInteger a, Short b) {
        return a.divideAndRemainder(BigInteger.valueOf(b.shortValue()));
    }

    public static Object divideAndRemainder(BigInteger a, Integer b) {
        return a.divideAndRemainder(BigInteger.valueOf(b.intValue()));
    }

    public static Object divideAndRemainder(BigInteger a, Float b) {
        return new BigDecimal(a).divideAndRemainder(new BigDecimal(b.toString()));
    }

    public static Object divideAndRemainder(BigInteger a, Double b) {
        return new BigDecimal(a).divideAndRemainder(new BigDecimal(b.toString()));
    }

    public static Object divideAndRemainder(BigInteger a, Long b) {
        return a.divideAndRemainder(BigInteger.valueOf(b));
    }

    public static Object divideAndRemainder(BigInteger a, BigDecimal b) {
        return new BigDecimal(a).divideAndRemainder(b);
    }

    public static Object divideAndRemainder(BigInteger a, BigInteger b) {
        return a.divideAndRemainder(b);
    }

    private static Object reject(Object a, Object b, String symbol) throws IllegalArgumentException {
        throw new IllegalArgumentException(String.format("`%s` \u8fd0\u7b97\u4e0d\u652f\u6301 (%s,%s) \u7c7b\u578b", symbol, a == null ? "null" : a.getClass().getName(), b == null ? "null" : b.getClass().getName()));
    }

    static {
        OPERATORS = new HashMap<String, String>(5);
        try {
            OPERATORS.put("plus", "+");
            OPERATORS.put("minus", "-");
            OPERATORS.put("mul", "*");
            OPERATORS.put("divide", "/");
            OPERATORS.put("divideAndRemainder", "%");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            FALLBACK = lookup.findStatic(ArithmeticHandle.class, "fallback", MethodType.methodType(Object.class, MethodCallSite.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("ArithmeticHandle\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }
}

