/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.statement.MemberAccess;
import org.ssssssss.script.parsing.ast.statement.Spread;

public class MethodCall
extends Expression {
    private final MemberAccess method;
    private final List<Expression> arguments;
    private final boolean inLinq;

    public MethodCall(Span span, MemberAccess method, List<Expression> arguments, boolean inLinq) {
        super(span);
        this.method = method;
        this.arguments = arguments;
        this.inLinq = inLinq;
    }

    public MemberAccess getMethod() {
        return this.method;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.method.visitMethod(compiler);
        this.arguments.forEach(it -> it.visitMethod(compiler));
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        int size = this.arguments.size();
        compiler.newRuntimeContext().ldc(this.method.getName().getText()).insn(this.arguments.stream().anyMatch(it -> it instanceof Spread) ? 4 : 3).asBoolean().insn(this.method.isOptional() ? 4 : 3).asBoolean().visitInt(size).typeInsn(189, Object.class);
        for (int i = 0; i < size; ++i) {
            Expression argument = this.arguments.get(i);
            compiler.insn(89).visitInt(i);
            if (this.inLinq && argument instanceof MemberAccess) {
                ((MemberAccess)argument).compileLinq(compiler);
            } else {
                compiler.visit(argument);
            }
            compiler.insn(83);
        }
        compiler.visit(this.method.getObject()).lineNumber(this.getSpan()).call("invoke_method", 6);
    }
}

