/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Literal;

public class BooleanLiteral
extends Literal {
    public BooleanLiteral(Span literal) {
        super(literal, Boolean.parseBoolean(literal.getText()));
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() != 0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof Collection) {
            return !((Collection)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) > 0;
        }
        if (object instanceof Map) {
            return !((Map)object).isEmpty();
        }
        return true;
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        compiler.insn((Boolean)this.value != false ? 4 : 3).asBoolean();
    }
}

