/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.ArrayList;
import java.util.List;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.exception.StringLiteralException;
import org.ssssssss.script.parsing.CharacterStream;
import org.ssssssss.script.parsing.LiteralToken;
import org.ssssssss.script.parsing.RegexpToken;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenStream;
import org.ssssssss.script.parsing.TokenType;

public class Tokenizer {
    public static TokenStream tokenize(String source) {
        return Tokenizer.tokenize(source, false);
    }

    public static TokenStream tokenize(String source, boolean matchComment) {
        CharacterStream stream = new CharacterStream(source, 0, source.length());
        ArrayList<Token> tokens = new ArrayList<Token>();
        Tokenizer.tokenizer(stream, tokens, matchComment, null);
        return new TokenStream(tokens);
    }

    private static List<Token> tokenizer(CharacterStream stream, List<Token> tokens, boolean matchComment, String except) {
        int leftCount = 0;
        int rightCount = 0;
        block0: while (stream.hasMore()) {
            stream.skipWhiteSpace();
            stream.startSpan();
            if (except != null && stream.match(except, true)) {
                return tokens;
            }
            if (Tokenizer.tokenizerComment(stream, tokens, matchComment) || Tokenizer.tokenizerNumber(stream, tokens) || Tokenizer.tokenizerString(stream, TokenType.SingleQuote, tokens) || Tokenizer.tokenizerString(stream, TokenType.TripleQuote, tokens) || Tokenizer.tokenizerString(stream, TokenType.DoubleQuote, tokens) || Tokenizer.regexpToken(stream, tokens) || Tokenizer.tokenizerLanguage(stream, tokens) || Tokenizer.tokenizerTemplateString(stream, tokens, matchComment) || Tokenizer.tokenizerIdentifier(stream, tokens)) continue;
            if (stream.match("=>", true) || stream.match("->", true)) {
                tokens.add(new Token(TokenType.Lambda, stream.getSpan(stream.getPosition() - 2, stream.getPosition())));
                continue;
            }
            for (TokenType t : TokenType.getSortedValues()) {
                if (t.getLiteral() == null || !stream.match(t.getLiteral(), true)) continue;
                if (t == TokenType.LeftCurly) {
                    ++leftCount;
                }
                tokens.add(new Token(t, stream.getSpan(stream.getPosition() - t.getLiteral().length(), stream.getPosition())));
                continue block0;
            }
            if (leftCount != rightCount && stream.match("}", true)) {
                ++rightCount;
                tokens.add(new Token(TokenType.RightCurly, stream.getSpan(stream.getPosition() - 1, stream.getPosition())));
                continue;
            }
            if (!stream.hasMore()) continue;
            MagicScriptError.error("Unknown token", stream.getSpan(stream.getPosition(), stream.getPosition() + 1));
        }
        return tokens;
    }

    private static boolean tokenizerLanguage(CharacterStream stream, List<Token> tokens) {
        if (stream.match("```", true)) {
            stream.startSpan();
            if (stream.matchIdentifierStart(true)) {
                while (stream.matchIdentifierPart(true)) {
                }
                Span language = stream.endSpan();
                tokens.add(new Token(TokenType.Language, language));
                stream.startSpan();
                if (!stream.skipUntil("```")) {
                    MagicScriptError.error("```\u9700\u8981\u4ee5```\u7ed3\u5c3e", stream.endSpan(), new StringLiteralException());
                }
                tokens.add(new Token(TokenType.Language, stream.endSpan(-3)));
                return true;
            }
            MagicScriptError.error("```\u540e\u9700\u8981\u6807\u8bc6\u8bed\u8a00\u7c7b\u578b", stream.endSpan(), new StringLiteralException());
        }
        return false;
    }

    private static boolean tokenizerTemplateString(CharacterStream stream, List<Token> tokens, boolean matchComment) {
        if (stream.match("`", true)) {
            int begin;
            int start = begin = stream.getPosition();
            boolean matchedEndQuote = false;
            ArrayList<Token> subTokens = new ArrayList<Token>();
            while (stream.hasMore()) {
                if (stream.match("\\", true)) {
                    stream.consume();
                    continue;
                }
                if (stream.match("`", true)) {
                    matchedEndQuote = true;
                    break;
                }
                if (stream.match("${", true)) {
                    int end = stream.getPosition();
                    if (start < end - 2) {
                        subTokens.add(new LiteralToken(TokenType.StringLiteral, stream.endSpan(start, end - 2)));
                    }
                    subTokens.addAll(Tokenizer.tokenizer(stream, new ArrayList<Token>(), matchComment, "}"));
                    start = stream.getPosition();
                    continue;
                }
                stream.consume();
            }
            if (!matchedEndQuote) {
                MagicScriptError.error("\u6a21\u677f\u5b57\u7b26\u4e32\u6ca1\u6709\u7ed3\u675f\u7b26`", stream.endSpan(), new StringLiteralException());
            }
            Span stringSpan = stream.endSpan(begin, stream.getPosition());
            int end = stream.getPosition() - 1;
            if (end - start > 0) {
                subTokens.add(new LiteralToken(TokenType.StringLiteral, stream.endSpan(start, end)));
            }
            stringSpan = stream.getSpan(stringSpan.getStart() - 1, stringSpan.getEnd());
            tokens.add(new LiteralToken(TokenType.StringLiteral, stringSpan, new TokenStream(subTokens)));
            return true;
        }
        return false;
    }

    private static boolean tokenizerIdentifier(CharacterStream stream, List<Token> tokens) {
        if (stream.matchIdentifierStart(true)) {
            stream.startSpan();
            while (stream.matchIdentifierPart(true)) {
            }
            Span identifierSpan = stream.endSpan();
            if ("true".equals((identifierSpan = stream.getSpan(identifierSpan.getStart() - 1, identifierSpan.getEnd())).getText()) || "false".equals(identifierSpan.getText())) {
                tokens.add(new LiteralToken(TokenType.BooleanLiteral, identifierSpan));
            } else if ("null".equals(identifierSpan.getText())) {
                tokens.add(new LiteralToken(TokenType.NullLiteral, identifierSpan));
            } else if ("instanceof".equals(identifierSpan.getText())) {
                tokens.add(new Token(TokenType.InstanceOf, identifierSpan));
            } else if (TokenType.SqlAnd.getLiteral().equalsIgnoreCase(identifierSpan.getText())) {
                tokens.add(new Token(TokenType.SqlAnd, identifierSpan));
            } else if (TokenType.SqlOr.getLiteral().equalsIgnoreCase(identifierSpan.getText())) {
                tokens.add(new Token(TokenType.SqlOr, identifierSpan));
            } else {
                tokens.add(new Token(TokenType.Identifier, identifierSpan));
            }
            return true;
        }
        return false;
    }

    private static boolean tokenizerComment(CharacterStream stream, List<Token> tokens, boolean matchComment) {
        if (stream.match("//", true)) {
            stream.skipLine();
            if (matchComment) {
                tokens.add(new Token(TokenType.Comment, stream.endSpan()));
            }
            return true;
        }
        stream.startSpan();
        if (stream.match("/*", true)) {
            stream.skipUntil("*/");
            if (matchComment) {
                tokens.add(new Token(TokenType.Comment, stream.endSpan()));
            }
            return true;
        }
        return false;
    }

    private static boolean tokenizerNumber(CharacterStream stream, List<Token> tokens) {
        if (stream.match("0", false)) {
            int index = stream.getPosition();
            stream.startSpan();
            stream.consume();
            if (stream.matchAny(true, "x", "X")) {
                while (stream.matchDigit(true) || stream.matchAny(true, "A", "B", "C", "D", "E", "F", "a", "b", "c", "d", "e", "f", "_")) {
                }
                if (stream.matchAny(true, "L", "l")) {
                    Span span = stream.endSpan();
                    String text = span.getText();
                    tokens.add(new LiteralToken(TokenType.LongLiteral, span, Long.parseLong(text.substring(2, text.length() - 1).replace("_", ""), 16)));
                    return true;
                }
                tokens.add(Tokenizer.autoNumberType(stream.endSpan(), 16));
                return true;
            }
            if (stream.matchAny(true, "b", "B")) {
                while (stream.matchAny(true, "0", "1", "_")) {
                }
                if (stream.matchAny(true, "L", "l")) {
                    Span span = stream.endSpan();
                    String text = span.getText();
                    tokens.add(new LiteralToken(TokenType.LongLiteral, span, Long.parseLong(text.substring(2, text.length() - 1).replace("_", ""), 2)));
                    return true;
                }
                tokens.add(Tokenizer.autoNumberType(stream.endSpan(), 2));
                return true;
            }
            stream.reset(index);
        }
        if (stream.matchDigit(false)) {
            TokenType type = TokenType.IntegerLiteral;
            stream.startSpan();
            while (stream.matchDigit(true) || stream.match("_", true)) {
            }
            if (stream.match(TokenType.Period.getLiteral(), true)) {
                type = TokenType.DoubleLiteral;
                while (stream.matchDigit(true) || stream.match("_", true)) {
                }
            }
            if (stream.matchAny(true, "b", "B")) {
                if (type == TokenType.DoubleLiteral) {
                    MagicScriptError.error("Byte literal can not have a decimal point.", stream.endSpan());
                }
                type = TokenType.ByteLiteral;
            } else if (stream.matchAny(true, "s", "S")) {
                if (type == TokenType.DoubleLiteral) {
                    MagicScriptError.error("Short literal can not have a decimal point.", stream.endSpan());
                }
                type = TokenType.ShortLiteral;
            } else if (stream.matchAny(true, "L", "l")) {
                if (type == TokenType.DoubleLiteral) {
                    MagicScriptError.error("Long literal can not have a decimal point.", stream.endSpan());
                }
                type = TokenType.LongLiteral;
            } else if (stream.matchAny(true, "f", "F")) {
                type = TokenType.FloatLiteral;
            } else if (stream.matchAny(true, "d", "D")) {
                type = TokenType.DoubleLiteral;
            } else if (stream.matchAny(true, "m", "M")) {
                type = TokenType.DecimalLiteral;
            }
            Span numberSpan = stream.endSpan();
            tokens.add(new LiteralToken(type, numberSpan));
            return true;
        }
        return false;
    }

    private static LiteralToken autoNumberType(Span span, int radix) {
        long value = Long.parseLong(span.getText().substring(2).replace("_", ""), radix);
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            return new LiteralToken(TokenType.LongLiteral, span, value);
        }
        if (value > 127L || value < -128L) {
            return new LiteralToken(TokenType.IntegerLiteral, span, (int)value);
        }
        return new LiteralToken(TokenType.ByteLiteral, span, (byte)value);
    }

    private static boolean tokenizerString(CharacterStream stream, TokenType tokenType, List<Token> tokens) {
        if (stream.match(tokenType.getLiteral(), true)) {
            stream.startSpan();
            boolean matchedEndQuote = false;
            while (stream.hasMore()) {
                if (stream.match("\\", true)) {
                    stream.consume();
                    continue;
                }
                if (stream.match(tokenType.getLiteral(), true)) {
                    matchedEndQuote = true;
                    break;
                }
                char ch = stream.consume();
                if (tokenType == TokenType.TripleQuote || ch != '\r' && ch != '\n') continue;
                MagicScriptError.error(tokenType.getError() + tokenType.getError() + "\u5b9a\u4e49\u7684\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c", stream.endSpan(), new StringLiteralException());
            }
            if (!matchedEndQuote) {
                MagicScriptError.error("\u5b57\u7b26\u4e32\u6ca1\u6709\u7ed3\u675f\u7b26" + tokenType.getError(), stream.endSpan(), new StringLiteralException());
            }
            Span stringSpan = stream.endSpan();
            stringSpan = stream.getSpan(stringSpan.getStart(), stringSpan.getEnd() - tokenType.getLiteral().length());
            tokens.add(new LiteralToken(TokenType.StringLiteral, stringSpan));
            return true;
        }
        return false;
    }

    private static boolean regexpToken(CharacterStream stream, List<Token> tokens) {
        if (tokens.size() > 0) {
            Token token = tokens.get(tokens.size() - 1);
            if (token instanceof LiteralToken) {
                return false;
            }
            switch (token.getType()) {
                case Comma: 
                case Semicolon: 
                case Colon: 
                case RightCurly: 
                case LeftBracket: 
                case LeftParantheses: 
                case Assignment: 
                case NotEqual: 
                case EqualEqualEqual: 
                case NotEqualEqual: 
                case Equal: 
                case And: 
                case Or: 
                case SqlAnd: 
                case SqlOr: 
                case SqlNotEqual: 
                case QuestionMark: 
                case Lambda: 
                case Not: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (stream.match("/", false)) {
            int mark = stream.getPosition();
            stream.consume();
            stream.startSpan();
            boolean matchedEndQuote = false;
            int deep = 0;
            int expFlag = 0;
            int maybeMissForwardSlash = 0;
            int maybeMissForwardSlashEnd = 0;
            while (stream.hasMore()) {
                char ch;
                if (stream.match("\\", true)) {
                    stream.consume();
                    continue;
                }
                if (stream.match("[", false)) {
                    ++deep;
                    maybeMissForwardSlash = stream.getPosition();
                } else if (deep > 0 && stream.match("]", false)) {
                    --deep;
                } else if (stream.match(TokenType.ForwardSlash.getLiteral(), true)) {
                    if (deep == 0) {
                        if (stream.match("g", true)) {
                            expFlag |= 1;
                        }
                        if (stream.match("i", true)) {
                            expFlag |= 2;
                        }
                        if (stream.match("m", true)) {
                            expFlag |= 8;
                        }
                        if (stream.match("s", true)) {
                            expFlag |= 0x20;
                        }
                        if (stream.match("u", true)) {
                            expFlag |= 0x100;
                        }
                        if (stream.match("y", true)) {
                            expFlag |= 0x10;
                        }
                        matchedEndQuote = true;
                        break;
                    }
                    maybeMissForwardSlashEnd = stream.getPosition();
                }
                if ((ch = stream.consume()) != '\r' && ch != '\n') continue;
                stream.reset(mark);
                return false;
            }
            if (deep != 0) {
                MagicScriptError.error("Missing ']'", stream.getSpan(maybeMissForwardSlash, maybeMissForwardSlashEnd - 1));
            }
            if (!matchedEndQuote) {
                stream.reset(mark);
                return false;
            }
            Span regexpSpan = stream.endSpan();
            regexpSpan = stream.getSpan(regexpSpan.getStart() - 1, regexpSpan.getEnd());
            tokens.add(new RegexpToken(TokenType.RegexpLiteral, regexpSpan, expFlag));
            return true;
        }
        return false;
    }
}

