/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ssssssss.script.MagicScriptError;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Token;
import org.ssssssss.script.parsing.TokenType;

public class TokenStream {
    private final List<Token> tokens;
    private final int end;
    private int index;

    public TokenStream(List<Token> tokens) {
        this.tokens = tokens;
        this.index = 0;
        this.end = tokens.size();
    }

    public boolean hasMore() {
        return this.index < this.end;
    }

    public boolean hasNext() {
        return this.index + 1 < this.end;
    }

    public boolean hasPrev() {
        return this.index > 0;
    }

    public int makeIndex() {
        return this.index;
    }

    public void resetIndex(int index) {
        this.index = index;
    }

    public Token consume() {
        if (!this.hasMore()) {
            throw new RuntimeException("\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5");
        }
        return this.tokens.get(this.index++);
    }

    public Token next() {
        if (!this.hasMore()) {
            throw new RuntimeException("\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5");
        }
        return this.tokens.get(++this.index);
    }

    public Token prev() {
        if (this.index == 0) {
            throw new RuntimeException("\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5");
        }
        return this.tokens.get(--this.index);
    }

    public Token getPrev() {
        if (this.index == 0) {
            throw new RuntimeException("\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5");
        }
        return this.tokens.get(this.index - 1);
    }

    public Token expect(TokenType ... types) {
        if (!this.match(true, types)) {
            Span span;
            Token token = this.index < this.tokens.size() ? this.tokens.get(this.index) : null;
            Span span2 = span = token != null ? token.getSpan() : null;
            if (span == null) {
                MagicScriptError.error("\u671f\u5f85 '" + Stream.of(types).map(TokenType::getError).collect(Collectors.joining("','")) + "', \u4f46\u662f\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5", this);
            } else {
                MagicScriptError.error("\u671f\u5f85 '" + Stream.of(types).map(TokenType::getError).collect(Collectors.joining("','")) + "', \u83b7\u5f97 '" + token.getText() + "'", span);
            }
            return null;
        }
        return this.tokens.get(this.index - 1);
    }

    public List<Span> comments() {
        return this.tokens.stream().filter(it -> it.getType() == TokenType.Comment).map(Token::getSpan).collect(Collectors.toList());
    }

    public Token expect(TokenType type) {
        if (!this.match(type, true)) {
            Span span;
            Token token = this.index < this.tokens.size() ? this.tokens.get(this.index) : null;
            Span span2 = span = token != null ? token.getSpan() : null;
            if (span == null) {
                MagicScriptError.error("\u671f\u5f85 '" + type.getError() + "', \u4f46\u662f\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5", this);
            } else {
                MagicScriptError.error("\u671f\u5f85 '" + type.getError() + "', \u83b7\u5f97 '" + token.getText() + "'", span);
            }
            return null;
        }
        return this.tokens.get(this.index - 1);
    }

    public Token expect(String text) {
        return this.expect(text, false);
    }

    public Token expect(String text, boolean ignoreCase) {
        boolean result = this.match(text, true, ignoreCase);
        if (!result) {
            Span span;
            Token token = this.index < this.tokens.size() ? this.tokens.get(this.index) : null;
            Span span2 = span = token != null ? token.getSpan() : null;
            if (span == null) {
                MagicScriptError.error("\u671f\u5f85 '" + text + "', \u4f46\u662f\u6d41\u5df2\u7ecf\u904d\u5386\u5b8c\u6bd5", this);
            } else {
                MagicScriptError.error("\u671f\u5f85 '" + text + "', \u83b7\u5f97 '" + token.getText() + "'", span);
            }
            return null;
        }
        return this.tokens.get(this.index - 1);
    }

    public boolean match(TokenType type, boolean consume) {
        if (this.index >= this.end) {
            return false;
        }
        if (this.tokens.get(this.index).getType() == type) {
            if (consume) {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public boolean match(List<String> texts, boolean consume) {
        return this.match(texts, consume, false);
    }

    public boolean match(List<String> texts, boolean consume, boolean ignoreCase) {
        for (String text : texts) {
            if (!this.match(text, consume, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public boolean match(String text, boolean consume, boolean ignoreCase) {
        if (this.index >= this.end) {
            return false;
        }
        String matchText = this.tokens.get(this.index).getText();
        if (ignoreCase ? matchText.equalsIgnoreCase(text) : matchText.equals(text)) {
            if (consume) {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    public boolean match(String text, boolean consume) {
        return this.match(text, consume, false);
    }

    public boolean match(boolean consume, TokenType ... types) {
        for (TokenType type : types) {
            if (!this.match(type, consume)) continue;
            return true;
        }
        return false;
    }

    public boolean match(boolean consume, String ... tokenTexts) {
        return this.match(consume, false, tokenTexts);
    }

    public boolean match(boolean consume, boolean ignoreCase, String ... tokenTexts) {
        for (String text : tokenTexts) {
            if (!this.match(text, consume, ignoreCase)) continue;
            return true;
        }
        return false;
    }
}

