/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.mybatis;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeStream {
    private final List<Node> nodes;
    private int index = 0;
    private final int len;

    public NodeStream(NodeList nodeList) {
        this.nodes = NodeStream.filterCommentAndBlankNodes(nodeList);
        this.len = this.nodes.size();
    }

    private static List<Node> filterCommentAndBlankNodes(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 8 || nodeType == 3 && node.getNodeValue().trim().length() <= 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public boolean match(String nodeName) {
        return this.hasMore() && nodeName.equalsIgnoreCase(this.nodes.get(this.index).getNodeName());
    }

    public boolean match(short nodeType) {
        return this.hasMore() && nodeType == this.nodes.get(this.index).getNodeType();
    }

    public Node consume() {
        return this.nodes.get(this.index++);
    }

    public boolean hasMore() {
        return this.index < this.len;
    }
}

