/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.function.service;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.model.Parameter;
import org.ssssssss.magicapi.core.service.AbstractMagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.function.model.FunctionInfo;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.runtime.ExitValue;

public class FunctionMagicDynamicRegistry
extends AbstractMagicDynamicRegistry<FunctionInfo> {
    private static final Logger logger = LoggerFactory.getLogger(FunctionMagicDynamicRegistry.class);

    public FunctionMagicDynamicRegistry(MagicResourceStorage<FunctionInfo> magicResourceStorage) {
        super(magicResourceStorage);
        MagicResourceLoader.addFunctionLoader(this::lookupLambdaFunction);
    }

    private Object lookupLambdaFunction(MagicScriptContext context, String path) {
        FunctionInfo functionInfo = (FunctionInfo)this.getMapping(path);
        if (functionInfo != null) {
            String scriptName = MagicConfiguration.getMagicResourceService().getScriptName(functionInfo);
            List<Parameter> parameters = functionInfo.getParameters();
            return objects -> {
                Object value;
                MagicScriptContext functionContext = new MagicScriptContext(context.getRootVariables());
                functionContext.setScriptName(scriptName);
                if (objects != null) {
                    int len = ((Object[])objects).length;
                    int size = parameters.size();
                    for (int i = 0; i < len && i < size; ++i) {
                        functionContext.set(((Parameter)parameters.get(i)).getName(), objects[i]);
                    }
                }
                if ((value = ScriptManager.executeScript(functionInfo.getScript(), functionContext)) instanceof ExitValue) {
                    throw new MagicExitException((ExitValue)value);
                }
                return value;
            };
        }
        return null;
    }

    @EventListener(condition="#event.type == 'function'")
    public void onFileEvent(FileEvent event) {
        this.processEvent(event);
    }

    @EventListener(condition="#event.type == 'function'")
    public void onGroupEvent(GroupEvent event) {
        this.processEvent(event);
    }

    @Override
    protected boolean register(AbstractMagicDynamicRegistry.MappingNode<FunctionInfo> mappingNode) {
        logger.debug("\u6ce8\u518c\u51fd\u6570\uff1a{}", (Object)mappingNode.getMappingKey());
        return true;
    }

    @Override
    protected void unregister(AbstractMagicDynamicRegistry.MappingNode<FunctionInfo> mappingNode) {
        logger.debug("\u53d6\u6d88\u6ce8\u518c\u51fd\u6570\uff1a{}", (Object)mappingNode.getMappingKey());
    }
}

