/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.web;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.core.annotation.Valid;
import org.ssssssss.magicapi.core.config.Constants;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.config.MessageType;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.core.context.CookieContext;
import org.ssssssss.magicapi.core.context.RequestContext;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.core.context.SessionContext;
import org.ssssssss.magicapi.core.exception.ValidateException;
import org.ssssssss.magicapi.core.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.core.interceptor.ResultProvider;
import org.ssssssss.magicapi.core.logging.MagicLoggerContext;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.BaseDefinition;
import org.ssssssss.magicapi.core.model.DataType;
import org.ssssssss.magicapi.core.model.DebugRequest;
import org.ssssssss.magicapi.core.model.JsonCode;
import org.ssssssss.magicapi.core.model.Options;
import org.ssssssss.magicapi.core.model.Path;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.core.web.MagicController;
import org.ssssssss.magicapi.modules.servlet.ResponseModule;
import org.ssssssss.magicapi.utils.PatternUtils;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptDebugContext;
import org.ssssssss.script.exception.MagicScriptAssertException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.reflection.JavaInvoker;

public class RequestHandler
extends MagicController {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    private static final List<String> DEFAULT_ALLOW_READ_RESPONSE_HEADERS = Arrays.asList("Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Methods", "Content-Type", "Date", "Server", "Set-Cookie", "Connection", "Content-Length", "Content-Encoding", "Transfer-Encoding", "Vary");
    private final ResultProvider resultProvider;
    private final RequestMagicDynamicRegistry requestMagicDynamicRegistry;

    public RequestHandler(MagicConfiguration configuration, RequestMagicDynamicRegistry requestMagicDynamicRegistry) {
        super(configuration);
        this.requestMagicDynamicRegistry = requestMagicDynamicRegistry;
        this.resultProvider = configuration.getResultProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @Valid(requireLogin=false)
    public Object invoke(HttpServletRequest request, HttpServletResponse response, @PathVariable(required=false) Map<String, Object> pathVariables, @RequestHeader(required=false) Map<String, Object> defaultHeaders, @RequestParam(required=false) Map<String, Object> parameters) throws Throwable {
        String clientId = null;
        LinkedCaseInsensitiveMap headers = new LinkedCaseInsensitiveMap();
        headers.putAll(defaultHeaders);
        boolean requestedFromTest = this.configuration.isEnableWeb() && (clientId = request.getHeader("Magic-Request-Client-Id")) != null && request.getHeader("Magic-Request-Script-Id") != null;
        RequestEntity requestEntity = RequestEntity.create().info(this.requestMagicDynamicRegistry.getApiInfoFromRequest(request)).request(request).response(response).requestedFromTest(requestedFromTest).pathVariables(pathVariables).parameters(parameters);
        ApiInfo info = requestEntity.getApiInfo();
        if (info == null) {
            logger.error("{}\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3", (Object)request.getRequestURI());
            return this.afterCompletion(requestEntity, this.buildResult(requestEntity, API_NOT_FOUND, "\u63a5\u53e3\u4e0d\u5b58\u5728"));
        }
        requestEntity.setHeaders((Map<String, Object>)headers);
        ArrayList<Path> paths = new ArrayList<Path>(info.getPaths());
        MagicConfiguration.getMagicResourceService().getGroupsByFileId(info.getId()).stream().flatMap(it -> it.getPaths().stream()).filter(it -> !paths.contains(it)).forEach(paths::add);
        final Object bodyValue = this.readRequestBody(requestEntity.getRequest());
        requestEntity.setRequestBody(bodyValue);
        String scriptName = MagicConfiguration.getMagicResourceService().getScriptName(info);
        MagicScriptContext context = this.createMagicScriptContext(scriptName, requestEntity);
        requestEntity.setMagicScriptContext(context);
        try {
            BaseDefinition requestBody;
            String defaultDataSourceValue;
            boolean disabledUnknownParameter = "true".equalsIgnoreCase(info.getOptionValue(Options.DISABLED_UNKNOWN_PARAMETER));
            this.doValidate(scriptName, "\u53c2\u6570", info.getParameters(), parameters, PARAMETER_INVALID, disabledUnknownParameter);
            String wrap = requestEntity.getApiInfo().getOptionValue(Options.WRAP_REQUEST_PARAMETERS.getValue());
            if (wrap != null && StringUtils.isNotBlank((CharSequence)wrap.toString())) {
                context.set(wrap.toString(), requestEntity.getParameters());
            }
            if ((defaultDataSourceValue = requestEntity.getApiInfo().getOptionValue(Options.DEFAULT_DATA_SOURCE.getValue())) != null) {
                context.set(Options.DEFAULT_DATA_SOURCE.getValue(), (Object)defaultDataSourceValue);
            }
            context.putMapIntoContext(requestEntity.getParameters());
            this.doValidate(scriptName, "path", paths, requestEntity.getPathVariables(), PATH_VARIABLE_INVALID, disabledUnknownParameter);
            context.putMapIntoContext(requestEntity.getPathVariables());
            context.set("cookie", (Object)new CookieContext(requestEntity.getRequest()));
            this.doValidate(scriptName, "header", info.getHeaders(), (Map<String, Object>)headers, HEADER_INVALID, disabledUnknownParameter);
            context.set("header", (Object)headers);
            context.set("session", (Object)new SessionContext(requestEntity.getRequest().getSession()));
            context.set("path", requestEntity.getPathVariables());
            if (bodyValue != null) {
                context.set("body", bodyValue);
            }
            if ((requestBody = info.getRequestBodyDefinition()) != null && !CollectionUtils.isEmpty(requestBody.getChildren())) {
                requestBody.setName((String)StringUtils.defaultIfBlank((CharSequence)requestBody.getName(), (CharSequence)"root"));
                this.doValidate(scriptName, "body", Collections.singletonList(requestBody), (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put(requestBody.getName(), bodyValue);
                    }
                }, BODY_INVALID, disabledUnknownParameter);
            }
        }
        catch (ValidateException e) {
            return this.afterCompletion(requestEntity, this.resultProvider.buildResult(requestEntity, Constants.RESPONSE_CODE_INVALID, e.getMessage()));
        }
        catch (Throwable root) {
            return this.afterCompletion(requestEntity, this.processException(requestEntity, root), root);
        }
        RequestContext.setRequestEntity(requestEntity);
        Object value = this.doPreHandle(requestEntity);
        if (value != null) {
            return this.afterCompletion(requestEntity, value);
        }
        if (requestedFromTest) {
            DebugRequest debugRequest = requestEntity.getDebugRequest();
            String sessionAndScriptId = debugRequest.getRequestedClientId() + debugRequest.getRequestedScriptId();
            try {
                if (context instanceof MagicScriptDebugContext) {
                    WebSocketSessionManager.addMagicScriptContext(sessionAndScriptId, (MagicScriptDebugContext)context);
                }
                MagicLoggerContext.SESSION.set(clientId);
                Object object = this.invokeRequest(requestEntity);
                return object;
            }
            finally {
                MagicLoggerContext.remove();
                WebSocketSessionManager.removeMagicScriptContext(sessionAndScriptId);
            }
        }
        return this.invokeRequest(requestEntity);
    }

    private Object buildResult(RequestEntity requestEntity, JsonCode code, Object data) {
        return this.resultProvider.buildResult(requestEntity, code.getCode(), code.getMessage(), data);
    }

    private void removeUnknownKey(Map<String, Object> src, List<? extends BaseDefinition> definitions) {
        if (!src.isEmpty()) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(definitions.size());
            for (BaseDefinition baseDefinition : definitions) {
                newMap.put(baseDefinition.getName(), src.get(baseDefinition.getName()));
            }
            src.clear();
            src.putAll(newMap);
        }
    }

    private boolean doValidateBody(String comment, BaseDefinition parameter, Map<String, Object> parameters, JsonCode jsonCode, Class<?> target) {
        if (!parameter.isRequired() && parameters.isEmpty()) {
            return true;
        }
        if (parameter.isRequired() && !BooleanLiteral.isTrue((Object)parameters.get(parameter.getName()))) {
            throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e3a\u5fc5\u586b\u9879", comment, parameter.getName())));
        }
        Object value = parameters.get(parameter.getName());
        if (value != null && !target.isAssignableFrom(value.getClass())) {
            throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u6570\u636e\u7c7b\u578b\u9519\u8bef", comment, parameter.getName())));
        }
        return false;
    }

    private Map<String, Object> doValidate(String scriptName, String comment, List<? extends BaseDefinition> validateParameters, Map<String, Object> parameters, JsonCode jsonCode, boolean disabledUnknownParameter) {
        Map<String, Object> map = parameters = parameters != null ? parameters : EMPTY_MAP;
        if (CollectionUtils.isEmpty(validateParameters)) {
            return parameters;
        }
        if (disabledUnknownParameter) {
            this.removeUnknownKey(parameters, validateParameters);
        }
        for (BaseDefinition baseDefinition : validateParameters) {
            if (baseDefinition.getDataType() == DataType.Any) continue;
            if (DataType.Object == baseDefinition.getDataType()) {
                if (this.doValidateBody(comment, baseDefinition, parameters, jsonCode, Map.class)) continue;
                this.doValidate(scriptName, "body", baseDefinition.getChildren(), (Map)parameters.get(baseDefinition.getName()), jsonCode, disabledUnknownParameter);
                continue;
            }
            if (DataType.Array == baseDefinition.getDataType()) {
                List list;
                if (this.doValidateBody(comment, baseDefinition, parameters, jsonCode, List.class) || (list = (List)parameters.get(baseDefinition.getName())) == null) continue;
                List newList = list.stream().map(it -> this.doValidate(scriptName, "body", parameter.getChildren(), (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("", it);
                    }
                }, jsonCode, disabledUnknownParameter)).collect(Collectors.toList());
                int size = newList.size();
                for (int i = 0; i < size; ++i) {
                    list.set(i, ((Map)newList.get(i)).get(""));
                }
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)baseDefinition.getName()) && !parameters.containsKey(baseDefinition.getName())) continue;
            boolean isFile = baseDefinition.getDataType() == DataType.MultipartFile || baseDefinition.getDataType() == DataType.MultipartFiles;
            String requestValue = (String)StringUtils.defaultIfBlank((CharSequence)Objects.toString(parameters.get(baseDefinition.getName()), ""), (CharSequence)Objects.toString(baseDefinition.getDefaultValue(), ""));
            if (StringUtils.isBlank((CharSequence)requestValue) && !isFile) {
                if (!baseDefinition.isRequired()) continue;
                throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)baseDefinition.getError(), (CharSequence)String.format("%s[%s]\u4e3a\u5fc5\u586b\u9879", comment, baseDefinition.getName())));
            }
            try {
                String expression;
                Object value = this.convertValue(baseDefinition.getDataType(), baseDefinition.getName(), requestValue);
                if (isFile && baseDefinition.isRequired() && (value == null || baseDefinition.getDataType() == DataType.MultipartFiles && ((List)value).isEmpty())) {
                    throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)baseDefinition.getError(), (CharSequence)String.format("%s[%s]\u4e3a\u5fc5\u586b\u9879", comment, baseDefinition.getName())));
                }
                if ("pattern".equals(baseDefinition.getValidateType()) && StringUtils.isNotBlank((CharSequence)(expression = baseDefinition.getExpression())) && !PatternUtils.match(Objects.toString(value, ""), expression)) {
                    throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)baseDefinition.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u6ee1\u8db3\u6b63\u5219\u8868\u8fbe\u5f0f", comment, baseDefinition.getName())));
                }
                parameters.put(baseDefinition.getName(), value);
            }
            catch (ValidateException ve) {
                throw ve;
            }
            catch (Exception e) {
                throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)baseDefinition.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u5408\u6cd5", comment, baseDefinition.getName())));
            }
        }
        List validates = validateParameters.stream().filter(it -> "expression".equals(it.getValidateType()) && StringUtils.isNotBlank((CharSequence)it.getExpression())).collect(Collectors.toList());
        for (BaseDefinition parameter : validates) {
            MagicScriptContext context = new MagicScriptContext();
            context.putMapIntoContext(parameters);
            Object value = parameters.get(parameter.getName());
            if (value == null) continue;
            context.setScriptName(scriptName);
            context.set("value", value);
            if (BooleanLiteral.isTrue((Object)ScriptManager.executeExpression(parameter.getExpression(), context))) continue;
            throw new ValidateException(jsonCode, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u6ee1\u8db3\u8868\u8fbe\u5f0f", comment, parameter.getName())));
        }
        return parameters;
    }

    private Object convertValue(DataType dataType, String name, String value) {
        if (dataType == null) {
            return value;
        }
        try {
            if (dataType.isNumber()) {
                BigDecimal decimal = ObjectConvertExtension.asDecimal((Object)value, null);
                if (decimal == null) {
                    throw new IllegalArgumentException();
                }
                return dataType.getInvoker().invoke0((Object)decimal, null, Constants.EMPTY_OBJECT_ARRAY);
            }
            JavaInvoker<Method> invoker = dataType.getInvoker();
            if (invoker != null) {
                ArrayList<String> params = new ArrayList<String>();
                if (dataType.isNeedName()) {
                    params.add(name);
                }
                if (dataType.isNeedValue()) {
                    params.add(value);
                }
                return invoker.invoke0(null, null, params.toArray());
            }
            return value;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRequest(RequestEntity requestEntity) throws Throwable {
        try {
            Object result;
            MagicScriptContext context = requestEntity.getMagicScriptContext();
            Object value = result = ScriptManager.executeScript(requestEntity.getApiInfo().getScript(), context);
            value = this.doPostHandle(requestEntity, value);
            if (value != null) {
                Object object = this.afterCompletion(requestEntity, value);
                return object;
            }
            Object object = this.afterCompletion(requestEntity, this.response(requestEntity, result));
            return object;
        }
        catch (Throwable root) {
            Object object = this.afterCompletion(requestEntity, this.processException(requestEntity, root), root);
            return object;
        }
        finally {
            RequestContext.remove();
        }
    }

    private Object processException(RequestEntity requestEntity, Throwable root) throws Throwable {
        MagicScriptException se = null;
        Throwable parent = root;
        do {
            if (parent instanceof MagicScriptAssertException) {
                MagicScriptAssertException sae = (MagicScriptAssertException)parent;
                return this.resultProvider.buildResult(requestEntity, sae.getCode(), sae.getMessage());
            }
            if (!(parent instanceof MagicScriptException)) continue;
            se = (MagicScriptException)parent;
        } while ((parent = parent.getCause()) != null);
        if (se != null && requestEntity.isRequestedFromTest()) {
            Span.Line line = se.getLine();
            WebSocketSessionManager.sendByClientId(requestEntity.getDebugRequest().getRequestedClientId(), MessageType.EXCEPTION, Arrays.asList(requestEntity.getDebugRequest().getRequestedScriptId(), se.getSimpleMessage(), line == null ? null : Arrays.asList(line.getLineNumber(), line.getEndLineNumber(), line.getStartCol(), line.getEndCol())));
        }
        if (this.configuration.isThrowException()) {
            throw root;
        }
        logger.error("\u63a5\u53e3{}\u8bf7\u6c42\u51fa\u9519", (Object)requestEntity.getRequest().getRequestURI(), (Object)root);
        return this.resultProvider.buildException(requestEntity, root);
    }

    private Object readRequestBody(HttpServletRequest request) throws IOException {
        if (this.configuration.getHttpMessageConverters() != null && request.getContentType() != null) {
            MediaType mediaType = MediaType.valueOf((String)request.getContentType());
            Class<Object> clazz = Object.class;
            try {
                for (HttpMessageConverter<?> converter : this.configuration.getHttpMessageConverters()) {
                    if (!converter.canRead(clazz, mediaType)) continue;
                    return converter.read(clazz, (HttpInputMessage)new ServletServerHttpRequest(request));
                }
            }
            catch (HttpMessageNotReadableException ignored) {
                return null;
            }
        }
        return null;
    }

    private MagicScriptContext createMagicScriptContext(String scriptName, RequestEntity requestEntity) {
        DebugRequest debugRequest = requestEntity.getDebugRequest();
        List<Integer> breakpoints = debugRequest.getRequestedBreakpoints();
        Object context = requestEntity.isRequestedFromDebug() && breakpoints.size() > 0 ? debugRequest.createMagicScriptContext(this.configuration.getDebugTimeout()) : new MagicScriptContext();
        context.setScriptName(scriptName);
        return context;
    }

    private Object response(RequestEntity requestEntity, Object value) {
        if (value instanceof ResponseEntity) {
            return value;
        }
        if (value instanceof ResponseModule.NullValue) {
            return null;
        }
        return this.resultProvider.buildResult(requestEntity, value);
    }

    private Object doPostHandle(RequestEntity requestEntity, Object value) throws Exception {
        for (RequestInterceptor requestInterceptor : this.configuration.getRequestInterceptors()) {
            Object target = requestInterceptor.postHandle(requestEntity, value);
            if (target == null) continue;
            return this.afterCompletion(requestEntity, target);
        }
        return null;
    }

    private Object afterCompletion(RequestEntity requestEntity, Object returnValue) {
        return this.afterCompletion(requestEntity, returnValue, null);
    }

    private Object afterCompletion(RequestEntity requestEntity, Object returnValue, Throwable throwable) {
        for (RequestInterceptor requestInterceptor : this.configuration.getRequestInterceptors()) {
            try {
                requestInterceptor.afterCompletion(requestEntity, returnValue, throwable);
            }
            catch (Exception e) {
                logger.warn("\u6267\u884cafterCompletion\u51fa\u73b0\u51fa\u9519", (Throwable)e);
            }
        }
        HashSet<String> exposeHeaders = new HashSet<String>(16);
        if (returnValue instanceof ResponseEntity) {
            exposeHeaders.addAll(((ResponseEntity)returnValue).getHeaders().keySet());
        }
        if (requestEntity.isRequestedFromTest()) {
            HttpServletResponse response = requestEntity.getResponse();
            exposeHeaders.addAll(response.getHeaderNames());
            exposeHeaders.addAll(DEFAULT_ALLOW_READ_RESPONSE_HEADERS);
        }
        if (!exposeHeaders.isEmpty()) {
            requestEntity.getResponse().setHeader("Access-Control-Expose-Headers", String.join((CharSequence)",", exposeHeaders));
        }
        return returnValue;
    }

    private Object doPreHandle(RequestEntity requestEntity) throws Exception {
        for (RequestInterceptor requestInterceptor : this.configuration.getRequestInterceptors()) {
            Object value = requestInterceptor.preHandle(requestEntity);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

