/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.magicapi.core.context.RequestContext;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.core.interceptor.ResultProvider;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;
import org.ssssssss.magicapi.modules.db.BoundSql;
import org.ssssssss.magicapi.modules.db.ColumnMapperAdapter;
import org.ssssssss.magicapi.modules.db.SingleRowResultSetExtractor;
import org.ssssssss.magicapi.modules.db.Transaction;
import org.ssssssss.magicapi.modules.db.cache.SqlCache;
import org.ssssssss.magicapi.modules.db.dialect.Dialect;
import org.ssssssss.magicapi.modules.db.dialect.DialectAdapter;
import org.ssssssss.magicapi.modules.db.inteceptor.NamedTableInterceptor;
import org.ssssssss.magicapi.modules.db.inteceptor.SQLInterceptor;
import org.ssssssss.magicapi.modules.db.model.Page;
import org.ssssssss.magicapi.modules.db.provider.PageProvider;
import org.ssssssss.magicapi.modules.db.table.NamedTable;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.functions.DynamicAttribute;
import org.ssssssss.script.parsing.ast.statement.ClassConverter;
import org.ssssssss.script.reflection.JavaReflection;
import org.ssssssss.script.runtime.RuntimeContext;

@MagicModule(value="db")
public class SQLModule
implements DynamicAttribute<SQLModule, SQLModule> {
    private MagicDynamicDataSource dynamicDataSource;
    private MagicDynamicDataSource.DataSourceNode dataSourceNode;
    private PageProvider pageProvider;
    private ResultProvider resultProvider;
    private ColumnMapperAdapter columnMapperAdapter;
    private DialectAdapter dialectAdapter;
    private RowMapper<Map<String, Object>> columnMapRowMapper;
    private Function<String, String> rowMapColumnMapper;
    private SqlCache sqlCache;
    private String cacheName;
    private List<SQLInterceptor> sqlInterceptors;
    private List<NamedTableInterceptor> namedTableInterceptors;
    private long ttl;
    private String logicDeleteColumn;
    private String logicDeleteValue;

    public SQLModule() {
    }

    public SQLModule(MagicDynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
    }

    @Transient
    public void setPageProvider(PageProvider pageProvider) {
        this.pageProvider = pageProvider;
    }

    @Transient
    public void setResultProvider(ResultProvider resultProvider) {
        this.resultProvider = resultProvider;
    }

    @Transient
    public void setColumnMapperProvider(ColumnMapperAdapter columnMapperAdapter) {
        this.columnMapperAdapter = columnMapperAdapter;
    }

    @Transient
    public void setDialectAdapter(DialectAdapter dialectAdapter) {
        this.dialectAdapter = dialectAdapter;
    }

    @Transient
    public void setColumnMapRowMapper(RowMapper<Map<String, Object>> columnMapRowMapper) {
        this.columnMapRowMapper = columnMapRowMapper;
    }

    @Transient
    public void setRowMapColumnMapper(Function<String, String> rowMapColumnMapper) {
        this.rowMapColumnMapper = rowMapColumnMapper;
    }

    @Transient
    public void setDynamicDataSource(MagicDynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
    }

    @Transient
    public void setSqlInterceptors(List<SQLInterceptor> sqlInterceptors) {
        this.sqlInterceptors = sqlInterceptors;
    }

    @Transient
    public void setNamedTableInterceptors(List<NamedTableInterceptor> namedTableInterceptors) {
        this.namedTableInterceptors = namedTableInterceptors;
    }

    @Transient
    public void setDataSourceNode(MagicDynamicDataSource.DataSourceNode dataSourceNode) {
        this.dataSourceNode = dataSourceNode;
    }

    @Transient
    public String getCacheName() {
        return this.cacheName;
    }

    @Transient
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Transient
    public long getTtl() {
        return this.ttl;
    }

    @Transient
    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @Transient
    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    @Transient
    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    @Transient
    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    @Transient
    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    @Transient
    public SqlCache getSqlCache() {
        return this.sqlCache;
    }

    @Transient
    public void setSqlCache(SqlCache sqlCache) {
        this.sqlCache = sqlCache;
    }

    @Transient
    public SQLModule cloneSQLModule() {
        SQLModule sqlModule = new SQLModule();
        sqlModule.setDynamicDataSource(this.dynamicDataSource);
        sqlModule.setDataSourceNode(this.dataSourceNode);
        sqlModule.setPageProvider(this.pageProvider);
        sqlModule.setColumnMapperProvider(this.columnMapperAdapter);
        sqlModule.setColumnMapRowMapper(this.columnMapRowMapper);
        sqlModule.setRowMapColumnMapper(this.rowMapColumnMapper);
        sqlModule.setSqlCache(this.sqlCache);
        sqlModule.setTtl(this.ttl);
        sqlModule.setCacheName(this.cacheName);
        sqlModule.setResultProvider(this.resultProvider);
        sqlModule.setDialectAdapter(this.dialectAdapter);
        sqlModule.setSqlInterceptors(this.sqlInterceptors);
        sqlModule.setLogicDeleteValue(this.logicDeleteValue);
        sqlModule.setLogicDeleteColumn(this.logicDeleteColumn);
        sqlModule.setNamedTableInterceptors(this.namedTableInterceptors);
        return sqlModule;
    }

    @Comment(value="\u5f00\u542f\u4e8b\u52a1\uff0c\u5e76\u5728\u56de\u8c03\u4e2d\u5904\u7406")
    public Object transaction(@Comment(name="function", value="\u56de\u8c03\u51fd\u6570\uff0c\u5982\uff1a()=>{....}") Function<?, ?> function) {
        Transaction transaction = this.transaction();
        try {
            Object val = function.apply(null);
            transaction.commit();
            return val;
        }
        catch (Throwable throwable) {
            transaction.rollback();
            throw throwable;
        }
    }

    @Comment(value="\u5f00\u542f\u4e8b\u52a1\uff0c\u8fd4\u56de\u4e8b\u52a1\u5bf9\u8c61")
    public Transaction transaction() {
        return new Transaction(this.dataSourceNode.getDataSourceTransactionManager());
    }

    @Comment(value="\u4f7f\u7528\u7f13\u5b58")
    public SQLModule cache(@Comment(name="cacheName", value="\u7f13\u5b58\u540d") String cacheName, @Comment(name="ttl", value="\u8fc7\u671f\u65f6\u95f4") long ttl) {
        if (cacheName == null) {
            return this;
        }
        SQLModule sqlModule = this.cloneSQLModule();
        sqlModule.setCacheName(cacheName);
        sqlModule.setTtl(ttl);
        return sqlModule;
    }

    @Comment(value="\u4f7f\u7528\u7f13\u5b58\uff0c\u8fc7\u671f\u65f6\u95f4\u91c7\u7528\u9ed8\u8ba4\u914d\u7f6e")
    public SQLModule cache(@Comment(name="cacheName", value="\u7f13\u5b58\u540d") String cacheName) {
        return this.cache(cacheName, 0L);
    }

    @Comment(value="\u91c7\u7528\u9a7c\u5cf0\u5217\u540d")
    public SQLModule camel() {
        return this.columnCase("camel");
    }

    @Comment(value="\u91c7\u7528\u5e15\u65af\u5361\u5217\u540d")
    public SQLModule pascal() {
        return this.columnCase("pascal");
    }

    @Comment(value="\u91c7\u7528\u5168\u5c0f\u5199\u5217\u540d")
    public SQLModule lower() {
        return this.columnCase("lower");
    }

    @Comment(value="\u91c7\u7528\u5168\u5927\u5199\u5217\u540d")
    public SQLModule upper() {
        return this.columnCase("upper");
    }

    @Comment(value="\u5217\u540d\u4fdd\u6301\u539f\u6837")
    public SQLModule normal() {
        return this.columnCase("default");
    }

    @Comment(value="\u6307\u5b9a\u5217\u540d\u8f6c\u6362")
    public SQLModule columnCase(String name) {
        SQLModule sqlModule = this.cloneSQLModule();
        sqlModule.setColumnMapRowMapper(this.columnMapperAdapter.getColumnMapRowMapper(name));
        sqlModule.setRowMapColumnMapper(this.columnMapperAdapter.getRowMapColumnMapper(name));
        return sqlModule;
    }

    @Transient
    public SQLModule getDynamicAttribute(String key) {
        SQLModule sqlModule = this.cloneSQLModule();
        if (key == null) {
            sqlModule.setDataSourceNode(this.dynamicDataSource.getDataSource());
        } else {
            sqlModule.setDataSourceNode(this.dynamicDataSource.getDataSource(key));
        }
        return sqlModule;
    }

    @Comment(value="\u67e5\u8be2SQL\uff0c\u8fd4\u56deList\u7c7b\u578b\u7ed3\u679c")
    public List<Map<String, Object>> select(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.select(runtimeContext, sqlOrXml, null);
    }

    @Comment(value="\u67e5\u8be2SQL\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u8fd4\u56deList\u7c7b\u578b\u7ed3\u679c")
    public List<Map<String, Object>> select(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.select(new BoundSql(runtimeContext, sqlOrXml, params, this));
    }

    @Transient
    public List<Map<String, Object>> select(BoundSql boundSql) {
        this.assertDatasourceNotNull();
        return boundSql.execute(this.sqlInterceptors, () -> this.queryForList(boundSql));
    }

    private List<Map<String, Object>> queryForList(BoundSql boundSql) {
        List list = this.dataSourceNode.getJdbcTemplate().query(boundSql.getSql(), this.columnMapRowMapper, boundSql.getParameters());
        if (boundSql.getExcludeColumns() != null) {
            list.forEach(row -> boundSql.getExcludeColumns().forEach(row::remove));
        }
        return list;
    }

    private void assertDatasourceNotNull() {
        if (this.dataSourceNode == null) {
            throw new NullPointerException("\u5f53\u524d\u6570\u636e\u6e90\u672a\u8bbe\u7f6e");
        }
    }

    @Comment(value="\u6267\u884cupdate\u64cd\u4f5c\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u884c\u6570")
    public int update(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.update(runtimeContext, sqlOrXml, null);
    }

    @Comment(value="\u6267\u884cupdate\u64cd\u4f5c\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u884c\u6570")
    public int update(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.update(new BoundSql(runtimeContext, sqlOrXml, params, this));
    }

    @Transient
    public int update(BoundSql boundSql) {
        this.assertDatasourceNotNull();
        RequestEntity requestEntity = RequestContext.getRequestEntity();
        this.sqlInterceptors.forEach(sqlInterceptor -> sqlInterceptor.preHandle(boundSql, requestEntity));
        Object value = this.dataSourceNode.getJdbcTemplate().update(boundSql.getSql(), boundSql.getParameters());
        this.deleteCache(this.cacheName);
        for (SQLInterceptor sqlInterceptor2 : this.sqlInterceptors) {
            value = sqlInterceptor2.postHandle(boundSql, value, requestEntity);
        }
        return (Integer)value;
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.insert(runtimeContext, sqlOrXml, null, null);
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.insert(runtimeContext, sqlOrXml, null, params);
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="primary", value="\u4e3b\u952e\u5217") String primary) {
        return this.insert(runtimeContext, sqlOrXml, primary, null);
    }

    @Comment(value="\u6267\u884cinsert\u64cd\u4f5c\uff0c\u5e76\u4f20\u5165\u4e3b\u952e\u548c\u53d8\u91cf\u4fe1\u606f\uff0c\u8fd4\u56de\u63d2\u5165\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="primary", value="\u4e3b\u952e\u5217") String primary, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.insert(new BoundSql(runtimeContext, sqlOrXml, params, this), primary);
    }

    void insert(BoundSql boundSql, MagicKeyHolder keyHolder) {
        this.assertDatasourceNotNull();
        this.dataSourceNode.getJdbcTemplate().update(con -> {
            PreparedStatement ps = keyHolder.createPrepareStatement(con, boundSql.getSql());
            new ArgumentPreparedStatementSetter(boundSql.getParameters()).setValues(ps);
            return ps;
        }, (KeyHolder)keyHolder);
        this.deleteCache(this.cacheName);
    }

    @Comment(value="\u6279\u91cf\u6267\u884c\u64cd\u4f5c\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u7684\u884c\u6570")
    public int batchUpdate(String sql, List<Object[]> args) {
        this.assertDatasourceNotNull();
        int[] values = this.dataSourceNode.getJdbcTemplate().batchUpdate(sql, args);
        this.deleteCache(this.cacheName);
        return Arrays.stream(values).sum();
    }

    @Transient
    public JdbcTemplate getJdbcTemplate() {
        this.assertDatasourceNotNull();
        return this.dataSourceNode.getJdbcTemplate();
    }

    @Comment(value="\u5220\u9664`SQL`\u7f13\u5b58")
    public SQLModule deleteCache(@Comment(value="\u7f13\u5b58\u540d\u79f0") String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.sqlCache.delete(name);
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u6267\u884c\u64cd\u4f5c\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u7684\u884c\u6570")
    public int batchUpdate(String sql, int batchSize, List<Object[]> args) {
        this.assertDatasourceNotNull();
        int[][] values = this.dataSourceNode.getJdbcTemplate().batchUpdate(sql, args, batchSize, (ps, arguments) -> {
            int colIndex = 1;
            for (Object value : arguments) {
                if (value instanceof SqlParameterValue) {
                    SqlParameterValue paramValue = (SqlParameterValue)value;
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex++, (SqlParameter)paramValue, (Object)paramValue.getValue());
                    continue;
                }
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex++, (int)StatementCreatorUtils.javaTypeToSqlParameterType(value == null ? null : value.getClass()), (Object)value);
            }
        });
        this.deleteCache(this.cacheName);
        int count = 0;
        for (int[] value : values) {
            count += Arrays.stream(value).sum();
        }
        return count;
    }

    @Comment(value="\u6279\u91cf\u6267\u884c\u64cd\u4f5c\uff0c\u8fd4\u56de\u53d7\u5f71\u54cd\u7684\u884c\u6570")
    public int batchUpdate(@Comment(name="sqls", value="`SQL`\u8bed\u53e5") List<String> sqls) {
        this.assertDatasourceNotNull();
        int[] values = this.dataSourceNode.getJdbcTemplate().batchUpdate(sqls.toArray(new String[0]));
        this.deleteCache(this.cacheName);
        return Arrays.stream(values).sum();
    }

    @Transient
    public Object insert(BoundSql boundSql, String primary) {
        MagicKeyHolder keyHolder = new MagicKeyHolder(primary);
        RequestEntity requestEntity = RequestContext.getRequestEntity();
        this.sqlInterceptors.forEach(sqlInterceptor -> sqlInterceptor.preHandle(boundSql, requestEntity));
        this.insert(boundSql, keyHolder);
        Object value = keyHolder.getObjectKey();
        for (SQLInterceptor sqlInterceptor2 : this.sqlInterceptors) {
            value = sqlInterceptor2.postHandle(boundSql, value, requestEntity);
        }
        return value;
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u81ea\u52a8\u83b7\u53d6")
    public Object page(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.page(new BoundSql(runtimeContext, sqlOrXml, params, this));
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u5206\u9875\u6761\u4ef6\u81ea\u52a8\u83b7\u53d6")
    public Object page(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.page(runtimeContext, sqlOrXml, (Map<String, Object>)null);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u624b\u52a8\u4f20\u5165")
    public Object page(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="limit", value="\u9650\u5236\u6761\u6570") long limit, @Comment(name="offset", value="\u8df3\u8fc7\u6761\u6570") long offset) {
        return this.page(runtimeContext, sqlOrXml, limit, offset, null);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u5206\u9875\u6761\u4ef6\u624b\u52a8\u4f20\u5165")
    public Object page(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="limit", value="\u9650\u5236\u6761\u6570") long limit, @Comment(name="offset", value="\u8df3\u8fc7\u6761\u6570") long offset, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        BoundSql boundSql = new BoundSql(runtimeContext, sqlOrXml, params, this);
        return this.page(boundSql, new Page(limit, offset));
    }

    @Transient
    public Object page(BoundSql boundSql) {
        Page page = this.pageProvider.getPage(boundSql.getRuntimeContext());
        return this.page(boundSql, page);
    }

    @Transient
    public String getDataSourceName() {
        return this.dataSourceNode == null ? "unknown" : this.dataSourceNode.getName();
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875`SQL`\u8bed\u53e5\u624b\u52a8\u4f20\u5165")
    public Object page(RuntimeContext runtimeContext, @Comment(name="countSqlOrXml", value="count\u8bed\u53e5") String countSqlOrXml, @Comment(name="sqlOrXml", value="\u67e5\u8be2\u8bed\u53e5") String sqlOrXml) {
        return this.page(runtimeContext, countSqlOrXml, sqlOrXml, null);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u5206\u9875`SQL`countSqlOrXml")
    public Object page(RuntimeContext runtimeContext, @Comment(name="countSqlOrXml", value="count\u8bed\u53e5") String countSqlOrXml, @Comment(name="sqlOrXml", value="\u67e5\u8be2\u8bed\u53e5") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        int count = this.selectInt(new BoundSql(runtimeContext, countSqlOrXml, params, this));
        Page page = this.pageProvider.getPage(runtimeContext);
        BoundSql boundSql = new BoundSql(runtimeContext, sqlOrXml, params, this);
        return this.page(count, boundSql, page, null);
    }

    private Object page(int count, BoundSql boundSql, Page page, Dialect dialect) {
        List list = null;
        if (count > 0) {
            if (dialect == null) {
                dialect = this.dataSourceNode.getDialect(this.dialectAdapter);
            }
            BoundSql pageBoundSql = this.buildPageBoundSql(dialect, boundSql, page.getOffset(), page.getLimit());
            list = pageBoundSql.execute(this.sqlInterceptors, () -> this.queryForList(pageBoundSql));
        }
        RequestEntity requestEntity = RequestContext.getRequestEntity();
        return this.resultProvider.buildPageResult(requestEntity, page, count, list);
    }

    @Transient
    public Object page(BoundSql boundSql, Page page) {
        this.assertDatasourceNotNull();
        Dialect dialect = this.dataSourceNode.getDialect(this.dialectAdapter);
        BoundSql countBoundSql = boundSql.copy(dialect.getCountSql(boundSql.getSql()));
        int count = this.selectInt(countBoundSql);
        return this.page(count, boundSql, page, dialect);
    }

    @Comment(value="\u67e5\u8be2int\u503c\uff0c\u9002\u5408\u5355\u884c\u5355\u5217int\u7684\u7ed3\u679c")
    public Integer selectInt(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.selectInt(runtimeContext, sqlOrXml, null);
    }

    @Comment(value="\u67e5\u8be2int\u503c\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u9002\u5408\u5355\u884c\u5355\u5217int\u7684\u7ed3\u679c")
    public Integer selectInt(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.selectInt(new BoundSql(runtimeContext, sqlOrXml, params, this));
    }

    @Transient
    public Integer selectInt(BoundSql boundSql) {
        this.assertDatasourceNotNull();
        return boundSql.execute(this.sqlInterceptors, () -> (Integer)this.dataSourceNode.getJdbcTemplate().query(boundSql.getSql(), new SingleRowResultSetExtractor<Integer>(Integer.class), boundSql.getParameters()));
    }

    @Comment(value="\u67e5\u8be2\u5355\u6761\u7ed3\u679c\uff0c\u67e5\u4e0d\u5230\u8fd4\u56denull")
    public Map<String, Object> selectOne(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.selectOne(runtimeContext, sqlOrXml, null);
    }

    @Comment(value="\u67e5\u8be2\u5355\u6761\u7ed3\u679c\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f\uff0c\u67e5\u4e0d\u5230\u8fd4\u56denull")
    public Map<String, Object> selectOne(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        return this.selectOne(new BoundSql(runtimeContext, sqlOrXml, params, this));
    }

    @Transient
    public Map<String, Object> selectOne(BoundSql boundSql) {
        this.assertDatasourceNotNull();
        return boundSql.execute(this.sqlInterceptors, () -> {
            Map row = (Map)this.dataSourceNode.getJdbcTemplate().query(boundSql.getSql(), new SingleRowResultSetExtractor<Map<String, Object>>(this.columnMapRowMapper), boundSql.getParameters());
            if (row != null && boundSql.getExcludeColumns() != null) {
                boundSql.getExcludeColumns().forEach(row::remove);
            }
            return row;
        });
    }

    @Comment(value="\u67e5\u8be2\u5355\u884c\u5355\u5217\u7684\u503c")
    public Object selectValue(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml) {
        return this.selectValue(runtimeContext, sqlOrXml, null);
    }

    @Comment(value="\u67e5\u8be2\u5355\u884c\u5355\u5217\u7684\u503c\uff0c\u5e76\u4f20\u5165\u53d8\u91cf\u4fe1\u606f")
    public Object selectValue(RuntimeContext runtimeContext, @Comment(name="sqlOrXml", value="`SQL`\u8bed\u53e5\u6216`xml`") String sqlOrXml, @Comment(name="params", value="\u53d8\u91cf\u4fe1\u606f") Map<String, Object> params) {
        this.assertDatasourceNotNull();
        BoundSql boundSql = new BoundSql(runtimeContext, sqlOrXml, params, this);
        return boundSql.execute(this.sqlInterceptors, () -> this.dataSourceNode.getJdbcTemplate().query(boundSql.getSql(), new SingleRowResultSetExtractor<Object>(Object.class), boundSql.getParameters()));
    }

    @Comment(value="\u6307\u5b9atable\uff0c\u8fdb\u884c\u5355\u8868\u64cd\u4f5c")
    public NamedTable table(@Comment(name="tableName", value="\u8868\u540d") String tableName) {
        return new NamedTable(tableName, this, this.rowMapColumnMapper, this.namedTableInterceptors);
    }

    private BoundSql buildPageBoundSql(Dialect dialect, BoundSql boundSql, long offset, long limit) {
        String pageSql = dialect.getPageSql(boundSql.getSql(), boundSql, offset, limit);
        return boundSql.copy(pageSql);
    }

    static {
        try {
            Field[] fields = Types.class.getFields();
            Map<String, Integer> mappings = Stream.of(fields).collect(Collectors.toMap(field -> field.getName().toLowerCase(), field -> (Integer)JavaReflection.getFieldValue(Types.class, (Field)field)));
            ClassConverter.register((String)"sql", (value, params) -> {
                if (params == null || ((Object[])params).length == 0) {
                    return value;
                }
                if (params[0] instanceof Number) {
                    return new SqlParameterValue(((Number)params[0]).intValue(), value);
                }
                String target = Objects.toString(params[0], null);
                if (StringUtils.isBlank((CharSequence)target)) {
                    return value;
                }
                Integer sqlType = (Integer)mappings.get(target.toLowerCase());
                return sqlType == null ? value : new SqlParameterValue(sqlType.intValue(), target, value);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class MagicKeyHolder
    extends GeneratedKeyHolder {
        private final boolean useGeneratedKeys;
        private final String primary;

        public MagicKeyHolder() {
            this(null);
        }

        public MagicKeyHolder(String primary) {
            this.primary = primary;
            this.useGeneratedKeys = StringUtils.isBlank((CharSequence)primary);
        }

        PreparedStatement createPrepareStatement(Connection connection, String sql) throws SQLException {
            if (this.useGeneratedKeys) {
                return connection.prepareStatement(sql, 1);
            }
            return connection.prepareStatement(sql, new String[]{this.primary});
        }

        public Object getObjectKey() {
            Object key;
            List keyList = this.getKeyList();
            if (keyList.isEmpty()) {
                return null;
            }
            Iterator keyIterator = ((Map)keyList.get(0)).values().iterator();
            Object object = key = keyIterator.hasNext() ? (Object)keyIterator.next() : null;
            if (key != null && "oracle.sql.ROWID".equals(key.getClass().getName())) {
                return ScriptManager.executeExpression("row.stringValue()", Collections.singletonMap("row", key));
            }
            return key;
        }
    }
}

