/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service.impl;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.service.AbstractPathMagicResourceStorage;
import org.ssssssss.magicapi.utils.PathUtils;

public class ApiInfoMagicResourceStorage
extends AbstractPathMagicResourceStorage<ApiInfo> {
    private String prefix;

    public ApiInfoMagicResourceStorage(String prefix) {
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + "/";
    }

    @Override
    public String folder() {
        return "api";
    }

    @Override
    public Class<ApiInfo> magicClass() {
        return ApiInfo.class;
    }

    @Override
    public String buildMappingKey(ApiInfo info, String path) {
        return info.getMethod().toUpperCase() + ":" + super.buildMappingKey(info, path);
    }

    @Override
    public String buildMappingKey(ApiInfo info) {
        return PathUtils.replaceSlash(this.buildMappingKey(info, this.prefix + Objects.toString(this.magicResourceService.getGroupPath(info.getGroupId()), "")));
    }

    @Override
    public void validate(ApiInfo entity) {
        this.notBlank(entity.getMethod(), REQUEST_METHOD_REQUIRED);
        super.validate(entity);
    }
}

