/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.ssssssss.magicapi.core.config.MessageType;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.script.MagicScriptDebugContext;
import org.ssssssss.script.functions.ObjectConvertExtension;

public class DebugRequest {
    private HttpServletRequest request;

    private DebugRequest(HttpServletRequest request) {
        this.request = request;
    }

    public static DebugRequest create(HttpServletRequest request) {
        return new DebugRequest(request);
    }

    public List<Integer> getRequestedBreakpoints() {
        String breakpoints = this.request.getHeader("Magic-Request-Breakpoints");
        if (breakpoints != null) {
            return Arrays.stream(breakpoints.split(",")).map(val -> ObjectConvertExtension.asInt((Object)val, (int)-1)).filter(it -> it > 0).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getRequestedScriptId() {
        return this.request.getHeader("Magic-Request-Script-Id");
    }

    public String getRequestedClientId() {
        return this.request.getHeader("Magic-Request-Client-Id");
    }

    public MagicScriptDebugContext createMagicScriptContext(int debugTimeout) {
        MagicScriptDebugContext debugContext = new MagicScriptDebugContext(this.getRequestedBreakpoints());
        String scriptId = this.getRequestedScriptId();
        String clientId = this.getRequestedClientId();
        debugContext.setTimeout(debugTimeout);
        debugContext.setId(scriptId);
        debugContext.setCallback(variables -> {
            List varList = (List)variables.get("variables");
            varList.stream().filter(it -> it.containsKey("value")).forEach(variable -> variable.put("value", JsonUtils.toJsonStringWithoutLog(variable.get("value"))));
            WebSocketSessionManager.sendByClientId(clientId, MessageType.BREAKPOINT, scriptId, variables);
        });
        return debugContext;
    }
}

