/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.handler;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.ssssssss.magicapi.core.annotation.Message;
import org.ssssssss.magicapi.core.config.MessageType;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.core.context.MagicConsoleSession;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.utils.IpUtils;

public class MagicWorkbenchHandler {
    private final AuthorizationInterceptor authorizationInterceptor;
    private static final MagicUser guest = new MagicUser("guest", "\u6e38\u5ba2", "unauthorization");

    public MagicWorkbenchHandler(AuthorizationInterceptor authorizationInterceptor) {
        this.authorizationInterceptor = authorizationInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Message(value=MessageType.LOGIN)
    public void onLogin(MagicConsoleSession session, String token, String clientId) {
        try {
            MagicUser user = guest;
            if (this.authorizationInterceptor.requireLogin() && (user = this.authorizationInterceptor.getUserByToken(token)) == null) return;
            String ip = Optional.ofNullable(session.getWebSocketSession().getRemoteAddress()).map(it -> it.getAddress().getHostAddress()).orElse("unknown");
            HttpHeaders headers = session.getWebSocketSession().getHandshakeHeaders();
            ip = IpUtils.getRealIP(ip, arg_0 -> ((HttpHeaders)headers).getFirst(arg_0), null);
            session.setAttribute("id", user.getId());
            session.setAttribute("ip", StringUtils.defaultIfBlank((CharSequence)ip, (CharSequence)"unknown"));
            session.setAttribute("username", user.getUsername());
            session.setClientId(clientId);
            session.setActivateTime(System.currentTimeMillis());
            Class<MagicWorkbenchHandler> clazz = MagicWorkbenchHandler.class;
            synchronized (MagicWorkbenchHandler.class) {
                if (WebSocketSessionManager.getConsoleSession(clientId) != null) {
                    WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "-1"));
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return;
                }
                WebSocketSessionManager.add(session);
                // ** MonitorExit[var7_8] (shouldn't be in output)
                WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "1", session.getAttributes()));
                List<Map<String, Object>> messages = this.getOnlineUsers();
                if (!messages.isEmpty()) {
                    WebSocketSessionManager.sendByClientId(session.getClientId(), WebSocketSessionManager.buildMessage(MessageType.ONLINE_USERS, messages));
                }
                WebSocketSessionManager.sendToMachine(MessageType.SEND_ONLINE, session.getClientId());
                WebSocketSessionManager.sendToOther(session.getClientId(), MessageType.USER_LOGIN, session.getAttributes());
                return;
            }
        }
        catch (MagicLoginException ignored) {
            WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "0"));
        }
    }

    @Message(value=MessageType.SEND_ONLINE)
    public void sendOnline(String clientId) {
        List<Map<String, Object>> messages = this.getOnlineUsers();
        if (!messages.isEmpty()) {
            WebSocketSessionManager.sendToMachineByClientId(clientId, WebSocketSessionManager.buildMessage(MessageType.ONLINE_USERS, messages));
        }
    }

    @Message(value=MessageType.PONG)
    public void pong(MagicConsoleSession session) {
        session.setActivateTime(System.currentTimeMillis());
    }

    private List<Map<String, Object>> getOnlineUsers() {
        return WebSocketSessionManager.getSessions().stream().map(MagicConsoleSession::getAttributes).collect(Collectors.toList());
    }
}

