/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ssssssss.magicapi.model.Backup;
import org.ssssssss.magicapi.provider.MagicBackupService;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.MD5Utils;
import org.ssssssss.magicapi.utils.WebUtils;

public class MagicFileBackupService
implements MagicBackupService {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String SUFFIX = ".json";
    private final File backupDirectory;

    public MagicFileBackupService(File backupDirectory) {
        this.backupDirectory = backupDirectory;
        if (!backupDirectory.exists()) {
            backupDirectory.mkdirs();
        }
    }

    @Override
    public void doBackup(Backup backup) {
        File directory;
        if (backup.getCreateDate() == 0L) {
            backup.setCreateDate(System.currentTimeMillis());
        }
        if (backup.getCreateBy() == null) {
            backup.setCreateBy(WebUtils.currentUserName());
        }
        if (!(directory = new File(this.backupDirectory, Instant.ofEpochMilli(backup.getCreateDate()).atZone(ZoneOffset.ofHours(8)).toLocalDate().format(FORMATTER))).exists()) {
            directory.mkdirs();
        }
        IoUtils.write(new File(directory, this.getFilename(backup)), JsonUtils.toJsonString(backup));
    }

    @Override
    public List<Backup> backupList(long timestamp) {
        File[] fileArray = this.backupDirectory.listFiles();
        ArrayList<Backup> records = new ArrayList<Backup>(100);
        if (fileArray != null) {
            List dirs = Stream.of(fileArray).sorted(Comparator.comparing(File::getName).reversed()).collect(Collectors.toList());
            block0: for (File dir : dirs) {
                fileArray = dir.listFiles((directory, name) -> this.getTimestampFromFilename(name) < timestamp);
                if (fileArray == null) continue;
                for (File file : fileArray) {
                    records.add(JsonUtils.readValue(IoUtils.string(file), Backup.class));
                    if (records.size() >= 100) break block0;
                }
            }
        }
        return records.stream().sorted(Comparator.comparing(Backup::getCreateDate).reversed()).map(Backup::small).collect(Collectors.toList());
    }

    @Override
    public List<Backup> backupById(String id) {
        return this.backupByFilenameFilter((dir, name) -> name.endsWith(id + SUFFIX)).stream().sorted(Comparator.comparing(Backup::getCreateDate).reversed()).collect(Collectors.toList());
    }

    @Override
    public Backup backupInfo(String id, long timestamp) {
        File[] files;
        File directory = new File(this.backupDirectory, Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.ofHours(8)).toLocalDate().format(FORMATTER));
        if (directory.exists() && (files = directory.listFiles((dir, name) -> name.startsWith("" + timestamp) && name.endsWith(id + SUFFIX))) != null && files.length > 0) {
            return JsonUtils.readValue(IoUtils.string(files[0]), Backup.class);
        }
        return null;
    }

    @Override
    public List<Backup> backupByTag(String tag) {
        String tagId = MD5Utils.encrypt(tag);
        return this.backupByFilenameFilter((dir, name) -> name.endsWith(SUFFIX) && name.contains("-" + tagId + "-"));
    }

    @Override
    public long removeBackup(String id) {
        return this.getFilesByFilenameFilter((dir, name) -> name.endsWith(id + SUFFIX)).stream().filter(File::delete).count();
    }

    @Override
    public long removeBackup(List<String> idList) {
        List filenames = idList.stream().map(it -> it + SUFFIX).collect(Collectors.toList());
        return this.getFilesByFilenameFilter((dir, name) -> filenames.stream().anyMatch(name::endsWith)).stream().filter(File::delete).count();
    }

    @Override
    public long removeBackupByTimestamp(long timestamp) {
        long count = this.getFilesByFilenameFilter((dir, name) -> name.contains("-") && name.endsWith(SUFFIX) && name.length() == 84 && this.getTimestampFromFilename(name) < timestamp).stream().filter(File::delete).count();
        File[] files = this.backupDirectory.listFiles(File::isDirectory);
        if (files != null) {
            for (File file : files) {
                String[] list = file.list();
                if (list != null && list.length != 0) continue;
                file.delete();
            }
        }
        return count;
    }

    private String getFilename(Backup backup) {
        return String.format("%s-%s-%s.json", backup.getCreateDate(), MD5Utils.encrypt(Objects.toString(backup.getTag(), "")), backup.getId());
    }

    private Long getTimestampFromFilename(String filename) {
        return Long.valueOf(filename.substring(0, 13));
    }

    private List<File> getFilesByFilenameFilter(FilenameFilter filenameFilter) {
        ArrayList<File> list = new ArrayList<File>();
        File[] dirs = this.backupDirectory.listFiles();
        if (dirs != null) {
            for (File dir : dirs) {
                File[] files;
                if (!dir.isDirectory() || (files = dir.listFiles(filenameFilter)) == null) continue;
                list.addAll(Arrays.asList(files));
            }
        }
        return list;
    }

    private List<Backup> backupByFilenameFilter(FilenameFilter filenameFilter) {
        return this.getFilesByFilenameFilter(filenameFilter).stream().map(IoUtils::string).map(it -> JsonUtils.readValue(it, Backup.class).small()).collect(Collectors.toList());
    }
}

