/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.ssssssss.magicapi.model.Backup;
import org.ssssssss.magicapi.provider.MagicBackupService;
import org.ssssssss.magicapi.utils.WebUtils;

public class MagicDatabaseBackupService
implements MagicBackupService {
    private static final String DEFAULT_COLUMNS = "id,create_date,tag,type,name,create_by";
    private final JdbcTemplate template;
    private final String INSERT_SQL;
    private final String FIND_BY_ID;
    private final String FIND_BY_TAG;
    private final String FIND_BY_TIMESTAMP;
    private final String FIND_BY_ID_AND_TIMESTAMP;
    private final String DELETE_BY_ID;
    private final String DELETE_BY_TIMESTAMP;
    private final BeanPropertyRowMapper<Backup> rowMapper = new BeanPropertyRowMapper(Backup.class);

    public MagicDatabaseBackupService(JdbcTemplate template, String tableName) {
        this.template = template;
        this.INSERT_SQL = String.format("insert into %s(%s,content) values(?,?,?,?,?,?,?)", tableName, DEFAULT_COLUMNS);
        this.FIND_BY_ID = String.format("select %s from %s where id = ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.DELETE_BY_ID = String.format("delete from %s where id = ?", tableName);
        this.FIND_BY_TAG = String.format("select %s from %s where tag = ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.FIND_BY_TIMESTAMP = String.format("select %s from %s where create_date < ? order by create_date desc", DEFAULT_COLUMNS, tableName);
        this.DELETE_BY_TIMESTAMP = String.format("delete from %s where create_date < ?", tableName);
        this.FIND_BY_ID_AND_TIMESTAMP = String.format("select * from %s where id = ? and create_date = ?", tableName);
    }

    @Override
    public void doBackup(Backup backup) {
        if (backup.getCreateDate() == 0L) {
            backup.setCreateDate(System.currentTimeMillis());
        }
        if (backup.getCreateBy() == null) {
            backup.setCreateBy(WebUtils.currentUserName());
        }
        this.template.update(this.INSERT_SQL, new Object[]{backup.getId(), backup.getCreateDate(), backup.getTag(), backup.getType(), backup.getName(), backup.getCreateBy(), backup.getContent()});
    }

    @Override
    public List<Backup> backupList(long timestamp) {
        try (Stream stream = this.template.queryForStream(this.FIND_BY_TIMESTAMP, this.rowMapper, new Object[]{timestamp});){
            List<Backup> list = stream.limit(100L).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Backup> backupById(String id) {
        return this.template.query(this.FIND_BY_ID, this.rowMapper, new Object[]{id});
    }

    @Override
    public Backup backupInfo(String id, long timestamp) {
        return (Backup)this.template.queryForObject(this.FIND_BY_ID_AND_TIMESTAMP, this.rowMapper, new Object[]{id, timestamp});
    }

    @Override
    public List<Backup> backupByTag(String tag) {
        return this.template.query(this.FIND_BY_TAG, this.rowMapper, new Object[]{tag});
    }

    @Override
    public long removeBackup(String id) {
        return this.template.update(this.DELETE_BY_ID, new Object[]{id});
    }

    @Override
    public long removeBackup(List<String> idList) {
        return idList.stream().mapToLong(this::removeBackup).sum();
    }

    @Override
    public long removeBackupByTimestamp(long timestamp) {
        return this.template.update(this.DELETE_BY_TIMESTAMP, new Object[]{timestamp});
    }
}

