/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.ZipResource;
import org.ssssssss.magicapi.config.MagicDynamicDataSource;
import org.ssssssss.magicapi.config.MagicFunctionManager;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.config.WebSocketSessionManager;
import org.ssssssss.magicapi.controller.MagicDataSourceController;
import org.ssssssss.magicapi.controller.MagicWebSocketDispatcher;
import org.ssssssss.magicapi.exception.InvalidArgumentException;
import org.ssssssss.magicapi.exception.MagicResourceNotFoundException;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.DataSourceInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.JsonCodeConstants;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.MagicNotify;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.model.SelectedResource;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.DataSourceEncryptProvider;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.MagicBackupService;
import org.ssssssss.magicapi.provider.MagicNotifyService;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.provider.StoreServiceProvider;
import org.ssssssss.magicapi.script.ScriptManager;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.magicapi.utils.SignUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.runtime.ExitValue;

public class DefaultMagicAPIService
implements MagicAPIService,
JsonCodeConstants {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMagicAPIService.class);
    private static final ClassLoader CLASSLOADER = MagicDataSourceController.class.getClassLoader();
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private final MappingHandlerMapping mappingHandlerMapping;
    private final boolean throwException;
    private final ResultProvider resultProvider;
    private final ApiServiceProvider apiServiceProvider;
    private final FunctionServiceProvider functionServiceProvider;
    private final GroupServiceProvider groupServiceProvider;
    private final MagicDynamicDataSource magicDynamicDataSource;
    private final MagicFunctionManager magicFunctionManager;
    private final MagicNotifyService magicNotifyService;
    private final String instanceId;
    private final Resource workspace;
    private final Resource datasourceResource;
    private final MagicBackupService backupService;
    private final DataSourceEncryptProvider dataSourceEncryptProvider;

    public DefaultMagicAPIService(MappingHandlerMapping mappingHandlerMapping, ApiServiceProvider apiServiceProvider, FunctionServiceProvider functionServiceProvider, GroupServiceProvider groupServiceProvider, ResultProvider resultProvider, MagicDynamicDataSource magicDynamicDataSource, MagicFunctionManager magicFunctionManager, MagicNotifyService magicNotifyService, String instanceId, Resource workspace, MagicBackupService backupService, DataSourceEncryptProvider dataSourceEncryptProvider, boolean throwException) {
        this.mappingHandlerMapping = mappingHandlerMapping;
        this.apiServiceProvider = apiServiceProvider;
        this.functionServiceProvider = functionServiceProvider;
        this.groupServiceProvider = groupServiceProvider;
        this.resultProvider = resultProvider;
        this.magicDynamicDataSource = magicDynamicDataSource;
        this.magicFunctionManager = magicFunctionManager;
        this.magicNotifyService = magicNotifyService;
        this.workspace = workspace;
        this.throwException = throwException;
        this.instanceId = instanceId;
        this.dataSourceEncryptProvider = dataSourceEncryptProvider;
        this.backupService = backupService;
        this.datasourceResource = workspace.getDirectory("datasource");
        if (!this.datasourceResource.exists()) {
            this.datasourceResource.mkdir();
        }
        MagicResourceLoader.addFunctionLoader((context, name) -> {
            String path;
            String method;
            ApiInfo info;
            int index = name.indexOf(":");
            if (index > -1 && (info = this.mappingHandlerMapping.getApiInfo(method = name.substring(0, index), path = name.substring(index + 1))) != null) {
                return (variables, args) -> {
                    MagicScriptContext newContext = new MagicScriptContext();
                    LinkedHashMap varMap = new LinkedHashMap(context.getRootVariables());
                    varMap.putAll(variables.getVariables(context));
                    newContext.setScriptName(groupServiceProvider.getScriptName(info.getGroupId(), info.getName(), info.getPath()));
                    newContext.putMapIntoContext(varMap);
                    Object value = ScriptManager.executeScript(info.getScript(), newContext);
                    if (value instanceof ExitValue) {
                        throw new MagicExitException((ExitValue)value);
                    }
                    return value;
                };
            }
            return null;
        });
    }

    private Object execute(ApiInfo info, Map<String, Object> context) {
        MagicScriptContext scriptContext = new MagicScriptContext();
        scriptContext.setScriptName(this.groupServiceProvider.getScriptName(info.getGroupId(), info.getName(), info.getPath()));
        scriptContext.putMapIntoContext(context);
        return ScriptManager.executeScript(info.getScript(), scriptContext);
    }

    @Override
    public <T> T execute(String method, String path, Map<String, Object> context) {
        ApiInfo info = this.mappingHandlerMapping.getApiInfo(method, path);
        if (info == null) {
            throw new MagicResourceNotFoundException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3 [%s:%s]", method, path));
        }
        return (T)this.execute(info, context);
    }

    @Override
    public <T> T call(String method, String path, Map<String, Object> context) {
        RequestEntity requestEntity = RequestEntity.empty();
        try {
            return (T)this.resultProvider.buildResult(requestEntity, this.execute(method, path, context));
        }
        catch (MagicResourceNotFoundException e) {
            return null;
        }
        catch (Throwable root) {
            if (this.throwException) {
                throw root;
            }
            return (T)this.resultProvider.buildResult(requestEntity, root);
        }
    }

    @Override
    public <T> T invoke(String path, Map<String, Object> context) {
        FunctionInfo functionInfo = this.magicFunctionManager.getFunctionInfo(path);
        if (functionInfo == null) {
            throw new MagicResourceNotFoundException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u51fd\u6570 [%s]", path));
        }
        MagicScriptContext scriptContext = new MagicScriptContext(context);
        scriptContext.setScriptName(this.groupServiceProvider.getScriptName(functionInfo.getGroupId(), functionInfo.getName(), functionInfo.getPath()));
        scriptContext.putMapIntoContext(context);
        return (T)ScriptManager.executeScript(functionInfo.getScript(), scriptContext);
    }

    @Override
    public String saveApi(ApiInfo info) {
        this.notBlank(info.getMethod(), REQUEST_METHOD_REQUIRED);
        this.notBlank(info.getPath(), REQUEST_PATH_REQUIRED);
        this.notBlank(info.getName(), API_NAME_REQUIRED);
        this.notBlank(info.getScript(), SCRIPT_REQUIRED);
        this.isTrue(IoUtils.validateFileName(info.getName()), NAME_INVALID);
        this.isTrue(!this.mappingHandlerMapping.hasRegisterMapping(info), REQUEST_PATH_CONFLICT);
        int action = 2;
        if (StringUtils.isBlank((CharSequence)info.getId())) {
            this.isTrue(!this.apiServiceProvider.exists(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            this.isTrue(this.apiServiceProvider.insert(info), API_SAVE_FAILURE);
            action = 1;
        } else {
            this.isTrue(!this.apiServiceProvider.existsWithoutId(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            this.isTrue(this.apiServiceProvider.update(info), API_SAVE_FAILURE);
            Optional<ApiInfo> optional = this.mappingHandlerMapping.getApiInfos().stream().filter(it -> it.getId().equals(info.getId())).findFirst();
            if (optional.isPresent() && !optional.get().getScript().equals(info.getScript())) {
                this.backupService.backup(info);
            }
        }
        this.mappingHandlerMapping.registerMapping(info, true);
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, info.getId(), action, 1));
        return info.getId();
    }

    @Override
    public boolean lockApi(String id) {
        return this.lockWithNotify(this.apiServiceProvider.lock(id), id, 1);
    }

    @Override
    public boolean unlockApi(String id) {
        return this.lockWithNotify(this.apiServiceProvider.unlock(id), id, 1);
    }

    @Override
    public boolean lockFunction(String id) {
        return this.lockWithNotify(this.functionServiceProvider.lock(id), id, 3);
    }

    @Override
    public boolean unlockFunction(String id) {
        return this.lockWithNotify(this.functionServiceProvider.unlock(id), id, 3);
    }

    private boolean lockWithNotify(boolean success, String id, int type) {
        if (success) {
            this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 2, type));
        }
        return success;
    }

    @Override
    public ApiInfo getApiInfo(String id) {
        return (ApiInfo)this.apiServiceProvider.get(id);
    }

    @Override
    public List<ApiInfo> apiList() {
        return this.apiServiceProvider.cachedList();
    }

    @Override
    public boolean deleteApi(String id) {
        if (this.deleteApiWithoutNotify(id)) {
            this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 3, 1));
            return true;
        }
        return false;
    }

    private boolean deleteApiWithoutNotify(String id) {
        if (this.apiServiceProvider.delete(id)) {
            this.mappingHandlerMapping.unregisterMapping(id, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveApi(String id, String groupId) {
        this.isTrue(this.groupServiceProvider.containsApiGroup(groupId), GROUP_NOT_FOUND);
        this.isTrue(this.apiServiceProvider.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.mappingHandlerMapping.move(id, groupId), REQUEST_PATH_CONFLICT);
        if (this.apiServiceProvider.move(id, groupId)) {
            this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 2, 1));
            return true;
        }
        return false;
    }

    @Override
    public String saveFunction(FunctionInfo functionInfo) {
        this.notBlank(functionInfo.getName(), FUNCTION_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(functionInfo.getName()), NAME_INVALID);
        this.notBlank(functionInfo.getPath(), FUNCTION_PATH_REQUIRED);
        this.notBlank(functionInfo.getScript(), SCRIPT_REQUIRED);
        this.isTrue(!this.magicFunctionManager.hasRegister(functionInfo), FUNCTION_PATH_CONFLICT);
        int action = 2;
        if (StringUtils.isBlank((CharSequence)functionInfo.getId())) {
            this.isTrue(!this.functionServiceProvider.exists(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            this.isTrue(this.functionServiceProvider.insert(functionInfo), FUNCTION_SAVE_FAILURE);
            action = 1;
        } else {
            this.isTrue(!this.functionServiceProvider.existsWithoutId(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            FunctionInfo oldInfo = (FunctionInfo)this.functionServiceProvider.get(functionInfo.getId());
            this.isTrue(this.functionServiceProvider.update(functionInfo), FUNCTION_SAVE_FAILURE);
            if (!oldInfo.getScript().equals(functionInfo.getScript())) {
                this.backupService.backup(functionInfo);
            }
        }
        this.magicFunctionManager.register(functionInfo);
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, functionInfo.getId(), action, 3));
        return functionInfo.getId();
    }

    @Override
    public FunctionInfo getFunctionInfo(String id) {
        return (FunctionInfo)this.functionServiceProvider.get(id);
    }

    @Override
    public List<FunctionInfo> functionList() {
        return this.functionServiceProvider.cachedList();
    }

    @Override
    public boolean deleteFunction(String id) {
        if (this.deleteFunctionWithoutNotify(id)) {
            this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 3, 3));
            return true;
        }
        return false;
    }

    private boolean deleteFunctionWithoutNotify(String id) {
        if (this.functionServiceProvider.delete(id)) {
            this.magicFunctionManager.unregister(id);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveFunction(String id, String groupId) {
        this.isTrue(this.functionServiceProvider.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.magicFunctionManager.move(id, groupId), FUNCTION_PATH_CONFLICT);
        if (this.functionServiceProvider.move(id, groupId)) {
            this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 2, 3));
            return true;
        }
        return false;
    }

    @Override
    public String createGroup(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        this.isTrue(this.groupServiceProvider.insert(group), GROUP_SAVE_FAILURE);
        if (Objects.equals(group.getType(), "1")) {
            this.mappingHandlerMapping.loadGroup();
        } else {
            this.magicFunctionManager.loadGroup();
        }
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, group.getId(), 1, 2));
        return group.getId();
    }

    @Override
    public boolean updateGroup(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        boolean isApiGroup = "1".equals(group.getType());
        boolean isFunctionGroup = "2".equals(group.getType());
        if (isApiGroup && this.mappingHandlerMapping.checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.mappingHandlerMapping.updateGroup(group.getId());
        } else if (isFunctionGroup && this.magicFunctionManager.checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.magicFunctionManager.updateGroup(group.getId());
        }
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, group.getId(), 2, 2));
        return true;
    }

    @Override
    public boolean deleteGroup(String groupId) {
        boolean success = this.deleteGroupWithoutNotify(groupId);
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, groupId, 3, 2));
        return success;
    }

    private boolean deleteGroupWithoutNotify(String groupId) {
        boolean success;
        boolean isApi = true;
        TreeNode<Group> treeNode = this.groupServiceProvider.apiGroupTree().findTreeNode(group -> group.getId().equals(groupId));
        if (treeNode == null) {
            treeNode = this.groupServiceProvider.functionGroupTree().findTreeNode(group -> group.getId().equals(groupId));
            this.notNull(treeNode, GROUP_NOT_FOUND);
            isApi = false;
        }
        List<String> children = treeNode.flat().stream().map(Group::getId).collect(Collectors.toList());
        if (isApi) {
            success = this.apiServiceProvider.deleteGroup(groupId, children);
            if (success) {
                this.mappingHandlerMapping.deleteGroup(children);
                children.forEach(this.groupServiceProvider::delete);
            }
        } else {
            success = this.functionServiceProvider.deleteGroup(groupId, children);
            if (success) {
                this.magicFunctionManager.deleteGroup(children);
                children.forEach(this.groupServiceProvider::delete);
            }
        }
        return success;
    }

    @Override
    public List<Group> groupList(String type) {
        return this.groupServiceProvider.cachedGroupList(type);
    }

    @Override
    public Group getGroup(String id) {
        Resource groupResource = this.groupServiceProvider.getGroupResource(id);
        Resource resource = groupResource = groupResource != null ? groupResource.getResource("group.json") : null;
        if (groupResource != null && groupResource.exists()) {
            return this.groupServiceProvider.readGroup(groupResource);
        }
        return null;
    }

    @Override
    public void registerAllDataSource() {
        this.datasourceResource.readAll();
        List<Resource> resources = this.datasourceResource.files(".json");
        this.magicDynamicDataSource.datasourceNodes().stream().filter(it -> it.getId() != null).map(MagicDynamicDataSource.DataSourceNode::getKey).collect(Collectors.toList()).forEach(this.magicDynamicDataSource::delete);
        for (Resource item : resources) {
            this.registerDataSource(JsonUtils.readValue(item.read(), DataSourceInfo.class));
        }
    }

    private String registerDataSource(DataSourceInfo properties) {
        if (properties != null) {
            if (this.dataSourceEncryptProvider != null) {
                this.dataSourceEncryptProvider.decrypt(properties);
            }
            String key = properties.get("key");
            String name = properties.getOrDefault("name", key);
            String dsId = properties.remove("id");
            int maxRows = ObjectConvertExtension.asInt((Object)properties.get("maxRows"), (int)-1);
            this.magicDynamicDataSource.put(dsId, key, name, this.createDataSource(properties), maxRows);
            return key;
        }
        return null;
    }

    @Override
    public DataSourceInfo getDataSource(String id) {
        Resource resource = this.datasourceResource.getResource(id + ".json");
        byte[] bytes = resource.read();
        this.isTrue(bytes != null && bytes.length > 0, DATASOURCE_NOT_FOUND);
        return JsonUtils.readValue(bytes, DataSourceInfo.class);
    }

    @Override
    public List<DataSourceInfo> datasourceList() {
        return this.magicDynamicDataSource.datasourceNodes().stream().map(it -> {
            DataSourceInfo info = new DataSourceInfo();
            info.put("id", it.getId());
            info.put("key", it.getKey());
            info.put("name", it.getName());
            return info;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testDataSource(DataSourceInfo properties) {
        DataSource dataSource = null;
        try {
            properties.remove("id");
            dataSource = this.createDataSource(properties);
            Connection connection = dataSource.getConnection();
            DataSourceUtils.doCloseConnection((Connection)connection, (DataSource)dataSource);
        }
        catch (Exception e) {
            String string;
            try {
                logger.error("\u6d4b\u8bd5\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                string = e.getMessage();
            }
            catch (Throwable throwable) {
                IoUtils.closeDataSource(dataSource);
                throw throwable;
            }
            IoUtils.closeDataSource(dataSource);
            return string;
        }
        IoUtils.closeDataSource(dataSource);
        return null;
    }

    @Override
    public String saveDataSource(DataSourceInfo properties) {
        Stream<Object> keyStream;
        String key = properties.get("key");
        this.notBlank(key, DATASOURCE_KEY_REQUIRED);
        this.isTrue(IoUtils.validateFileName(key), DATASOURCE_KEY_INVALID);
        String name = properties.getOrDefault("name", key);
        String id = properties.get("id");
        int action = 2;
        if (StringUtils.isBlank((CharSequence)id)) {
            action = 1;
            keyStream = this.magicDynamicDataSource.datasources().stream();
        } else {
            keyStream = this.magicDynamicDataSource.datasourceNodes().stream().filter(it -> !id.equals(it.getId())).map(MagicDynamicDataSource.DataSourceNode::getKey);
        }
        String dsId = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString().replace("-", "") : id;
        this.isTrue(keyStream.noneMatch(key::equals), DATASOURCE_KEY_EXISTS);
        int maxRows = ObjectConvertExtension.asInt((Object)properties.get("maxRows"), (int)-1);
        properties.remove("id");
        this.magicDynamicDataSource.put(dsId, key, name, this.createDataSource(properties), maxRows);
        properties.put("id", dsId);
        if (this.dataSourceEncryptProvider != null) {
            this.dataSourceEncryptProvider.encrypt(properties);
        }
        this.datasourceResource.getResource(dsId + ".json").write(JsonUtils.toJsonString(properties));
        this.backupService.backup(properties);
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, dsId, action, 4));
        return dsId;
    }

    @Override
    public boolean deleteDataSource(String id) {
        Optional<MagicDynamicDataSource.DataSourceNode> dataSourceNode = this.magicDynamicDataSource.datasourceNodes().stream().filter(it -> id.equals(it.getId())).findFirst();
        this.isTrue(dataSourceNode.isPresent(), DATASOURCE_NOT_FOUND);
        Resource resource = this.datasourceResource.getResource(id + ".json");
        this.isTrue(resource.delete(), DATASOURCE_NOT_FOUND);
        dataSourceNode.ifPresent(it -> this.magicDynamicDataSource.delete(it.getKey()));
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId, id, 3, 4));
        return true;
    }

    @Override
    public void upload(InputStream inputStream, String mode) throws IOException {
        ZipResource root = new ZipResource(inputStream);
        LinkedHashSet<String> apiPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> functionPaths = new LinkedHashSet<String>();
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        LinkedHashSet<ApiInfo> apiInfos = new LinkedHashSet<ApiInfo>();
        LinkedHashSet<FunctionInfo> functionInfos = new LinkedHashSet<FunctionInfo>();
        boolean checked = !"full".equals(mode);
        this.readPaths(groups, apiPaths, functionPaths, apiInfos, functionInfos, "/", root, checked);
        Resource item = root.getResource("group.json");
        if (item.exists()) {
            Group group2 = this.groupServiceProvider.readGroup(item);
            this.isTrue("0".equals(group2.getParentId()) || this.groupServiceProvider.getGroupResource(group2.getParentId()).exists(), GROUP_NOT_FOUND);
        }
        if (checked) {
            groups.forEach(group -> {
                Resource resource = "0".equals(group.getParentId()) ? this.workspace.getDirectory("1".equals(group.getType()) ? "api" : "function").getDirectory(group.getName()) : this.groupServiceProvider.getGroupResource(group.getId());
                if (resource != null && resource.exists()) {
                    Group src = this.groupServiceProvider.readGroup(resource.getResource("group.json"));
                    this.isTrue(src == null || src.getId().equals(group.getId()), GROUP_CONFLICT);
                }
            });
        } else {
            Object resource = this.workspace.getDirectory("api");
            resource.delete();
            resource.mkdir();
            resource = this.workspace.getDirectory("function");
            resource.delete();
            resource.mkdir();
            resource = this.workspace.getDirectory("datasource");
            resource.delete();
            resource.mkdir();
        }
        for (Group group3 : groups) {
            Resource groupResource = this.groupServiceProvider.getGroupResource(group3.getId());
            if (groupResource != null && groupResource.exists()) {
                this.groupServiceProvider.update(group3);
            } else {
                this.groupServiceProvider.insert(group3);
            }
            if (!checked) continue;
            if ("1".equals(group3.getType())) {
                this.mappingHandlerMapping.updateGroup(group3.getId());
                continue;
            }
            this.magicFunctionManager.updateGroup(group3.getId());
        }
        this.write(this.apiServiceProvider, apiInfos);
        this.write(this.functionServiceProvider, functionInfos);
        apiInfos.forEach(this.backupService::backup);
        functionInfos.forEach(this.backupService::backup);
        this.mappingHandlerMapping.registerAllMapping();
        this.magicFunctionManager.registerAllFunction();
        Resource uploadDatasourceResource = root.getResource("datasource/");
        if (uploadDatasourceResource.exists()) {
            uploadDatasourceResource.files(".json").forEach(it -> {
                byte[] content = it.read();
                this.datasourceResource.getResource(it.name()).write(content);
            });
        }
        this.registerAllDataSource();
        this.magicNotifyService.sendNotify(new MagicNotify(this.instanceId));
    }

    @Override
    public void download(String groupId, List<SelectedResource> resources, OutputStream os) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            Resource resource = this.groupServiceProvider.getGroupResource(groupId);
            this.notNull(resource, GROUP_NOT_FOUND);
            resource.export(os, new String[0]);
        } else if (resources == null || resources.isEmpty()) {
            this.workspace.export(os, "backups", "backup");
        } else {
            ZipOutputStream zos = new ZipOutputStream(os);
            for (SelectedResource item : resources) {
                Resource resource;
                StoreServiceProvider storeServiceProvider = null;
                if ("root".equals(item.getType())) {
                    zos.putNextEntry(new ZipEntry(item.getId() + "/"));
                    zos.closeEntry();
                } else if ("group".equals(item.getType())) {
                    Resource resource2 = this.groupServiceProvider.getGroupResource(item.getId());
                    zos.putNextEntry(new ZipEntry(resource2.getFilePath()));
                    zos.closeEntry();
                    resource2 = resource2.getResource("group.json");
                    zos.putNextEntry(new ZipEntry(resource2.getFilePath()));
                    zos.write(resource2.read());
                    zos.closeEntry();
                } else if ("api".equals(item.getType())) {
                    storeServiceProvider = this.apiServiceProvider;
                } else if ("function".equals(item.getType())) {
                    storeServiceProvider = this.functionServiceProvider;
                } else if ("datasource".equals(item.getType())) {
                    String filename = item.getId() + ".json";
                    resource = this.datasourceResource.getResource(filename);
                    zos.putNextEntry(new ZipEntry(resource.getFilePath()));
                    zos.write(resource.read());
                    zos.closeEntry();
                }
                if (storeServiceProvider == null) continue;
                Object entity = storeServiceProvider.get(item.getId());
                resource = this.groupServiceProvider.getGroupResource(((MagicEntity)entity).getGroupId());
                zos.putNextEntry(new ZipEntry(resource.getFilePath() + ((MagicEntity)entity).getName() + ".ms"));
                zos.write(storeServiceProvider.serialize(entity));
                zos.closeEntry();
            }
            zos.close();
        }
    }

    @Override
    public JsonBean<?> push(String target, String secretKey, String mode, List<SelectedResource> resources) {
        this.notBlank(target, TARGET_IS_REQUIRED);
        this.notBlank(secretKey, SECRET_KEY_IS_REQUIRED);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.download(null, resources, baos);
        }
        catch (IOException e) {
            return new JsonBean(-1, e.getMessage());
        }
        final byte[] bytes = baos.toByteArray();
        long timestamp = System.currentTimeMillis();
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"timestamp", (Object)timestamp);
        param.add((Object)"mode", (Object)mode);
        param.add((Object)"sign", (Object)SignUtils.sign(timestamp, secretKey, mode, bytes));
        param.add((Object)"file", (Object)new InputStreamResource(new ByteArrayInputStream(bytes)){

            public String getFilename() {
                return "magic-api.zip";
            }

            public long contentLength() {
                return bytes.length;
            }
        });
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        return (JsonBean)restTemplate.postForObject(target, (Object)new HttpEntity((Object)param, (MultiValueMap)headers), JsonBean.class, new Object[0]);
    }

    @Override
    public boolean processNotify(MagicNotify magicNotify) {
        if (magicNotify == null || this.instanceId.equals(magicNotify.getFrom())) {
            return false;
        }
        logger.info("\u6536\u5230\u901a\u77e5\u6d88\u606f:{}", (Object)magicNotify);
        String id = magicNotify.getId();
        int action = magicNotify.getAction();
        switch (magicNotify.getType()) {
            case 1: {
                return this.processApiNotify(id, action);
            }
            case 3: {
                return this.processFunctionNotify(id, action);
            }
            case 2: {
                return this.processGroupNotify(id, action);
            }
            case 4: {
                return this.processDataSourceNotify(id, action);
            }
            case 0: {
                return this.processAllNotify();
            }
        }
        switch (action) {
            case 100: {
                return this.processWebSocketMessageReceived(magicNotify.getSessionId(), magicNotify.getContent());
            }
            case 200: {
                return this.processWebSocketSendMessage(magicNotify.getSessionId(), magicNotify.getContent());
            }
        }
        return false;
    }

    @Override
    public String copyGroup(String srcId, String target) {
        Group src = this.getGroup(srcId);
        src.setId(null);
        src.setParentId(target);
        src.setName(src.getName() + "(\u590d\u5236)");
        src.setPath(src.getPath() + "_copy");
        String newId = this.createGroup(src);
        if ("1".equals(src.getType())) {
            this.apiServiceProvider.listWithScript().stream().filter(it -> srcId.equals(it.getGroupId())).map(ApiInfo::copy).peek(it -> it.setGroupId(newId)).peek(it -> it.setId(null)).forEach(this::saveApi);
        } else {
            this.functionServiceProvider.listWithScript().stream().filter(it -> srcId.equals(it.getGroupId())).map(FunctionInfo::copy).peek(it -> it.setGroupId(newId)).peek(it -> it.setId(null)).forEach(this::saveFunction);
        }
        return newId;
    }

    @Override
    public String getModuleName() {
        return "magic";
    }

    private boolean processWebSocketSendMessage(String sessionId, String content) {
        WebSocketSessionManager.sendBySessionId(sessionId, content);
        return true;
    }

    private boolean processWebSocketMessageReceived(String sessionId, String content) {
        MagicWebSocketDispatcher.processMessageReceived(sessionId, content);
        return true;
    }

    private boolean processApiNotify(String id, int action) {
        this.apiServiceProvider.listWithScript();
        if (action == 3) {
            this.mappingHandlerMapping.unregisterMapping(id, true);
        } else {
            this.mappingHandlerMapping.registerMapping((ApiInfo)this.apiServiceProvider.get(id), true);
        }
        return true;
    }

    private boolean processFunctionNotify(String id, int action) {
        this.functionServiceProvider.listWithScript();
        if (action == 3) {
            this.magicFunctionManager.unregister(id);
        } else {
            this.magicFunctionManager.register((FunctionInfo)this.functionServiceProvider.get(id));
        }
        return true;
    }

    private boolean processDataSourceNotify(String id, int action) {
        if (action == 3) {
            this.magicDynamicDataSource.datasourceNodes().stream().filter(it -> id.equals(it.getId())).findFirst().ifPresent(it -> this.magicDynamicDataSource.delete(it.getKey()));
        } else {
            this.datasourceResource.readAll();
            this.registerDataSource(this.getDataSource(id));
        }
        return true;
    }

    private boolean processGroupNotify(String id, int action) {
        if (action == 1) {
            this.mappingHandlerMapping.loadGroup();
            this.magicFunctionManager.loadGroup();
            return true;
        }
        if (action == 2) {
            if (!this.mappingHandlerMapping.updateGroup(id)) {
                return this.magicFunctionManager.updateGroup(id);
            }
        } else if (action == 3) {
            TreeNode<Group> treeNode = this.mappingHandlerMapping.findGroupTree(id);
            if (treeNode == null) {
                treeNode = this.magicFunctionManager.findGroupTree(id);
                this.magicFunctionManager.deleteGroup(treeNode.flat().stream().map(Group::getId).collect(Collectors.toList()));
                this.functionServiceProvider.listWithScript();
            } else {
                this.mappingHandlerMapping.deleteGroup(treeNode.flat().stream().map(Group::getId).collect(Collectors.toList()));
                this.apiServiceProvider.listWithScript();
            }
        }
        return true;
    }

    private boolean processAllNotify() {
        this.mappingHandlerMapping.registerAllMapping();
        this.magicFunctionManager.registerAllFunction();
        this.registerAllDataSource();
        return true;
    }

    private DataSource createDataSource(DataSourceInfo properties) {
        Class<? extends DataSource> dataSourceType = this.getDataSourceType(properties.get("type"));
        if (!properties.containsKey("driverClassName") && properties.containsKey("url")) {
            String url = properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            properties.put("driverClassName", driverClass);
        }
        DataSource dataSource = (DataSource)BeanUtils.instantiateClass(dataSourceType);
        MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)dataSource));
        return dataSource;
    }

    private Class<? extends DataSource> getDataSourceType(String datasourceType) {
        if (StringUtils.isNotBlank((CharSequence)datasourceType)) {
            try {
                return ClassUtils.forName((String)datasourceType, (ClassLoader)CLASSLOADER);
            }
            catch (Exception e) {
                throw new InvalidArgumentException(DATASOURCE_TYPE_NOT_FOUND.format(datasourceType));
            }
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)CLASSLOADER);
            }
            catch (Exception exception) {
            }
        }
        throw new InvalidArgumentException(DATASOURCE_TYPE_NOT_SET);
    }

    private <T extends MagicEntity> void write(StoreServiceProvider<T> provider, Set<T> infos) {
        for (MagicEntity info : infos) {
            T oldInfo = provider.get(info.getId());
            if (oldInfo != null) {
                provider.update(info);
                continue;
            }
            provider.insert(info);
        }
    }

    private void readPaths(Set<Group> groups, Set<String> apiPaths, Set<String> functionPaths, Set<ApiInfo> apiInfos, Set<FunctionInfo> functionInfos, String parentPath, Resource root, boolean checked) {
        Resource resource = root.getResource("group.json");
        String path = "";
        if (resource.exists()) {
            Group group = JsonUtils.readValue(resource.read(), Group.class);
            groups.add(group);
            path = Objects.toString(group.getPath(), "");
            boolean isApi = "1".equals(group.getType());
            for (Resource file : root.files(".ms")) {
                MagicEntity info;
                if (isApi) {
                    info = (ApiInfo)this.apiServiceProvider.deserialize(file.read());
                    if (checked) {
                        this.checkApiConflict((ApiInfo)info);
                    }
                    apiInfos.add((ApiInfo)info);
                    String apiPath = Objects.toString(((ApiInfo)info).getMethod(), "GET") + ":" + PathUtils.replaceSlash(parentPath + "/" + path + "/" + ((ApiInfo)info).getPath());
                    this.isTrue(apiPaths.add(apiPath), UPLOAD_PATH_CONFLICT.format(apiPath));
                    continue;
                }
                info = (FunctionInfo)this.functionServiceProvider.deserialize(file.read());
                if (checked) {
                    this.checkFunctionConflict((FunctionInfo)info);
                }
                functionInfos.add((FunctionInfo)info);
                String functionPath = PathUtils.replaceSlash(parentPath + "/" + path + "/" + ((FunctionInfo)info).getPath());
                this.isTrue(functionPaths.add(functionPath), UPLOAD_PATH_CONFLICT.format(functionPath));
            }
        }
        for (Resource directory : root.dirs()) {
            this.readPaths(groups, apiPaths, functionPaths, apiInfos, functionInfos, PathUtils.replaceSlash(parentPath + "/" + path), directory, checked);
        }
    }

    private ApiInfo checkApiConflict(ApiInfo info) {
        Resource resource;
        Resource groupResource = this.groupServiceProvider.getGroupResource(info.getGroupId());
        if (groupResource != null && (resource = groupResource.getResource(info.getName() + ".ms")).exists()) {
            ApiInfo oldInfo = (ApiInfo)this.apiServiceProvider.deserialize(resource.read());
            this.isTrue(oldInfo.getId().equals(info.getId()), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
        }
        return info;
    }

    private FunctionInfo checkFunctionConflict(FunctionInfo info) {
        Resource resource;
        Resource groupResource = this.groupServiceProvider.getGroupResource(info.getGroupId());
        if (groupResource != null && groupResource.exists() && (resource = groupResource.getResource(info.getName() + ".ms")).exists()) {
            FunctionInfo oldInfo = (FunctionInfo)this.functionServiceProvider.deserialize(resource.read());
            this.isTrue(oldInfo.getId().equals(info.getId()), FUNCTION_ALREADY_EXISTS.format(info.getName()));
        }
        return info;
    }
}

