/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider;

import java.util.List;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.Backup;
import org.ssssssss.magicapi.model.DataSourceInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.utils.JsonUtils;

public interface MagicBackupService {
    public static final int FETCH_SIZE = 100;

    default public void backup(ApiInfo apiInfo) {
        this.doBackup(new Backup(apiInfo.getId(), "api", apiInfo.getName(), JsonUtils.toJsonString(apiInfo)));
    }

    default public void backup(FunctionInfo functionInfo) {
        this.doBackup(new Backup(functionInfo.getId(), "function", functionInfo.getName(), JsonUtils.toJsonString(functionInfo)));
    }

    default public void backup(DataSourceInfo dataSourceInfo) {
        this.doBackup(new Backup(dataSourceInfo.getId(), "datasource", dataSourceInfo.get("name"), JsonUtils.toJsonString(dataSourceInfo)));
    }

    public void doBackup(Backup var1);

    public List<Backup> backupList(long var1);

    public List<Backup> backupById(String var1);

    public Backup backupInfo(String var1, long var2);

    public List<Backup> backupByTag(String var1);

    public long removeBackup(String var1);

    public long removeBackup(List<String> var1);

    public long removeBackupByTimestamp(long var1);
}

