/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.mybatis;

import java.io.ByteArrayInputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.modules.mybatis.ForeachSqlNode;
import org.ssssssss.magicapi.modules.mybatis.IfSqlNode;
import org.ssssssss.magicapi.modules.mybatis.SetSqlNode;
import org.ssssssss.magicapi.modules.mybatis.SqlNode;
import org.ssssssss.magicapi.modules.mybatis.TextSqlNode;
import org.ssssssss.magicapi.modules.mybatis.TrimSqlNode;
import org.ssssssss.magicapi.modules.mybatis.WhereSqlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MybatisParser {
    private static final Pattern ESCAPE_LT_PATTERN = Pattern.compile("<([\\d'\"\\s=>#$?(])");
    private static final String ESCAPE_LT_REPLACEMENT = "&lt;$1";

    public static SqlNode parse(String xml) {
        try {
            xml = "<magic-api>" + MybatisParser.escapeXml(xml) + "</magic-api>";
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            TextSqlNode sqlNode = new TextSqlNode("");
            MybatisParser.parseNodeList(sqlNode, document.getDocumentElement().getChildNodes());
            return sqlNode;
        }
        catch (Exception e) {
            throw new MagicAPIException("SQL\u89e3\u6790\u9519\u8bef", e);
        }
    }

    private static String escapeXml(String xml) {
        return ESCAPE_LT_PATTERN.matcher(xml).replaceAll(ESCAPE_LT_REPLACEMENT);
    }

    private static void parseNodeList(SqlNode sqlNode, NodeList nodeList) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            SqlNode childNode;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                sqlNode.addChildNode(new TextSqlNode(node.getNodeValue().trim()));
                continue;
            }
            if (node.getNodeType() == 8) continue;
            String nodeName = node.getNodeName();
            if ("foreach".equalsIgnoreCase(nodeName)) {
                childNode = MybatisParser.parseForeachSqlNode(node);
            } else if ("if".equalsIgnoreCase(nodeName)) {
                childNode = new IfSqlNode(MybatisParser.getNodeAttributeValue(node, "test"));
            } else if ("trim".equalsIgnoreCase(nodeName)) {
                childNode = MybatisParser.parseTrimSqlNode(node);
            } else if ("set".equalsIgnoreCase(nodeName)) {
                childNode = MybatisParser.parseSetSqlNode();
            } else if ("where".equalsIgnoreCase(nodeName)) {
                childNode = MybatisParser.parseWhereSqlNode();
            } else {
                throw new UnsupportedOperationException("Unsupported tags :" + nodeName);
            }
            sqlNode.addChildNode(childNode);
            if (!node.hasChildNodes()) continue;
            MybatisParser.parseNodeList(childNode, node.getChildNodes());
        }
    }

    private static ForeachSqlNode parseForeachSqlNode(Node node) {
        ForeachSqlNode foreachSqlNode = new ForeachSqlNode();
        foreachSqlNode.setCollection(MybatisParser.getNodeAttributeValue(node, "collection"));
        foreachSqlNode.setSeparator(MybatisParser.getNodeAttributeValue(node, "separator"));
        foreachSqlNode.setClose(MybatisParser.getNodeAttributeValue(node, "close"));
        foreachSqlNode.setOpen(MybatisParser.getNodeAttributeValue(node, "open"));
        foreachSqlNode.setItem(MybatisParser.getNodeAttributeValue(node, "item"));
        return foreachSqlNode;
    }

    private static TrimSqlNode parseTrimSqlNode(Node node) {
        TrimSqlNode trimSqlNode = new TrimSqlNode();
        trimSqlNode.setPrefix(MybatisParser.getNodeAttributeValue(node, "prefix"));
        trimSqlNode.setPrefixOverrides(MybatisParser.getNodeAttributeValue(node, "prefixOverrides"));
        trimSqlNode.setSuffix(MybatisParser.getNodeAttributeValue(node, "suffix"));
        trimSqlNode.setSuffixOverrides(MybatisParser.getNodeAttributeValue(node, "suffixOverrides"));
        return trimSqlNode;
    }

    private static SetSqlNode parseSetSqlNode() {
        return new SetSqlNode();
    }

    private static WhereSqlNode parseWhereSqlNode() {
        return new WhereSqlNode();
    }

    private static String getNodeAttributeValue(Node node, String attributeKey) {
        Node item = node.getAttributes().getNamedItem(attributeKey);
        return item != null ? item.getNodeValue() : null;
    }

    public static void main(String[] args) {
        System.out.println(MybatisParser.escapeXml("<where> <if test=\"111\"> and 1 < 2 and 1<6 and 2>#{666}</if></where>"));
    }
}

