/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.ssssssss.magicapi.context.RequestContext;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.functions.ObjectConvertExtension;

public class ResponseModule {
    private final ResultProvider resultProvider;

    public ResponseModule(ResultProvider resultProvider) {
        this.resultProvider = resultProvider;
    }

    @Comment(value="\u6587\u4ef6\u4e0b\u8f7d")
    public static ResponseEntity<?> download(@Comment(name="value", value="\u6587\u4ef6\u5185\u5bb9\uff0c\u5982`byte[]`") Object value, @Comment(name="filename", value="\u6587\u4ef6\u540d") String filename) throws UnsupportedEncodingException {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=" + URLEncoder.encode(filename, "UTF-8")})).body(value);
    }

    @Comment(value="\u8fd4\u56de\u81ea\u5b9a\u4e49\u5206\u9875\u7ed3\u679c")
    public Object page(@Comment(name="total", value="\u603b\u6761\u6570") long total, @Comment(name="values", value="\u5f53\u524d\u7ed3\u679c\u96c6") List<Map<String, Object>> values) {
        return this.resultProvider.buildPageResult(RequestContext.getRequestEntity(), null, total, values);
    }

    @Comment(value="\u81ea\u5b9a\u4e49\u8fd4\u56dejson\u5185\u5bb9")
    public ResponseEntity<Object> json(@Comment(name="value", value="\u8fd4\u56de\u5bf9\u8c61") Object value) {
        return ResponseEntity.ok((Object)value);
    }

    @Comment(value="\u6dfb\u52a0response header")
    public ResponseModule addHeader(@Comment(name="key", value="header\u540d") String key, @Comment(name="value", value="header\u503c") String value) {
        HttpServletResponse response;
        if (StringUtils.isNotBlank((CharSequence)key) && (response = this.getResponse()) != null) {
            response.addHeader(key, value);
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6eresponse header")
    public ResponseModule setHeader(@Comment(name="key", value="header\u540d") String key, @Comment(name="value", value="header\u503c") String value) {
        HttpServletResponse response;
        if (StringUtils.isNotBlank((CharSequence)key) && (response = this.getResponse()) != null) {
            response.setHeader(key, value);
        }
        return this;
    }

    @Comment(value="\u6dfb\u52a0Cookie")
    public ResponseModule addCookie(@Comment(name="name", value="cookie\u540d") String name, @Comment(name="value", value="cookie\u503c") String value) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.addCookie(new Cookie(name, value));
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u6dfb\u52a0Cookie")
    public ResponseModule addCookies(@Comment(name="cookies", value="Cookies") Map<String, String> cookies, @Comment(name="options", value="Cookie\u9009\u9879\uff0c\u5982`path`\u3001`httpOnly`\u3001`domain`\u3001`maxAge`") Map<String, Object> options) {
        if (cookies != null) {
            for (Map.Entry<String, String> entry : cookies.entrySet()) {
                this.addCookie(entry.getKey(), entry.getValue(), options);
            }
        }
        return this;
    }

    @Comment(value="\u6279\u91cf\u6dfb\u52a0Cookie")
    public ResponseModule addCookies(@Comment(name="cookies", value="Cookies") Map<String, String> cookies) {
        return this.addCookies(cookies, null);
    }

    @Comment(value="\u83b7\u53d6OutputStream")
    public OutputStream getOutputStream() throws IOException {
        HttpServletResponse response = this.getResponse();
        return response.getOutputStream();
    }

    @Comment(value="\u6dfb\u52a0Cookie")
    public ResponseModule addCookie(@Comment(name="name", value="Cookie\u540d") String name, @Comment(name="value", value="Cookie\u503c") String value, @Comment(name="options", value="Cookie\u9009\u9879\uff0c\u5982`path`\u3001`httpOnly`\u3001`domain`\u3001`maxAge`") Map<String, Object> options) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            Cookie cookie = new Cookie(name, value);
            if (options != null) {
                int age;
                Object maxAge;
                Object domain;
                Object httpOnly;
                Object path = options.get("path");
                if (path != null) {
                    cookie.setPath(path.toString());
                }
                if ((httpOnly = options.get("httpOnly")) != null) {
                    cookie.setHttpOnly("true".equalsIgnoreCase(httpOnly.toString()));
                }
                if ((domain = options.get("domain")) != null) {
                    cookie.setDomain(domain.toString());
                }
                if ((maxAge = options.get("maxAge")) != null && (age = ObjectConvertExtension.asInt((Object)maxAge, (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    cookie.setMaxAge(age);
                }
            }
            this.addCookie(cookie);
        }
        return this;
    }

    @Comment(value="\u7ec8\u6b62\u8f93\u51fa\uff0c\u6267\u884c\u6b64\u65b9\u6cd5\u540e\u4e0d\u4f1a\u5bf9\u7ed3\u679c\u8fdb\u884c\u4efb\u4f55\u8f93\u51fa\u53ca\u5904\u7406")
    public NullValue end() {
        return NullValue.INSTANCE;
    }

    @Comment(value="\u6dfb\u52a0Cookie")
    public ResponseModule addCookie(@Comment(name="cookie", value="Cookie\u5bf9\u8c61") Cookie cookie) {
        HttpServletResponse response;
        if (cookie != null && (response = this.getResponse()) != null) {
            response.addCookie(cookie);
        }
        return this;
    }

    private HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        return RequestContext.getHttpServletResponse();
    }

    @Comment(value="\u8f93\u51fa\u56fe\u7247")
    public ResponseEntity image(@Comment(name="value", value="\u56fe\u7247\u5185\u5bb9\uff0c\u5982`byte[]`") Object value, @Comment(name="mime", value="\u56fe\u7247\u7c7b\u578b\uff0c\u5982`image/png`\u3001`image/jpeg`\u3001`image/gif`") String mime) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{mime})).body(value);
    }

    public static class NullValue {
        static final NullValue INSTANCE = new NullValue();
    }
}

