/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.script.functions.DynamicMethod;

public class RedisModule
implements MagicModule,
DynamicMethod {
    private final StringRedisTemplate redisTemplate;

    public RedisModule(RedisConnectionFactory connectionFactory) {
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
    }

    @Override
    public String getModuleName() {
        return "redis";
    }

    private byte[] serializer(Object value) {
        if (value == null || value instanceof String) {
            return this.redisTemplate.getStringSerializer().serialize((Object)((String)value));
        }
        return this.serializer(value.toString());
    }

    private Object deserialize(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                return this.redisTemplate.getStringSerializer().deserialize((byte[])value);
            }
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<Object> resultList = new ArrayList<Object>(valueList.size());
                for (Object val : valueList) {
                    resultList.add(this.deserialize(val));
                }
                return resultList;
            }
        }
        return value;
    }

    public Object execute(String methodName, List<Object> parameters) {
        return this.redisTemplate.execute(connection -> {
            byte[][] params = new byte[parameters.size()][];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.serializer(parameters.get(i));
            }
            return this.deserialize(connection.execute(methodName, (byte[][])params));
        });
    }
}

