/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.magicapi.model.Constants;
import org.ssssssss.script.convert.ClassImplicitConvert;
import org.ssssssss.script.reflection.JavaInvoker;
import org.ssssssss.script.reflection.JavaReflection;
import org.ssssssss.script.runtime.Variables;

public class MongoModule
extends HashMap<String, MongoDataBaseGetter>
implements MagicModule,
ClassImplicitConvert {
    private static final Logger logger = LoggerFactory.getLogger(MongoModule.class);
    private JavaInvoker<Method> invoker;
    private Object factory;

    public MongoModule(MongoTemplate mongoTemplate) {
        JavaInvoker mongoDbFactoryInvoker = JavaReflection.getMethod((Object)mongoTemplate, (String)"getMongoDbFactory", (Object[])new Object[0]);
        if (mongoDbFactoryInvoker == null) {
            mongoDbFactoryInvoker = JavaReflection.getMethod((Object)mongoTemplate, (String)"getMongoDatabaseFactory", (Object[])new Object[0]);
        }
        if (mongoDbFactoryInvoker != null) {
            try {
                this.factory = mongoDbFactoryInvoker.invoke0((Object)mongoTemplate, null, Constants.EMPTY_OBJECT_ARRAY);
                this.invoker = JavaReflection.getMethod((Object)this.factory, (String)"getDb", (Object[])new Object[]{""});
                if (this.invoker == null) {
                    this.invoker = JavaReflection.getMethod((Object)this.factory, (String)"getMongoDatabase", (Object[])new Object[]{""});
                }
            }
            catch (Throwable e) {
                logger.error("mongo\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25", e);
            }
        } else {
            logger.error("mongo\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25");
        }
        JavaReflection.registerImplicitConvert((ClassImplicitConvert)this);
    }

    @Override
    public MongoDataBaseGetter get(Object databaseName) {
        try {
            if (databaseName == null) {
                return null;
            }
            MongoDatabase database = (MongoDatabase)this.invoker.invoke0(this.factory, null, new Object[]{databaseName.toString()});
            return new MongoDataBaseGetter(database);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getModuleName() {
        return "mongo";
    }

    public boolean support(Class<?> from, Class<?> to) {
        return Map.class.isAssignableFrom(from) && Bson.class.isAssignableFrom(to);
    }

    public Object convert(Variables variables, Object source, Class<?> target) {
        return new Document((Map)source);
    }

    public static class MongoDataBaseGetter
    extends HashMap<String, MongoCollection<Document>> {
        MongoDatabase database;

        public MongoDataBaseGetter(MongoDatabase database) {
            this.database = database;
        }

        @Override
        public MongoCollection<Document> get(Object key) {
            return this.database.getCollection(key.toString());
        }
    }
}

