/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.ssssssss.script.annotation.Comment;

public class MongoCollectionExtension {
    @Comment(value="\u6267\u884c\u6279\u91cf\u63d2\u5165\u64cd\u4f5c")
    public void insert(MongoCollection<Document> collection, @Comment(name="maps", value="\u8981\u63d2\u5165\u7684\u96c6\u5408") List<Map<String, Object>> maps) {
        collection.insertMany(maps.stream().map(Document::new).collect(Collectors.toList()));
    }

    @Comment(value="\u6267\u884c\u5355\u6761\u63d2\u5165\u64cd\u4f5c")
    public void insert(MongoCollection<Document> collection, @Comment(name="map", value="\u6267\u884c\u63d2\u5165\u6570\u636e") Map<String, Object> map) {
        this.insert(collection, Collections.singletonList(map));
    }

    @Comment(value="\u6267\u884c\u67e5\u8be2\u64cd\u4f5c")
    public FindIterable<Document> find(MongoCollection<Document> collection, @Comment(name="query", value="\u67e5\u8be2\u6761\u4ef6") Map<String, Object> query) {
        return collection.find((Bson)new Document(query));
    }

    @Comment(value="\u4fee\u6539\u64cd\u4f5c\uff0c\u8fd4\u56de\u4fee\u6539\u6570\u91cf")
    public long update(MongoCollection<Document> collection, @Comment(name="query", value="\u67e5\u8be2\u6761\u4ef6") Map<String, Object> query, @Comment(name="update", value="\u4fee\u6539\u503c") Map<String, Object> update) {
        return collection.updateOne((Bson)new Document(query), (Bson)new Document(update)).getModifiedCount();
    }

    @Comment(value="\u6279\u91cf\u4fee\u6539\uff0c\u8fd4\u56de\u4fee\u6539\u6570\u91cf")
    public long updateMany(MongoCollection<Document> collection, @Comment(name="query", value="\u4fee\u6539\u6761\u4ef6") Map<String, Object> query, @Comment(name="update", value="\u4fee\u6539\u503c") Map<String, Object> update) {
        return collection.updateMany((Bson)new Document(query), (Bson)new Document(update)).getModifiedCount();
    }

    @Comment(value="\u6279\u91cf\u4fee\u6539\uff0c\u8fd4\u56de\u4fee\u6539\u6570\u91cf")
    public long updateMany(MongoCollection<Document> collection, @Comment(name="query", value="\u67e5\u8be2\u6761\u4ef6") Map<String, Object> query, @Comment(name="update", value="\u4fee\u6539\u503c") Map<String, Object> update, @Comment(name="filters", value="\u8fc7\u6ee4\u6761\u4ef6") Map<String, Object> filters) {
        UpdateOptions updateOptions = new UpdateOptions();
        if (filters != null && !filters.isEmpty()) {
            Object bypassDocumentValidation;
            Object upsert = filters.get("upsert");
            if (upsert != null) {
                filters.remove("upsert");
                updateOptions.upsert(Boolean.parseBoolean(upsert.toString()));
            }
            if ((bypassDocumentValidation = filters.get("bypassDocumentValidation")) != null) {
                filters.remove("bypassDocumentValidation");
                updateOptions.bypassDocumentValidation(Boolean.valueOf(Boolean.parseBoolean(bypassDocumentValidation.toString())));
            }
            List arrayFilters = filters.entrySet().stream().map(entry -> new Document((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
            updateOptions.arrayFilters(arrayFilters);
        }
        return collection.updateMany((Bson)new Document(query), (Bson)new Document(update), updateOptions).getModifiedCount();
    }

    @Comment(value="\u67e5\u8be2\u6570\u91cf")
    public long count(MongoCollection<Document> collection, @Comment(name="query", value="\u67e5\u8be2") Map<String, Object> query) {
        return collection.countDocuments((Bson)new Document(query));
    }

    @Comment(value="\u6279\u91cf\u5220\u9664\uff0c\u8fd4\u56de\u5220\u9664\u6761\u6570")
    public long remove(MongoCollection<Document> collection, @Comment(name="query", value="\u5220\u9664\u6761\u4ef6") Map<String, Object> query) {
        return collection.deleteMany((Bson)new Document(query)).getDeletedCount();
    }

    @Comment(value="\u5220\u9664\u4e00\u6761\uff0c\u8fd4\u56de\u5220\u9664\u6761\u6570")
    public long removeOne(MongoCollection<Document> collection, @Comment(name="query", value="\u5220\u9664\u6761\u4ef6") Map<String, Object> query) {
        return collection.deleteOne((Bson)new Document(query)).getDeletedCount();
    }
}

