/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.ssssssss.magicapi.context.RequestContext;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.modules.mybatis.MybatisParser;
import org.ssssssss.magicapi.modules.mybatis.SqlNode;
import org.ssssssss.magicapi.modules.mybatis.TextSqlNode;
import org.ssssssss.script.runtime.RuntimeContext;

public class BoundSql {
    private static final Pattern REPLACE_MULTI_WHITE_LINE = Pattern.compile("(\r?\n(\\s*\r?\n)+)");
    private static final List<String> MYBATIS_TAGS = Arrays.asList("</where>", "</if>", "</trim>", "</set>", "</foreach>");
    private String sqlOrXml;
    private List<Object> parameters = new ArrayList<Object>();
    private Set<String> excludeColumns;
    private SQLModule sqlModule;
    private Map<String, Object> bindParameters;
    private RuntimeContext runtimeContext;

    public BoundSql(RuntimeContext runtimeContext, String sqlOrXml, List<Object> parameters, SQLModule sqlModule) {
        this.sqlOrXml = sqlOrXml;
        this.parameters = parameters;
        this.sqlModule = sqlModule;
        this.runtimeContext = runtimeContext;
    }

    public BoundSql(RuntimeContext runtimeContext, String sqlOrXml, Map<String, Object> parameters, SQLModule sqlModule) {
        this.sqlOrXml = sqlOrXml;
        this.bindParameters = parameters;
        this.sqlModule = sqlModule;
        this.runtimeContext = runtimeContext;
        this.init();
    }

    private BoundSql(RuntimeContext runtimeContext, String sqlOrXml) {
        this.sqlOrXml = sqlOrXml;
        this.runtimeContext = runtimeContext;
        this.init();
    }

    BoundSql(RuntimeContext runtimeContext, String sql, SQLModule sqlModule) {
        this(runtimeContext, sql);
        this.sqlModule = sqlModule;
    }

    private BoundSql() {
    }

    private void init() {
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        if (this.bindParameters != null) {
            varMap.putAll(this.bindParameters);
        } else {
            varMap.putAll(this.runtimeContext.getVarMap());
        }
        if (MYBATIS_TAGS.stream().anyMatch(it -> this.sqlOrXml.contains((CharSequence)it))) {
            SqlNode sqlNode = MybatisParser.parse(this.sqlOrXml);
            this.sqlOrXml = sqlNode.getSql(varMap);
            this.parameters = sqlNode.getParameters();
        } else {
            this.normal(varMap);
        }
    }

    private void normal(Map<String, Object> varMap) {
        this.sqlOrXml = TextSqlNode.parseSql(this.sqlOrXml, varMap, this.parameters);
        this.sqlOrXml = this.sqlOrXml == null ? null : REPLACE_MULTI_WHITE_LINE.matcher(this.sqlOrXml.trim()).replaceAll("\r\n");
    }

    public SQLModule getSqlModule() {
        return this.sqlModule;
    }

    BoundSql copy(String newSqlOrXml) {
        BoundSql boundSql = new BoundSql();
        boundSql.parameters = this.parameters;
        boundSql.bindParameters = this.bindParameters;
        boundSql.sqlOrXml = newSqlOrXml;
        boundSql.excludeColumns = this.excludeColumns;
        boundSql.sqlModule = this.sqlModule;
        boundSql.runtimeContext = this.runtimeContext;
        return boundSql;
    }

    public Set<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Set<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public void addParameter(Object value) {
        this.parameters.add(value);
    }

    public String getSql() {
        return this.sqlOrXml;
    }

    public void setSql(String sql) {
        this.sqlOrXml = sql;
    }

    public Object[] getParameters() {
        return this.parameters.toArray();
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    private <T> T getCacheValue(String sql, Object[] params, Supplier<T> supplier) {
        if (this.sqlModule.getCacheName() == null) {
            return supplier.get();
        }
        String cacheKey = this.sqlModule.getSqlCache().buildSqlCacheKey(sql, params);
        Object cacheValue = this.sqlModule.getSqlCache().get(this.sqlModule.getCacheName(), cacheKey);
        if (cacheValue != null) {
            return cacheValue;
        }
        T value = supplier.get();
        this.sqlModule.getSqlCache().put(this.sqlModule.getCacheName(), cacheKey, value, this.sqlModule.getTtl());
        return value;
    }

    <T> T execute(List<SQLInterceptor> interceptors, Supplier<T> supplier) {
        RequestEntity requestEntity = RequestContext.getRequestEntity();
        interceptors.forEach(interceptor -> interceptor.preHandle(this, requestEntity));
        Supplier<Object> newSupplier = () -> {
            Object result = supplier.get();
            for (SQLInterceptor interceptor : interceptors) {
                result = interceptor.postHandle(this, result, requestEntity);
            }
            return result;
        };
        return (T)this.getCacheValue(this.getSql(), this.getParameters(), newSupplier);
    }
}

