/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.functions.ObjectConvertExtension;

public class RequestEntity {
    private final Long requestTime = System.currentTimeMillis();
    private final String requestId = UUID.randomUUID().toString().replace("-", "");
    private ApiInfo apiInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private boolean requestedFromTest;
    private Map<String, Object> parameters;
    private Map<String, Object> pathVariables;
    private MagicScriptContext magicScriptContext;
    private Object requestBody;
    private Map<String, Object> headers;

    private RequestEntity() {
    }

    public RequestEntity(HttpServletRequest request, HttpServletResponse response, boolean requestedFromTest, Map<String, Object> parameters, Map<String, Object> pathVariables) {
        this.request = request;
        this.response = response;
        this.requestedFromTest = requestedFromTest;
        this.parameters = parameters;
        this.pathVariables = pathVariables;
        ApiInfo info = MappingHandlerMapping.getMappingApiInfo(request);
        this.apiInfo = info != null ? info.copy() : null;
    }

    public RequestEntity(ApiInfo apiInfo, HttpServletRequest request, HttpServletResponse response, boolean requestedFromTest, Map<String, Object> parameters, Map<String, Object> pathVariables) {
        this.apiInfo = apiInfo;
        this.request = request;
        this.response = response;
        this.requestedFromTest = requestedFromTest;
        this.parameters = parameters;
        this.pathVariables = pathVariables;
    }

    public RequestEntity(HttpServletRequest request, HttpServletResponse response, boolean requestedFromTest, Map<String, Object> parameters, Map<String, Object> pathVariables, MagicScriptContext magicScriptContext, Map<String, Object> headers) {
        ApiInfo info = MappingHandlerMapping.getMappingApiInfo(request);
        this.apiInfo = info != null ? info.copy() : null;
        this.request = request;
        this.response = response;
        this.requestedFromTest = requestedFromTest;
        this.parameters = parameters;
        this.pathVariables = pathVariables;
        this.magicScriptContext = magicScriptContext;
        this.headers = headers;
    }

    public static RequestEntity empty() {
        return new RequestEntity();
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public void setApiInfo(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public boolean isRequestedFromTest() {
        return this.requestedFromTest;
    }

    public void setRequestedFromTest(boolean requestedFromTest) {
        this.requestedFromTest = requestedFromTest;
    }

    public boolean isRequestedFromDebug() {
        return this.requestedFromTest && !this.getRequestedBreakpoints().isEmpty();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, Object> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public Long getRequestTime() {
        return this.requestTime;
    }

    public MagicScriptContext getMagicScriptContext() {
        return this.magicScriptContext;
    }

    public void setMagicScriptContext(MagicScriptContext magicScriptContext) {
        this.magicScriptContext = magicScriptContext;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestedSessionId() {
        return this.request.getHeader("Magic-Request-Session");
    }

    public List<Integer> getRequestedBreakpoints() {
        String breakpoints = this.request.getHeader("Magic-Request-Breakpoints");
        if (breakpoints != null) {
            return Arrays.stream(breakpoints.split(",")).map(val -> ObjectConvertExtension.asInt((Object)val, (int)-1)).filter(it -> it > 0).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

