/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.WebSocketSession;
import org.ssssssss.script.MagicScriptDebugContext;

public class MagicConsoleSession {
    private static final Map<String, MagicConsoleSession> CACHED = new ConcurrentHashMap<String, MagicConsoleSession>();
    private final String id = UUID.randomUUID().toString();
    private WebSocketSession webSocketSession;
    private MagicScriptDebugContext magicScriptDebugContext;
    private String sessionId;

    public MagicConsoleSession(WebSocketSession webSocketSession) {
        this.webSocketSession = webSocketSession;
    }

    public MagicConsoleSession(String sessionId, MagicScriptDebugContext magicScriptDebugContext) {
        this.sessionId = sessionId;
        this.magicScriptDebugContext = magicScriptDebugContext;
    }

    public static MagicConsoleSession from(WebSocketSession session) {
        MagicConsoleSession magicConsoleSession = CACHED.get(session.getId());
        if (magicConsoleSession == null) {
            magicConsoleSession = new MagicConsoleSession(session);
            CACHED.put(session.getId(), magicConsoleSession);
        }
        return magicConsoleSession;
    }

    public static void remove(WebSocketSession session) {
        CACHED.remove(session.getId());
    }

    public String getId() {
        return this.id;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public void setWebSocketSession(WebSocketSession webSocketSession) {
        this.webSocketSession = webSocketSession;
    }

    public MagicScriptDebugContext getMagicScriptDebugContext() {
        return this.magicScriptDebugContext;
    }

    public void setMagicScriptDebugContext(MagicScriptDebugContext magicScriptDebugContext) {
        this.magicScriptDebugContext = magicScriptDebugContext;
    }

    public boolean writeable() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

