/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.Parameter;
import org.ssssssss.magicapi.utils.JsonUtils;

public class FunctionInfo
extends MagicEntity {
    private String path;
    private String description;
    private String returnType;
    private String mappingPath;
    private List<Parameter> parameters = Collections.emptyList();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameter(String parameter) {
        try {
            this.parameters = JsonUtils.readValue(Objects.toString(parameter, "[]"), new TypeReference<List<Parameter>>(){});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(String mappingPath) {
        this.mappingPath = mappingPath;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionInfo functionInfo = (FunctionInfo)o;
        return Objects.equals(this.id, functionInfo.id) && Objects.equals(this.path, functionInfo.path) && Objects.equals(this.script, functionInfo.script) && Objects.equals(this.name, functionInfo.name) && Objects.equals(this.groupId, functionInfo.groupId) && Objects.equals(this.description, functionInfo.description) && Objects.equals(this.parameters, functionInfo.parameters) && Objects.equals(this.returnType, functionInfo.returnType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.script, this.name, this.groupId, this.parameters, this.description, this.returnType);
    }

    public FunctionInfo copy() {
        FunctionInfo info = new FunctionInfo();
        info.setId(this.id);
        info.setName(this.name);
        info.setGroupId(this.groupId);
        info.setScript(this.script);
        info.setDescription(this.description);
        info.setParameters(this.parameters);
        info.setPath(this.path);
        info.setMappingPath(this.mappingPath);
        info.setReturnType(this.returnType);
        info.setProperties(this.properties);
        info.setLock(this.lock);
        return info;
    }
}

