/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.model.BaseDefinition;
import org.ssssssss.magicapi.model.Header;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.model.Parameter;
import org.ssssssss.magicapi.model.Path;
import org.ssssssss.magicapi.utils.JsonUtils;

public class ApiInfo
extends MagicEntity {
    private String method = "GET";
    private String path;
    private List<Parameter> parameters = Collections.emptyList();
    private String option;
    private String requestBody;
    private List<Header> headers = Collections.emptyList();
    private List<Path> paths = Collections.emptyList();
    private String responseBody;
    private String description;
    private transient JsonNode jsonNode;
    private BaseDefinition requestBodyDefinition;
    private BaseDefinition responseBodyDefinition;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParameter(String parameter) {
        if (parameter != null) {
            if ((parameter = parameter.trim()).startsWith("[")) {
                this.parameters = JsonUtils.readValue(Objects.toString(parameter, "[]"), new TypeReference<List<Parameter>>(){});
            } else {
                Object header;
                Map<String, Object> map = JsonUtils.readValue(Objects.toString(parameter, "{}"), new TypeReference<Map<String, Object>>(){});
                Object request = map.get("request");
                if (request instanceof Map) {
                    Map requestMap = (Map)request;
                    this.parameters = requestMap.keySet().stream().map(key -> new Parameter((String)key, Objects.toString(requestMap.get(key), ""))).collect(Collectors.toList());
                }
                if ((header = map.get("header")) instanceof Map) {
                    Map headers = (Map)header;
                    this.headers = headers.keySet().stream().map(key -> new Header((String)key, Objects.toString(headers.get(key), ""))).collect(Collectors.toList());
                }
                if (map.containsKey("body")) {
                    this.requestBody = Objects.toString(map.get("body"), null);
                }
            }
        }
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public Map<String, String> getOptionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.jsonNode == null) {
            return Collections.emptyMap();
        }
        if (this.jsonNode.isArray()) {
            for (JsonNode node : this.jsonNode) {
                map.put(node.get("name").asText(), node.get("value").asText());
            }
        } else {
            this.jsonNode.fieldNames().forEachRemaining(it -> map.put((String)it, this.jsonNode.get(it).asText()));
        }
        MappingHandlerMapping.findGroups(this.groupId).stream().flatMap(it -> it.getOptions().stream()).forEach(option -> {
            if (!map.containsKey(option.getName())) {
                map.put(option.getName(), String.valueOf(option.getValue()));
            }
        });
        return map;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
        try {
            this.jsonNode = new ObjectMapper().readTree(option);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setRequestHeader(String requestHeader) {
        this.headers = JsonUtils.readValue(Objects.toString(requestHeader, "[]"), new TypeReference<List<Header>>(){});
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setOptionValue(String optionValue) {
        this.setOption(optionValue);
    }

    public String getOptionValue(Options options) {
        return this.getOptionValue(options.getValue());
    }

    public String getOptionValue(String key) {
        JsonNode node;
        if (this.jsonNode == null) {
            return null;
        }
        if (this.jsonNode.isArray()) {
            for (JsonNode node2 : this.jsonNode) {
                if (!node2.isObject() || !Objects.equals(key, node2.get("name").asText())) continue;
                return node2.get("value").asText();
            }
        } else if (this.jsonNode.isObject() && (node = this.jsonNode.get(key)) != null) {
            return node.asText();
        }
        return MappingHandlerMapping.findGroups(this.groupId).stream().flatMap(it -> it.getOptions().stream()).filter(it -> key.equals(it.getName())).findFirst().map(it -> Objects.toString(it.getValue(), null)).orElse(null);
    }

    public BaseDefinition getRequestBodyDefinition() {
        return this.requestBodyDefinition;
    }

    public void setRequestBodyDefinition(BaseDefinition requestBodyDefinition) {
        this.requestBodyDefinition = requestBodyDefinition;
    }

    public BaseDefinition getResponseBodyDefinition() {
        return this.responseBodyDefinition;
    }

    public void setResponseBodyDefinition(BaseDefinition responseBodyDefinition) {
        this.responseBodyDefinition = responseBodyDefinition;
    }

    public ApiInfo simple() {
        ApiInfo target = new ApiInfo();
        target.setId(this.getId());
        target.setName(this.getName());
        target.setGroupId(this.getGroupId());
        target.setPath(this.getPath());
        target.setMethod(this.getMethod());
        target.setLock(this.getLock());
        return target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiInfo apiInfo = (ApiInfo)o;
        return Objects.equals(this.id, apiInfo.id) && Objects.equals(this.method, apiInfo.method) && Objects.equals(this.path, apiInfo.path) && Objects.equals(this.script, apiInfo.script) && Objects.equals(this.name, apiInfo.name) && Objects.equals(this.paths, apiInfo.paths) && Objects.equals(this.groupId, apiInfo.groupId) && Objects.equals(this.parameters, apiInfo.parameters) && Objects.equals(this.option, apiInfo.option) && Objects.equals(this.requestBody, apiInfo.requestBody) && Objects.equals(this.headers, apiInfo.headers) && Objects.equals(this.description, apiInfo.description) && Objects.equals(this.requestBodyDefinition, apiInfo.requestBodyDefinition) && Objects.equals(this.responseBodyDefinition, apiInfo.responseBodyDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.method, this.path, this.script, this.name, this.groupId, this.parameters, this.option, this.requestBody, this.headers, this.responseBody, this.description, this.requestBodyDefinition, this.responseBodyDefinition);
    }

    public ApiInfo copy() {
        ApiInfo info = new ApiInfo();
        info.setId(this.id);
        info.setMethod(this.method);
        info.setName(this.name);
        info.setPath(this.path);
        info.setScript(this.script);
        info.setGroupId(this.groupId);
        info.setParameters(this.parameters);
        info.jsonNode = this.jsonNode;
        info.setRequestBody(this.requestBody);
        info.setHeaders(this.headers);
        info.setResponseBody(this.responseBody);
        info.setDescription(this.description);
        info.setPaths(this.paths);
        info.setRequestBodyDefinition(this.requestBodyDefinition);
        info.setResponseBodyDefinition(this.responseBodyDefinition);
        info.setLock(this.lock);
        info.setProperties(this.properties);
        return info;
    }
}

