/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.logging.Formatter;
import org.ssssssss.magicapi.logging.MagicLoggerContext;

public class LogbackLoggerContext
implements MagicLoggerContext {
    @Override
    public void generateAppender() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("ROOT");
        MagicLogbackAppender appender = new MagicLogbackAppender();
        appender.setContext((Context)context);
        appender.setName("magic");
        appender.start();
        logger.addAppender((Appender)appender);
    }

    static class MagicLogbackAppender
    extends UnsynchronizedAppenderBase<ILoggingEvent> {
        MagicLogbackAppender() {
        }

        protected void append(ILoggingEvent event) {
            Formatter formatter = Formatter.create().timestamp(event.getTimeStamp()).space().level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").loggerName(event.getLoggerName()).value(": ").value(event.getFormattedMessage()).newline();
            IThrowableProxy proxy = event.getThrowableProxy();
            if (proxy instanceof ThrowableProxy) {
                formatter.throwable(((ThrowableProxy)proxy).getThrowable());
            }
            MagicLoggerContext.println(formatter.toString());
        }
    }
}

