/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.interceptor;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.modules.BoundSql;

public class DefaultSqlInterceptor
implements SQLInterceptor {
    @Override
    public void preHandle(BoundSql boundSql, RequestEntity requestEntity) {
        Logger logger = LoggerFactory.getLogger((String)(requestEntity == null ? "Unknown" : requestEntity.getMagicScriptContext().getScriptName()));
        String parameters = Arrays.stream(boundSql.getParameters()).map(it -> {
            if (it == null) {
                return "null";
            }
            return it + "(" + it.getClass().getSimpleName() + ")";
        }).collect(Collectors.joining(", "));
        String dataSourceName = boundSql.getSqlModule().getDataSourceName();
        logger.info("\u6267\u884cSQL\uff1a{}", (Object)boundSql.getSql().trim());
        if (dataSourceName != null) {
            logger.info("\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceName);
        }
        if (parameters.length() > 0) {
            logger.info("SQL\u53c2\u6570\uff1a{}", (Object)parameters);
        }
    }
}

