/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.exception.MagicLoginException;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.MagicNotify;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.model.SelectedResource;
import org.ssssssss.magicapi.modules.ResponseModule;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.SignUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.ScriptClass;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Tokenizer;

public class MagicWorkbenchController
extends MagicController
implements MagicExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(MagicWorkbenchController.class);
    private static final Pattern SINGLE_LINE_COMMENT_TODO = Pattern.compile("((TODO)|(todo)|(fixme)|(FIXME))[ \t]+[^\n]+");
    private static final Pattern MULTI_LINE_COMMENT_TODO = Pattern.compile("((TODO)|(todo)|(fixme)|(FIXME))[ \t]+[^\n(?!*/)]+");
    private final String secretKey;

    public MagicWorkbenchController(MagicConfiguration configuration, String secretKey) {
        super(configuration);
        this.secretKey = secretKey;
        MagicScriptEngine.addScriptClass(SQLModule.class);
        MagicScriptEngine.addScriptClass(MagicAPIService.class);
    }

    @RequestMapping(value={"/classes"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Map<String, Object>> classes() {
        Map classMap = MagicScriptEngine.getScriptClassMap();
        classMap.putAll(MagicResourceLoader.getModules());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("classes", classMap);
        values.put("extensions", MagicScriptEngine.getExtensionScriptClass());
        values.put("functions", MagicScriptEngine.getFunctions());
        return new JsonBean<Map<String, Object>>(values);
    }

    @RequestMapping(value={"/class"})
    @ResponseBody
    public JsonBean<Set<ScriptClass>> clazz(String className) {
        return new JsonBean<Set<ScriptClass>>(MagicScriptEngine.getScriptClass((String)className));
    }

    @RequestMapping(value={"/login"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Boolean> login(String username, String password, HttpServletRequest request, HttpServletResponse response) throws MagicLoginException {
        if (this.configuration.getAuthorizationInterceptor().requireLogin()) {
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                try {
                    this.configuration.getAuthorizationInterceptor().getUserByToken(request.getHeader("Magic-Token"));
                }
                catch (MagicLoginException ignored) {
                    return new JsonBean<Boolean>(false);
                }
            } else {
                MagicUser user = this.configuration.getAuthorizationInterceptor().login(username, password);
                response.setHeader("Magic-Token", user.getToken());
                response.setHeader("Access-Control-Expose-Headers", "Magic-Token");
            }
        }
        return new JsonBean<Boolean>(true);
    }

    @RequestMapping(value={"/user"})
    @ResponseBody
    public JsonBean<MagicUser> user(HttpServletRequest request) {
        if (this.configuration.getAuthorizationInterceptor().requireLogin()) {
            try {
                return new JsonBean<MagicUser>(this.configuration.getAuthorizationInterceptor().getUserByToken(request.getHeader("Magic-Token")));
            }
            catch (MagicLoginException magicLoginException) {
                // empty catch block
            }
        }
        return new JsonBean<MagicUser>(MagicUser.guest());
    }

    @RequestMapping(value={"/logout"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Void> logout(HttpServletRequest request) {
        this.configuration.getAuthorizationInterceptor().logout(request.getHeader("Magic-Token"));
        return new JsonBean<Void>();
    }

    @RequestMapping(value={"/refresh"})
    @ResponseBody
    @Valid
    public JsonBean<Void> refresh() {
        this.configuration.getMappingHandlerMapping().registerAllMapping();
        this.configuration.getMagicFunctionManager().registerAllFunction();
        this.magicAPIService.registerAllDataSource();
        this.configuration.getMagicNotifyService().sendNotify(new MagicNotify(this.configuration.getInstanceId()));
        return new JsonBean<Void>();
    }

    @RequestMapping(value={"/options"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<List<List<String>>> options() {
        return new JsonBean<List<List<String>>>(Stream.of(Options.values()).map(item -> Arrays.asList(item.getValue(), item.getName(), item.getDefaultValue())).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/search"})
    @ResponseBody
    @Valid
    public JsonBean<List<Map<String, Object>>> search(String keyword, String type) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return new JsonBean<List<Map<String, Object>>>(Collections.emptyList());
        }
        ArrayList<MagicEntity> entities = new ArrayList<MagicEntity>();
        if (!"2".equals(type)) {
            entities.addAll(this.configuration.getMappingHandlerMapping().getApiInfos());
        }
        if (!"1".equals(type)) {
            entities.addAll(this.configuration.getMagicFunctionManager().getFunctionInfos());
        }
        return new JsonBean<List<Map<String, Object>>>(entities.stream().filter(it -> it.getScript().contains(keyword)).map(it -> {
            String script = it.getScript();
            int index = script.indexOf(keyword);
            int endIndex = script.indexOf("\n", index + keyword.length());
            index = script.lastIndexOf("\n", index) + 1;
            final Span span = new Span(script, index, endIndex == -1 ? script.length() : endIndex);
            return new HashMap<String, Object>(){
                {
                    this.put("id", it.getId());
                    this.put("text", span.getText().trim());
                    this.put("line", span.getLine().getLineNumber());
                    this.put("type", it instanceof ApiInfo ? 1 : 2);
                }
            };
        }).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/todo"})
    @ResponseBody
    @Valid
    public JsonBean<List<Map<String, Object>>> todo(HttpServletRequest request) {
        List entities = this.configuration.getMappingHandlerMapping().getApiInfos().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (ApiInfo)it)).collect(Collectors.toList());
        entities.addAll(this.configuration.getMagicFunctionManager().getFunctionInfos().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (FunctionInfo)it)).collect(Collectors.toList()));
        ArrayList<2> result = new ArrayList<2>();
        for (final MagicEntity entity : entities) {
            try {
                List comments = Tokenizer.tokenize((String)entity.getScript(), (boolean)true).comments();
                for (final Span comment : comments) {
                    String text = comment.getText();
                    Pattern pattern = text.startsWith("//") ? SINGLE_LINE_COMMENT_TODO : MULTI_LINE_COMMENT_TODO;
                    final Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        result.add(new HashMap<String, Object>(){
                            {
                                this.put("id", entity.getId());
                                this.put("text", matcher.group(0).trim());
                                this.put("line", comment.getLine().getLineNumber());
                                this.put("type", entity instanceof ApiInfo ? 1 : 2);
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return new JsonBean<List<Map<String, Object>>>(result);
    }

    @RequestMapping(value={"/config-js"})
    @ResponseBody
    @Valid(requireLogin=false)
    public ResponseEntity<?> configJs() {
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/javascript"));
        if (this.configuration.getEditorConfig() != null) {
            try {
                String path = this.configuration.getEditorConfig();
                if (path.startsWith("classpath:")) {
                    path = path.substring("classpath:".length());
                    return responseBuilder.body((Object)IoUtils.bytes(new ClassPathResource(path).getInputStream()));
                }
                File file = ResourceUtils.getFile((String)this.configuration.getEditorConfig());
                return responseBuilder.body((Object)Files.readAllBytes(Paths.get(file.toURI())));
            }
            catch (IOException e) {
                logger.warn("\u8bfb\u53d6\u7f16\u8f91\u5668\u914d\u7f6e\u6587\u4ef6{}\u5931\u8d25", (Object)this.configuration.getEditorConfig());
            }
        }
        return responseBuilder.body((Object)"var MAGIC_EDITOR_CONFIG = {}".getBytes());
    }

    @RequestMapping(value={"/download"})
    @Valid(authorization=Authorization.DOWNLOAD)
    @ResponseBody
    public ResponseEntity<?> download(String groupId, @RequestBody(required=false) List<SelectedResource> resources) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.magicAPIService.download(groupId, resources, os);
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return ResponseModule.download(os.toByteArray(), "magic-api-group.zip");
        }
        return ResponseModule.download(os.toByteArray(), "magic-api-all.zip");
    }

    @RequestMapping(value={"/upload"})
    @Valid(readonly=false, authorization=Authorization.UPLOAD)
    @ResponseBody
    public JsonBean<Boolean> upload(MultipartFile file, String mode) throws IOException {
        this.notNull(file, FILE_IS_REQUIRED);
        this.magicAPIService.upload(file.getInputStream(), mode);
        return new JsonBean<Boolean>(SUCCESS, true);
    }

    @RequestMapping(value={"/push"})
    @ResponseBody
    @Valid(authorization=Authorization.PUSH)
    public JsonBean<?> push(@RequestHeader(value="magic-push-target") String target, @RequestHeader(value="magic-push-secret-key") String secretKey, @RequestHeader(value="magic-push-mode") String mode, @RequestBody List<SelectedResource> resources) {
        return this.magicAPIService.push(target, secretKey, mode, resources);
    }

    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Void> receivePush(MultipartFile file, String mode, Long timestamp, String sign) throws IOException {
        this.notNull(timestamp, SIGN_IS_INVALID);
        this.notBlank(mode, SIGN_IS_INVALID);
        this.notBlank(sign, SIGN_IS_INVALID);
        this.notNull(file, SIGN_IS_INVALID);
        byte[] bytes = IoUtils.bytes(file.getInputStream());
        this.isTrue(sign.equals(SignUtils.sign(timestamp, this.secretKey, mode, bytes)), SIGN_IS_INVALID);
        this.magicAPIService.upload(new ByteArrayInputStream(bytes), mode);
        return new JsonBean<Void>();
    }
}

