/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.FileResource;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;

public class MagicGroupController
extends MagicController
implements MagicExceptionHandler {
    public MagicGroupController(MagicConfiguration configuration) {
        super(configuration);
    }

    @RequestMapping(value={"/group/delete"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> deleteGroup(HttpServletRequest request, String groupId) {
        Group group = this.magicAPIService.getGroup(groupId);
        this.notNull(group, GROUP_NOT_FOUND);
        this.isTrue(this.allowVisit(request, Authorization.DELETE, group), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.deleteGroup(groupId));
    }

    @RequestMapping(value={"/group/update"})
    @ResponseBody
    @Valid(readonly=false)
    public synchronized JsonBean<Boolean> groupUpdate(HttpServletRequest request, @RequestBody Group group) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, group), PERMISSION_INVALID);
        if (this.magicAPIService.updateGroup(group)) {
            return new JsonBean<Boolean>(true);
        }
        return new JsonBean<Boolean>(GROUP_CONFLICT);
    }

    @RequestMapping(value={"/group/list"})
    @ResponseBody
    public JsonBean<List<Group>> groupList(HttpServletRequest request, String type) {
        return new JsonBean<List<Group>>(this.magicAPIService.groupList(type).stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (Group)it)).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/group/create"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<String> createGroup(HttpServletRequest request, @RequestBody Group group) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, group), PERMISSION_INVALID);
        Resource resource = this.configuration.getWorkspace();
        if (resource instanceof FileResource) {
            this.isTrue(resource.exists(), FILE_PATH_NOT_EXISTS);
        }
        return new JsonBean<String>(this.magicAPIService.createGroup(group));
    }

    @RequestMapping(value={"/group/copy"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<String> copyGroup(HttpServletRequest request, String src, String target) {
        Group group = this.magicAPIService.getGroup(src);
        this.notNull(group, GROUP_NOT_FOUND);
        if (!"0".equals(target)) {
            Group targetGroup = this.magicAPIService.getGroup(target);
            this.notNull(targetGroup, GROUP_NOT_FOUND);
            this.isTrue(this.allowVisit(request, Authorization.SAVE, targetGroup), PERMISSION_INVALID);
        }
        this.isTrue(this.allowVisit(request, Authorization.VIEW, group), PERMISSION_INVALID);
        return new JsonBean<String>(this.magicAPIService.copyGroup(src, target));
    }
}

