/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.Backup;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.JsonBean;

public class MagicFunctionController
extends MagicController
implements MagicExceptionHandler {
    public MagicFunctionController(MagicConfiguration configuration) {
        super(configuration);
    }

    @RequestMapping(value={"/function/list"})
    @ResponseBody
    public JsonBean<List<FunctionInfo>> list(HttpServletRequest request) {
        return new JsonBean<List<FunctionInfo>>(this.magicAPIService.functionList().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (FunctionInfo)it)).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/function/get"})
    @ResponseBody
    public JsonBean<FunctionInfo> get(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getFunctionInfo(id)), PERMISSION_INVALID);
        return new JsonBean<FunctionInfo>(this.magicAPIService.getFunctionInfo(id));
    }

    @RequestMapping(value={"/function/backup/get"})
    @ResponseBody
    public JsonBean<Backup> backups(HttpServletRequest request, String id, Long timestamp) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getFunctionInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Backup>(this.magicBackupService.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/function/backups"})
    @ResponseBody
    public JsonBean<List<Backup>> backupList(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getFunctionInfo(id)), PERMISSION_INVALID);
        return new JsonBean<List<Backup>>(this.magicBackupService.backupById(id).stream().sorted(Comparator.comparing(Backup::getCreateDate).reversed()).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/function/move"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> move(HttpServletRequest request, String id, String groupId) {
        FunctionInfo functionInfo = this.getFunctionInfo(id);
        functionInfo.setGroupId(groupId);
        this.isTrue(this.allowVisit(request, Authorization.SAVE, functionInfo), PERMISSION_INVALID);
        this.isTrue(!"1".equals(functionInfo.getLock()), RESOURCE_LOCKED);
        return new JsonBean<Boolean>(this.magicAPIService.moveFunction(id, groupId));
    }

    @RequestMapping(value={"/function/save"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<String> save(HttpServletRequest request, @RequestBody FunctionInfo functionInfo) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, functionInfo), PERMISSION_INVALID);
        if (StringUtils.isNotBlank((CharSequence)functionInfo.getId())) {
            FunctionInfo oldInfo = this.getFunctionInfo(functionInfo.getId());
            this.isTrue(!"1".equals(oldInfo.getLock()), RESOURCE_LOCKED);
        }
        return new JsonBean<String>(this.magicAPIService.saveFunction(functionInfo));
    }

    @RequestMapping(value={"/function/delete"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> delete(HttpServletRequest request, String id) {
        FunctionInfo info = this.getFunctionInfo(id);
        this.isTrue(this.allowVisit(request, Authorization.DELETE, info), PERMISSION_INVALID);
        this.isTrue(!"1".equals(info.getLock()), RESOURCE_LOCKED);
        return new JsonBean<Boolean>(this.magicAPIService.deleteFunction(id));
    }

    @RequestMapping(value={"/function/lock"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> lock(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.LOCK, this.getFunctionInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.lockFunction(id));
    }

    @RequestMapping(value={"/function/unlock"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> unlock(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.UNLOCK, this.getFunctionInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.unlockFunction(id));
    }

    public FunctionInfo getFunctionInfo(String id) {
        FunctionInfo functionInfo = this.magicAPIService.getFunctionInfo(id);
        this.notNull(functionInfo, FUNCTION_NOT_FOUND);
        return functionInfo;
    }
}

