/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.DataSourceInfo;
import org.ssssssss.magicapi.model.JsonBean;

public class MagicDataSourceController
extends MagicController
implements MagicExceptionHandler {
    public MagicDataSourceController(MagicConfiguration configuration) {
        super(configuration);
    }

    @RequestMapping(value={"/datasource/list"})
    @ResponseBody
    public JsonBean<List<DataSourceInfo>> list(HttpServletRequest request) {
        return new JsonBean<List<DataSourceInfo>>(this.magicAPIService.datasourceList().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (DataSourceInfo)it)).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/datasource/test"})
    @ResponseBody
    public JsonBean<String> test(@RequestBody DataSourceInfo properties) {
        return new JsonBean<String>(this.magicAPIService.testDataSource(properties));
    }

    @RequestMapping(value={"/datasource/save"})
    @Valid(readonly=false)
    @ResponseBody
    public JsonBean<String> save(HttpServletRequest request, @RequestBody DataSourceInfo properties) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, properties), PERMISSION_INVALID);
        return new JsonBean<String>(this.magicAPIService.saveDataSource(properties));
    }

    @RequestMapping(value={"/datasource/delete"})
    @Valid(readonly=false)
    @ResponseBody
    public JsonBean<Boolean> delete(HttpServletRequest request, String id) {
        DataSourceInfo dataSource = this.getDataSourceInfo(id);
        this.isTrue(this.allowVisit(request, Authorization.DELETE, dataSource), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.deleteDataSource(id));
    }

    @RequestMapping(value={"/datasource/detail"})
    @ResponseBody
    public JsonBean<DataSourceInfo> detail(HttpServletRequest request, String id) {
        DataSourceInfo dataSource = this.getDataSourceInfo(id);
        this.isTrue(this.allowVisit(request, Authorization.VIEW, dataSource), PERMISSION_INVALID);
        return new JsonBean<DataSourceInfo>(dataSource);
    }

    private DataSourceInfo getDataSourceInfo(String id) {
        DataSourceInfo dataSource = this.magicAPIService.getDataSource(id);
        this.notNull(dataSource, DATASOURCE_NOT_FOUND);
        return dataSource;
    }
}

