/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.exception.InvalidArgumentException;
import org.ssssssss.magicapi.exception.MagicLoginException;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.DataSourceInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.JsonCodeConstants;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.MagicBackupService;

public class MagicController
implements JsonCodeConstants {
    final MagicAPIService magicAPIService;
    final MagicBackupService magicBackupService;
    MagicConfiguration configuration;

    MagicController(MagicConfiguration configuration) {
        this.configuration = configuration;
        this.magicAPIService = configuration.getMagicAPIService();
        this.magicBackupService = configuration.getMagicBackupService();
    }

    public void doValid(HttpServletRequest request, Valid valid) {
        if (valid != null) {
            if (!valid.readonly() && this.configuration.getWorkspace().readonly()) {
                throw new InvalidArgumentException(IS_READ_ONLY);
            }
            if (valid.authorization() != Authorization.NONE && !this.allowVisit(request, valid.authorization())) {
                throw new InvalidArgumentException(PERMISSION_INVALID);
            }
        }
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, ApiInfo apiInfo) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, apiInfo);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, FunctionInfo functionInfo) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, functionInfo);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, Group group) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, group);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, DataSourceInfo dataSourceInfo) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, dataSourceInfo);
    }

    @ExceptionHandler(value={MagicLoginException.class})
    @ResponseBody
    public JsonBean<Void> invalidLogin(MagicLoginException exception) {
        return new JsonBean<Void>(401, exception.getMessage());
    }
}

