/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.Backup;
import org.ssssssss.magicapi.model.JsonBean;

public class MagicAPIController
extends MagicController
implements MagicExceptionHandler {
    public MagicAPIController(MagicConfiguration configuration) {
        super(configuration);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> delete(HttpServletRequest request, String id) {
        ApiInfo apiInfo = this.getApiInfo(id);
        this.isTrue(this.allowVisit(request, Authorization.DELETE, apiInfo), PERMISSION_INVALID);
        this.isTrue(!"1".equals(apiInfo.getLock()), RESOURCE_LOCKED);
        return new JsonBean<Boolean>(this.magicAPIService.deleteApi(id));
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public JsonBean<List<ApiInfo>> list(HttpServletRequest request) {
        return new JsonBean<List<ApiInfo>>(this.magicAPIService.apiList().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (ApiInfo)it)).map(ApiInfo::simple).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public JsonBean<ApiInfo> get(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getApiInfo(id)), PERMISSION_INVALID);
        return new JsonBean<ApiInfo>(this.magicAPIService.getApiInfo(id));
    }

    @RequestMapping(value={"/backups"})
    @ResponseBody
    public JsonBean<List<Backup>> backupList(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getApiInfo(id)), PERMISSION_INVALID);
        return new JsonBean<List<Backup>>(this.magicBackupService.backupById(id));
    }

    @RequestMapping(value={"/backup/get"})
    @ResponseBody
    public JsonBean<Backup> backups(HttpServletRequest request, String id, Long timestamp) {
        this.isTrue(this.allowVisit(request, Authorization.VIEW, this.getApiInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Backup>(this.magicBackupService.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/api/move"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> apiMove(HttpServletRequest request, String id, String groupId) {
        ApiInfo apiInfo = this.getApiInfo(id).copy();
        apiInfo.setGroupId(groupId);
        this.isTrue(this.allowVisit(request, Authorization.SAVE, apiInfo), PERMISSION_INVALID);
        this.isTrue(!"1".equals(apiInfo.getLock()), RESOURCE_LOCKED);
        return new JsonBean<Boolean>(this.magicAPIService.moveApi(id, groupId));
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<String> save(HttpServletRequest request, @RequestBody ApiInfo info) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, info), PERMISSION_INVALID);
        if (StringUtils.isNotBlank((CharSequence)info.getId())) {
            ApiInfo oldInfo = this.getApiInfo(info.getId());
            this.isTrue(!"1".equals(oldInfo.getLock()), RESOURCE_LOCKED);
        }
        return new JsonBean<String>(this.magicAPIService.saveApi(info));
    }

    @RequestMapping(value={"/lock"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> lock(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.LOCK, this.getApiInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.lockApi(id));
    }

    @RequestMapping(value={"/unlock"})
    @ResponseBody
    @Valid(readonly=false)
    public JsonBean<Boolean> unlock(HttpServletRequest request, String id) {
        this.isTrue(this.allowVisit(request, Authorization.UNLOCK, this.getApiInfo(id)), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.magicAPIService.unlockApi(id));
    }

    private ApiInfo getApiInfo(String id) {
        ApiInfo apiInfo = this.magicAPIService.getApiInfo(id);
        this.notNull(apiInfo, API_NOT_FOUND);
        return apiInfo;
    }
}

