/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.config;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.ssssssss.magicapi.config.MessageType;
import org.ssssssss.magicapi.model.MagicConsoleSession;
import org.ssssssss.magicapi.model.MagicNotify;
import org.ssssssss.magicapi.provider.MagicNotifyService;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.script.MagicScriptDebugContext;

public class WebSocketSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private static final Map<String, MagicConsoleSession> SESSION = new ConcurrentHashMap<String, MagicConsoleSession>();
    private static MagicNotifyService magicNotifyService;
    private static String instanceId;

    public static void add(MagicConsoleSession session) {
        SESSION.put(session.getId(), session);
    }

    public static void remove(MagicConsoleSession session) {
        if (session.getId() != null) {
            WebSocketSessionManager.remove(session.getId());
        }
    }

    public static void remove(String sessionId) {
        SESSION.remove(sessionId);
    }

    public static void sendToAll(MessageType messageType, Object ... values) {
        String content = WebSocketSessionManager.buildMessage(messageType, values);
        WebSocketSessionManager.sendToAll(content);
    }

    private static void sendToAll(String content) {
        SESSION.values().stream().filter(MagicConsoleSession::writeable).forEach(session -> WebSocketSessionManager.sendBySession(session, content));
        WebSocketSessionManager.sendToOther(null, content);
    }

    public static void sendBySessionId(String sessionId, MessageType messageType, Object ... values) {
        MagicConsoleSession session = WebSocketSessionManager.findSession(sessionId);
        String content = WebSocketSessionManager.buildMessage(messageType, values);
        if (session != null && session.writeable()) {
            WebSocketSessionManager.sendBySession(session, content);
        } else {
            WebSocketSessionManager.sendToOther(sessionId, content);
        }
    }

    private static void sendToOther(String sessionId, String content) {
        if (magicNotifyService != null) {
            magicNotifyService.sendNotify(new MagicNotify(instanceId, 200, sessionId, content));
        }
    }

    private static String buildMessage(MessageType messageType, Object ... values) {
        StringBuilder builder = new StringBuilder(messageType.name().toLowerCase());
        if (values != null) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                builder.append(",");
                Object value = values[i];
                if (i + 1 < len || value instanceof CharSequence || value instanceof Number) {
                    builder.append(value);
                    continue;
                }
                builder.append(JsonUtils.toJsonString(value));
            }
        }
        return builder.toString();
    }

    public static void sendBySessionId(String sessionId, String content) {
        if (sessionId == null) {
            WebSocketSessionManager.sendToAll(content);
        } else {
            MagicConsoleSession session = WebSocketSessionManager.findSession(sessionId);
            if (session != null) {
                WebSocketSessionManager.sendBySession(session, content);
            }
        }
    }

    public static void sendBySession(MagicConsoleSession session, String content) {
        try {
            session.getWebSocketSession().sendMessage((WebSocketMessage)new TextMessage((CharSequence)content));
        }
        catch (IOException e) {
            logger.error("\u53d1\u9001WebSocket\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public static MagicConsoleSession findSession(String sessionId) {
        return SESSION.values().stream().filter(it -> Objects.equals(sessionId, it.getSessionId())).findFirst().orElse(null);
    }

    public static void setMagicNotifyService(MagicNotifyService magicNotifyService) {
        WebSocketSessionManager.magicNotifyService = magicNotifyService;
    }

    public static void setInstanceId(String instanceId) {
        WebSocketSessionManager.instanceId = instanceId;
    }

    public static void createSession(String sessionId, MagicScriptDebugContext debugContext) {
        MagicConsoleSession consoleSession = WebSocketSessionManager.findSession(sessionId);
        if (consoleSession == null) {
            consoleSession = new MagicConsoleSession(sessionId, debugContext);
            SESSION.put(sessionId, consoleSession);
        } else {
            consoleSession.setMagicScriptDebugContext(debugContext);
        }
    }
}

