/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.dialect.ClickhouseDialect;
import org.ssssssss.magicapi.dialect.DB2Dialect;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.dialect.DmDialect;
import org.ssssssss.magicapi.dialect.KingbaseSQLDialect;
import org.ssssssss.magicapi.dialect.MySQLDialect;
import org.ssssssss.magicapi.dialect.OracleDialect;
import org.ssssssss.magicapi.dialect.PostgreSQLDialect;
import org.ssssssss.magicapi.dialect.SQLServer2005Dialect;
import org.ssssssss.magicapi.dialect.SQLServerDialect;

public class DialectAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DialectAdapter.class);
    private final List<Dialect> dialectList = new ArrayList<Dialect>();

    public DialectAdapter() {
        this.add(new MySQLDialect());
        this.add(new OracleDialect());
        this.add(new PostgreSQLDialect());
        this.add(new ClickhouseDialect());
        this.add(new DB2Dialect());
        this.add(new SQLServerDialect());
        this.add(new SQLServer2005Dialect());
        this.add(new DmDialect());
        this.add(new KingbaseSQLDialect());
    }

    public void add(Dialect dialect) {
        this.dialectList.add(0, dialect);
    }

    public Dialect getDialectFromConnection(Connection connection) {
        for (Dialect dialect : this.dialectList) {
            try {
                if (!dialect.match(connection)) continue;
                return dialect;
            }
            catch (SQLException e) {
                logger.debug("\u65b9\u8a00{}\u5339\u914d\u5931\u8d25", (Object)dialect, (Object)e);
            }
        }
        logger.warn("magic-api\u5728{}\u4e2d\u65e0\u6cd5\u83b7\u53d6dialect", (Object)connection);
        return null;
    }
}

