/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.ssssssss.magicapi.backup.service.MagicBackupService;
import org.ssssssss.magicapi.backup.service.MagicDatabaseBackupService;
import org.ssssssss.magicapi.backup.web.MagicBackupController;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.magicapi.core.config.Backup;
import org.ssssssss.magicapi.core.config.Constants;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.config.MagicCorsFilter;
import org.ssssssss.magicapi.core.config.MagicFunction;
import org.ssssssss.magicapi.core.config.MagicPluginConfiguration;
import org.ssssssss.magicapi.core.config.ResponseCode;
import org.ssssssss.magicapi.core.config.Security;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.core.handler.MagicCoordinationHandler;
import org.ssssssss.magicapi.core.handler.MagicDebugHandler;
import org.ssssssss.magicapi.core.handler.MagicWebSocketDispatcher;
import org.ssssssss.magicapi.core.handler.MagicWorkbenchHandler;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.core.interceptor.DefaultAuthorizationInterceptor;
import org.ssssssss.magicapi.core.interceptor.MagicWebRequestInterceptor;
import org.ssssssss.magicapi.core.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.core.interceptor.ResultProvider;
import org.ssssssss.magicapi.core.logging.LoggerManager;
import org.ssssssss.magicapi.core.model.DataType;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.Plugin;
import org.ssssssss.magicapi.core.resource.DatabaseResource;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.core.resource.ResourceAdapter;
import org.ssssssss.magicapi.core.service.MagicAPIService;
import org.ssssssss.magicapi.core.service.MagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicNotifyService;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.core.service.impl.DefaultMagicAPIService;
import org.ssssssss.magicapi.core.service.impl.DefaultMagicResourceService;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.core.web.MagicResourceController;
import org.ssssssss.magicapi.core.web.MagicWorkbenchController;
import org.ssssssss.magicapi.core.web.RequestHandler;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;
import org.ssssssss.magicapi.datasource.service.DataSourceEncryptProvider;
import org.ssssssss.magicapi.datasource.web.MagicDataSourceController;
import org.ssssssss.magicapi.function.service.FunctionMagicDynamicRegistry;
import org.ssssssss.magicapi.jsr223.LanguageProvider;
import org.ssssssss.magicapi.modules.DynamicModule;
import org.ssssssss.magicapi.spring.boot.starter.ApplicationUriPrinter;
import org.ssssssss.magicapi.spring.boot.starter.MagicDynamicRegistryConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicJsonAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicModuleConfiguration;
import org.ssssssss.magicapi.utils.Mapping;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.exception.MagicScriptRuntimeException;
import org.ssssssss.script.functions.DynamicModuleImport;
import org.ssssssss.script.functions.ExtensionMethod;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.reflection.JavaReflection;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
@EnableConfigurationProperties(value={MagicAPIProperties.class})
@Import(value={MagicJsonAutoConfiguration.class, ApplicationUriPrinter.class, MagicModuleConfiguration.class, MagicDynamicRegistryConfiguration.class})
@EnableWebSocket
@AutoConfigureAfter(value={MagicPluginConfiguration.class})
public class MagicAPIAutoConfiguration
implements WebMvcConfigurer,
WebSocketConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MagicAPIAutoConfiguration.class);
    private final ObjectProvider<List<RequestInterceptor>> requestInterceptorsProvider;
    private final ObjectProvider<List<ExtensionMethod>> extensionMethodsProvider;
    private final ObjectProvider<List<HttpMessageConverter<?>>> httpMessageConvertersProvider;
    private final ObjectProvider<AuthorizationInterceptor> authorizationInterceptorProvider;
    private final ObjectProvider<List<MagicFunction>> magicFunctionsProvider;
    private final ObjectProvider<List<MagicPluginConfiguration>> magicPluginsProvider;
    private final ObjectProvider<MagicNotifyService> magicNotifyServiceProvider;
    private final ObjectProvider<List<MagicDynamicRegistry<? extends MagicEntity>>> magicDynamicRegistriesProvider;
    private final ObjectProvider<List<MagicResourceStorage<? extends MagicEntity>>> magicResourceStoragesProvider;
    private final ObjectProvider<DataSourceEncryptProvider> dataSourceEncryptProvider;
    private final MagicCorsFilter magicCorsFilter = new MagicCorsFilter();
    private final MagicAPIProperties properties;
    private final ApplicationContext applicationContext;
    private boolean registerMapping = false;
    private boolean registerInterceptor = false;
    private boolean registerWebsocket = false;
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private DefaultAuthorizationInterceptor defaultAuthorizationInterceptor;

    public MagicAPIAutoConfiguration(MagicAPIProperties properties, ObjectProvider<List<RequestInterceptor>> requestInterceptorsProvider, ObjectProvider<List<ExtensionMethod>> extensionMethodsProvider, ObjectProvider<List<HttpMessageConverter<?>>> httpMessageConvertersProvider, ObjectProvider<List<MagicFunction>> magicFunctionsProvider, ObjectProvider<List<MagicPluginConfiguration>> magicPluginsProvider, ObjectProvider<MagicNotifyService> magicNotifyServiceProvider, ObjectProvider<AuthorizationInterceptor> authorizationInterceptorProvider, ObjectProvider<DataSourceEncryptProvider> dataSourceEncryptProvider, ObjectProvider<List<MagicDynamicRegistry<? extends MagicEntity>>> magicDynamicRegistriesProvider, ObjectProvider<List<MagicResourceStorage<? extends MagicEntity>>> magicResourceStoragesProvider, ApplicationContext applicationContext) {
        this.properties = properties;
        this.requestInterceptorsProvider = requestInterceptorsProvider;
        this.extensionMethodsProvider = extensionMethodsProvider;
        this.httpMessageConvertersProvider = httpMessageConvertersProvider;
        this.magicFunctionsProvider = magicFunctionsProvider;
        this.magicPluginsProvider = magicPluginsProvider;
        this.magicNotifyServiceProvider = magicNotifyServiceProvider;
        this.authorizationInterceptorProvider = authorizationInterceptorProvider;
        this.dataSourceEncryptProvider = dataSourceEncryptProvider;
        this.magicDynamicRegistriesProvider = magicDynamicRegistriesProvider;
        this.magicResourceStoragesProvider = magicResourceStoragesProvider;
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="database")
    public Resource magicDatabaseResource(MagicDynamicDataSource magicDynamicDataSource) {
        org.ssssssss.magicapi.core.config.Resource resourceConfig = this.properties.getResource();
        if (magicDynamicDataSource.isEmpty()) {
            throw new MagicAPIException("\u5f53\u524d\u672a\u914d\u7f6e\u6570\u636e\u6e90\uff0c\u5982\u5df2\u914d\u7f6e\uff0c\u8bf7\u5f15\u5165 spring-boot-starter-jdbc \u540e\u5728\u8bd5!");
        }
        MagicDynamicDataSource.DataSourceNode dataSourceNode = magicDynamicDataSource.getDataSource(resourceConfig.getDatasource());
        return new DatabaseResource(new JdbcTemplate(dataSourceNode.getDataSource()), resourceConfig.getTableName(), resourceConfig.getPrefix(), resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="file", matchIfMissing=true)
    public Resource magicResource() throws IOException {
        org.ssssssss.magicapi.core.config.Resource resourceConfig = this.properties.getResource();
        return ResourceAdapter.getResource((String)resourceConfig.getLocation(), (boolean)resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicBackupService.class})
    @ConditionalOnProperty(prefix="magic-api", name={"backup.enable"}, havingValue="true")
    public MagicBackupService magicDatabaseBackupService(MagicDynamicDataSource magicDynamicDataSource) {
        Backup backupConfig = this.properties.getBackup();
        MagicDynamicDataSource.DataSourceNode dataSourceNode = magicDynamicDataSource.getDataSource(backupConfig.getDatasource());
        return new MagicDatabaseBackupService(new JdbcTemplate(dataSourceNode.getDataSource()), backupConfig.getTableName());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String web = this.properties.getWeb();
        if (web != null && !this.registerMapping) {
            this.registerMapping = true;
            LoggerManager.createMagicAppender();
            registry.addResourceHandler(new String[]{web + "/**"}).addResourceLocations(new String[]{"classpath:/magic-editor/"});
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (!this.registerInterceptor) {
            this.registerInterceptor = true;
            registry.addInterceptor((HandlerInterceptor)new MagicWebRequestInterceptor(this.properties.isSupportCrossDomain() ? this.magicCorsFilter : null, (AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor))).addPathPatterns(new String[]{"/**"});
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", value={"support-cross-domain"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<MagicCorsFilter> magicCorsFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.magicCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("Magic Cors Filter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public MagicResourceService magicResourceService(Resource workspace) {
        return new DefaultMagicResourceService(workspace, (List)this.magicResourceStoragesProvider.getObject(), (ApplicationEventPublisher)this.applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicNotifyService.class})
    public MagicNotifyService magicNotifyService() {
        logger.info("\u672a\u914d\u7f6e\u96c6\u7fa4\u901a\u77e5\u670d\u52a1\uff0c\u672c\u5b9e\u4f8b\u4e0d\u4f1a\u63a8\u9001\u901a\u77e5\uff0c\u96c6\u7fa4\u73af\u5883\u4e0b\u53ef\u80fd\u4f1a\u6709\u95ee\u9898\uff0c\u5982\u9700\u5f00\u542f\uff0c\u8bf7\u5f15\u7528magic-api-plugin-cluster\u63d2\u4ef6");
        return magicNotify -> {};
    }

    @Bean
    @ConditionalOnMissingBean
    public MagicAPIService magicAPIService(ResultProvider resultProvider, MagicResourceService magicResourceService, RequestMagicDynamicRegistry requestMagicDynamicRegistry, FunctionMagicDynamicRegistry functionMagicDynamicRegistry) {
        return new DefaultMagicAPIService(resultProvider, this.properties.getInstanceId(), magicResourceService, requestMagicDynamicRegistry, functionMagicDynamicRegistry, this.properties.isThrowException(), this.properties.getPrefix(), (ApplicationEventPublisher)this.applicationContext);
    }

    private void setupMagicModules(List<ExtensionMethod> extensionMethods, List<LanguageProvider> languageProviders) {
        MagicResourceLoader.setClassLoader(className -> {
            try {
                return this.applicationContext.getBean(className);
            }
            catch (Exception e) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                    return this.applicationContext.getBean(clazz);
                }
                catch (Exception ex) {
                    if (clazz == null) {
                        throw new MagicScriptRuntimeException((Throwable)new ClassNotFoundException((String)className));
                    }
                    return clazz;
                }
            }
        });
        MagicResourceLoader.addScriptLanguageLoader(language -> languageProviders.stream().filter(it -> it.support(language)).findFirst().map(languageProvider -> (context, script) -> {
            try {
                return languageProvider.execute(language, script, context);
            }
            catch (Exception e) {
                throw new MagicAPIException(e.getMessage(), (Throwable)e);
            }
        }).orElse(null));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"log", Logger.class);
        MagicResourceLoader.addModule((String)"log", (Object)new DynamicModuleImport(Logger.class, context -> LoggerFactory.getLogger((String)Objects.toString(context.getScriptName(), "Unknown"))));
        List importModules = this.properties.getAutoImportModuleList();
        this.applicationContext.getBeansWithAnnotation(MagicModule.class).values().forEach(module -> {
            String moduleName = ((MagicModule)AnnotationUtils.findAnnotation(module.getClass(), MagicModule.class)).value();
            logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)moduleName, module.getClass());
            if (module instanceof DynamicModule) {
                MagicResourceLoader.addModule((String)moduleName, (Object)new DynamicModuleImport(module.getClass(), arg_0 -> ((DynamicModule)((DynamicModule)module)).getDynamicModule(arg_0)));
            } else {
                MagicResourceLoader.addModule((String)moduleName, (Object)module);
            }
        });
        MagicResourceLoader.getModuleNames().stream().filter(importModules::contains).forEach(moduleName -> {
            logger.info("\u81ea\u52a8\u5bfc\u5165\u6a21\u5757\uff1a{}", moduleName);
            MagicScriptEngine.addDefaultImport((String)moduleName, (Object)MagicResourceLoader.loadModule((String)moduleName));
        });
        this.properties.getAutoImportPackageList().forEach(importPackage -> {
            logger.info("\u81ea\u52a8\u5bfc\u5305\uff1a{}", importPackage);
            MagicResourceLoader.addPackage((String)importPackage);
        });
        extensionMethods.forEach(extension -> extension.supports().forEach(support -> {
            logger.info("\u6ce8\u518c\u6269\u5c55:{} -> {}", support, extension.getClass());
            JavaReflection.registerMethodExtension((Class)support, (Object)extension);
        }));
    }

    @Bean
    public MagicConfiguration magicConfiguration(List<LanguageProvider> languageProviders, Resource magicResource, ResultProvider resultProvider, MagicResourceService magicResourceService, MagicAPIService magicAPIService, MagicNotifyService magicNotifyService, RequestMagicDynamicRegistry requestMagicDynamicRegistry, @Autowired(required=false) MagicBackupService magicBackupService) throws NoSuchMethodException {
        logger.info("magic-api\u5de5\u4f5c\u76ee\u5f55:{}", (Object)magicResource);
        AsyncCall.setThreadPoolExecutorSize((int)this.properties.getThreadPoolExecutorSize());
        DataType.DATE_PATTERNS = this.properties.getDatePattern();
        MagicScript.setCompileCache((int)this.properties.getCompileCacheSize());
        ResponseCode responseCodeConfig = this.properties.getResponseCode();
        Constants.RESPONSE_CODE_SUCCESS = responseCodeConfig.getSuccess();
        Constants.RESPONSE_CODE_INVALID = responseCodeConfig.getInvalid();
        Constants.RESPONSE_CODE_EXCEPTION = responseCodeConfig.getException();
        this.setupMagicModules((List)this.extensionMethodsProvider.getIfAvailable(Collections::emptyList), languageProviders);
        MagicConfiguration configuration = new MagicConfiguration();
        configuration.setMagicAPIService(magicAPIService);
        configuration.setMagicNotifyService(magicNotifyService);
        configuration.setInstanceId(this.properties.getInstanceId());
        configuration.setMagicResourceService(magicResourceService);
        configuration.setMagicDynamicRegistries((List)this.magicDynamicRegistriesProvider.getObject());
        configuration.setMagicBackupService(magicBackupService);
        Security security = this.properties.getSecurity();
        configuration.setDebugTimeout(this.properties.getDebug().getTimeout());
        configuration.setHttpMessageConverters((List)this.httpMessageConvertersProvider.getIfAvailable(Collections::emptyList));
        configuration.setResultProvider(resultProvider);
        configuration.setThrowException(this.properties.isThrowException());
        configuration.setEditorConfig(this.properties.getEditorConfig());
        configuration.setWorkspace(magicResource);
        configuration.setAuthorizationInterceptor((AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor));
        ((List)this.magicFunctionsProvider.getIfAvailable(Collections::emptyList)).forEach(JavaReflection::registerFunction);
        security.setUsername(null);
        security.setPassword(null);
        requestMagicDynamicRegistry.setHandler((Object)new RequestHandler(configuration, requestMagicDynamicRegistry));
        List pluginConfigurations = (List)this.magicPluginsProvider.getIfAvailable(Collections::emptyList);
        List plugins = pluginConfigurations.stream().map(MagicPluginConfiguration::plugin).collect(Collectors.toList());
        String base = this.properties.getWeb();
        Mapping mapping = Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping, (String)base);
        MagicWorkbenchController magicWorkbenchController = new MagicWorkbenchController(configuration, this.properties, plugins);
        if (base != null) {
            configuration.setEnableWeb(true);
            mapping.registerController((Object)magicWorkbenchController).registerController((Object)new MagicResourceController(configuration)).registerController((Object)new MagicDataSourceController(configuration)).registerController((Object)new MagicBackupController(configuration));
            pluginConfigurations.forEach(it -> it.controllerRegister().register(mapping, configuration));
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties.getSecretKey())) {
            mapping.register(mapping.paths(new String[]{this.properties.getPushPath()}).methods(new RequestMethod[]{RequestMethod.POST}).build(), (Object)magicWorkbenchController, MagicWorkbenchController.class.getDeclaredMethod("receivePush", MultipartFile.class, String.class, Long.class, String.class));
        }
        ((List)this.requestInterceptorsProvider.getIfAvailable(Collections::emptyList)).forEach(interceptor -> {
            logger.info("\u6ce8\u518c\u8bf7\u6c42\u62e6\u622a\u5668\uff1a{}", interceptor.getClass());
            configuration.addRequestInterceptor(interceptor);
        });
        if (this.properties.isBanner()) {
            configuration.printBanner(plugins.stream().map(Plugin::getName).collect(Collectors.toList()));
        }
        if (magicBackupService == null) {
            logger.error("\u5f53\u524d\u5907\u4efd\u8bbe\u7f6e\u672a\u914d\u7f6e\uff0c\u5f3a\u70c8\u5efa\u8bae\u914d\u7f6e\u5907\u4efd\u8bbe\u7f6e\uff0c\u4ee5\u514d\u4ee3\u7801\u4e22\u5931\u3002");
        }
        if (this.properties.getBackup().isEnable() && this.properties.getBackup().getMaxHistory() > 0 && magicBackupService != null) {
            long interval = (long)this.properties.getBackup().getMaxHistory() * 86400000L;
            new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "magic-api-clean-task")).scheduleAtFixedRate(() -> {
                try {
                    long count = magicBackupService.removeBackupByTimestamp(System.currentTimeMillis() - interval);
                    if (count > 0L) {
                        logger.info("\u5df2\u5220\u9664\u5907\u4efd\u8bb0\u5f55{}\u6761", (Object)count);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5220\u9664\u5907\u4efd\u8bb0\u5f55\u65f6\u51fa\u9519", (Throwable)e);
                }
            }, 1L, 1L, TimeUnit.HOURS);
        }
        return configuration;
    }

    public AuthorizationInterceptor createAuthorizationInterceptor() {
        if (this.defaultAuthorizationInterceptor != null) {
            return this.defaultAuthorizationInterceptor;
        }
        Security security = this.properties.getSecurity();
        this.defaultAuthorizationInterceptor = new DefaultAuthorizationInterceptor(security.getUsername(), security.getPassword());
        return this.defaultAuthorizationInterceptor;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
        String web = this.properties.getWeb();
        MagicNotifyService magicNotifyService = (MagicNotifyService)this.magicNotifyServiceProvider.getObject();
        WebSocketSessionManager.setMagicNotifyService((MagicNotifyService)magicNotifyService);
        if (web != null && !this.registerWebsocket) {
            this.registerWebsocket = true;
            MagicWebSocketDispatcher dispatcher = new MagicWebSocketDispatcher(this.properties.getInstanceId(), magicNotifyService, Arrays.asList(new MagicDebugHandler(), new MagicCoordinationHandler(), new MagicWorkbenchHandler((AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor))));
            WebSocketHandlerRegistration registration = webSocketHandlerRegistry.addHandler((WebSocketHandler)dispatcher, new String[]{web + "/console"});
            if (this.properties.isSupportCrossDomain()) {
                registration.setAllowedOrigins(new String[]{"*"});
            }
        }
    }
}

