/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.ssssssss.magicapi.adapter.ColumnMapperAdapter;
import org.ssssssss.magicapi.adapter.DialectAdapter;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.ResourceAdapter;
import org.ssssssss.magicapi.adapter.resource.DatabaseResource;
import org.ssssssss.magicapi.cache.DefaultSqlCache;
import org.ssssssss.magicapi.cache.SqlCache;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.MagicCorsFilter;
import org.ssssssss.magicapi.config.MagicDynamicDataSource;
import org.ssssssss.magicapi.config.MagicFunction;
import org.ssssssss.magicapi.config.MagicFunctionManager;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.magicapi.config.MagicWebRequestInterceptor;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.config.WebSocketSessionManager;
import org.ssssssss.magicapi.controller.MagicAPIController;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicDataSourceController;
import org.ssssssss.magicapi.controller.MagicDebugHandler;
import org.ssssssss.magicapi.controller.MagicFunctionController;
import org.ssssssss.magicapi.controller.MagicGroupController;
import org.ssssssss.magicapi.controller.MagicWebSocketDispatcher;
import org.ssssssss.magicapi.controller.MagicWorkbenchController;
import org.ssssssss.magicapi.controller.MagicWorkbenchHandler;
import org.ssssssss.magicapi.controller.RequestHandler;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.DefaultAuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.DefaultSqlInterceptor;
import org.ssssssss.magicapi.interceptor.NamedTableInterceptor;
import org.ssssssss.magicapi.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.logging.LoggerManager;
import org.ssssssss.magicapi.model.Constants;
import org.ssssssss.magicapi.model.DataType;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.modules.AssertModule;
import org.ssssssss.magicapi.modules.EnvModule;
import org.ssssssss.magicapi.modules.HttpModule;
import org.ssssssss.magicapi.modules.RequestModule;
import org.ssssssss.magicapi.modules.ResponseModule;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.ColumnMapperProvider;
import org.ssssssss.magicapi.provider.DataSourceEncryptProvider;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.provider.LanguageProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.MagicBackupService;
import org.ssssssss.magicapi.provider.MagicNotifyService;
import org.ssssssss.magicapi.provider.PageProvider;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.provider.impl.DefaultApiServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultFunctionServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultGroupServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultMagicAPIService;
import org.ssssssss.magicapi.provider.impl.DefaultPageProvider;
import org.ssssssss.magicapi.provider.impl.DefaultResultProvider;
import org.ssssssss.magicapi.provider.impl.JSR223LanguageProvider;
import org.ssssssss.magicapi.provider.impl.MagicDatabaseBackupService;
import org.ssssssss.magicapi.provider.impl.MagicFileBackupService;
import org.ssssssss.magicapi.spring.boot.starter.ApplicationUriPrinter;
import org.ssssssss.magicapi.spring.boot.starter.BackupConfig;
import org.ssssssss.magicapi.spring.boot.starter.CacheConfig;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIProperties;
import org.ssssssss.magicapi.spring.boot.starter.MagicJsonAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicMongoAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicRedisAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicSwaggerConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.PageConfig;
import org.ssssssss.magicapi.spring.boot.starter.ResourceConfig;
import org.ssssssss.magicapi.spring.boot.starter.ResponseCodeConfig;
import org.ssssssss.magicapi.spring.boot.starter.SecurityConfig;
import org.ssssssss.magicapi.utils.ClassScanner;
import org.ssssssss.magicapi.utils.Mapping;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.exception.MagicScriptRuntimeException;
import org.ssssssss.script.functions.DynamicModuleImport;
import org.ssssssss.script.functions.ExtensionMethod;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.reflection.JavaReflection;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
@EnableConfigurationProperties(value={MagicAPIProperties.class})
@Import(value={MagicRedisAutoConfiguration.class, MagicMongoAutoConfiguration.class, MagicSwaggerConfiguration.class, MagicJsonAutoConfiguration.class, ApplicationUriPrinter.class})
@EnableWebSocket
public class MagicAPIAutoConfiguration
implements WebMvcConfigurer,
WebSocketConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MagicAPIAutoConfiguration.class);
    private final ObjectProvider<List<RequestInterceptor>> requestInterceptorsProvider;
    private final ObjectProvider<List<SQLInterceptor>> sqlInterceptorsProvider;
    private final ObjectProvider<List<NamedTableInterceptor>> namedTableInterceptorsProvider;
    private final ObjectProvider<List<ExtensionMethod>> extensionMethodsProvider;
    private final ObjectProvider<List<HttpMessageConverter<?>>> httpMessageConvertersProvider;
    private final ObjectProvider<List<Dialect>> dialectsProvider;
    private final ObjectProvider<List<ColumnMapperProvider>> columnMapperProvidersProvider;
    private final ObjectProvider<AuthorizationInterceptor> authorizationInterceptorProvider;
    private final ObjectProvider<List<MagicFunction>> magicFunctionsProvider;
    private final ObjectProvider<MagicNotifyService> magicNotifyServiceProvider;
    private final ObjectProvider<DataSourceEncryptProvider> dataSourceEncryptProvider;
    private final Environment environment;
    private final MagicCorsFilter magicCorsFilter = new MagicCorsFilter();
    private final MagicAPIProperties properties;
    private final ApplicationContext applicationContext;
    private boolean registerMapping = false;
    private boolean registerInterceptor = false;
    private boolean registerWebsocket = false;
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired(required=false)
    private MultipartResolver multipartResolver;
    private String allClassTxt;
    private DefaultAuthorizationInterceptor defaultAuthorizationInterceptor;

    public MagicAPIAutoConfiguration(MagicAPIProperties properties, ObjectProvider<List<Dialect>> dialectsProvider, ObjectProvider<List<RequestInterceptor>> requestInterceptorsProvider, ObjectProvider<List<SQLInterceptor>> sqlInterceptorsProvider, ObjectProvider<List<ExtensionMethod>> extensionMethodsProvider, ObjectProvider<List<HttpMessageConverter<?>>> httpMessageConvertersProvider, ObjectProvider<List<ColumnMapperProvider>> columnMapperProvidersProvider, ObjectProvider<List<MagicFunction>> magicFunctionsProvider, ObjectProvider<MagicNotifyService> magicNotifyServiceProvider, ObjectProvider<AuthorizationInterceptor> authorizationInterceptorProvider, ObjectProvider<List<NamedTableInterceptor>> namedTableInterceptorsProvider, ObjectProvider<DataSourceEncryptProvider> dataSourceEncryptProvider, Environment environment, ApplicationContext applicationContext) {
        this.properties = properties;
        this.dialectsProvider = dialectsProvider;
        this.requestInterceptorsProvider = requestInterceptorsProvider;
        this.sqlInterceptorsProvider = sqlInterceptorsProvider;
        this.extensionMethodsProvider = extensionMethodsProvider;
        this.httpMessageConvertersProvider = httpMessageConvertersProvider;
        this.columnMapperProvidersProvider = columnMapperProvidersProvider;
        this.magicFunctionsProvider = magicFunctionsProvider;
        this.magicNotifyServiceProvider = magicNotifyServiceProvider;
        this.authorizationInterceptorProvider = authorizationInterceptorProvider;
        this.namedTableInterceptorsProvider = namedTableInterceptorsProvider;
        this.dataSourceEncryptProvider = dataSourceEncryptProvider;
        this.environment = environment;
        this.applicationContext = applicationContext;
    }

    private String redirectIndex(HttpServletRequest request) {
        if (request.getRequestURI().endsWith("/")) {
            return "redirect:./index.html";
        }
        return "redirect:" + this.properties.getWeb() + "/index.html";
    }

    @ResponseBody
    private MagicAPIProperties readConfig() {
        return this.properties;
    }

    @ResponseBody
    private String readClass() {
        if (this.allClassTxt == null) {
            try {
                this.allClassTxt = ClassScanner.compress((List)ClassScanner.scan());
            }
            catch (Throwable t) {
                logger.warn("\u626b\u63cfClass\u5931\u8d25", t);
                this.allClassTxt = "";
            }
        }
        return this.allClassTxt;
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpModule.class})
    public HttpModule magicHttpModule() {
        return new HttpModule(this.createRestTemplate());
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicDynamicDataSource.class})
    public MagicDynamicDataSource magicDynamicDataSource(@Autowired(required=false) DataSource dataSource) {
        MagicDynamicDataSource dynamicDataSource = new MagicDynamicDataSource();
        if (dataSource != null) {
            dynamicDataSource.put(dataSource);
        } else {
            logger.warn("\u5f53\u524d\u6570\u636e\u6e90\u672a\u914d\u7f6e");
        }
        return dynamicDataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="database")
    public Resource magicDatabaseResource(MagicDynamicDataSource magicDynamicDataSource) {
        ResourceConfig resourceConfig = this.properties.getResource();
        if (magicDynamicDataSource.isEmpty()) {
            throw new MagicAPIException("\u5f53\u524d\u672a\u914d\u7f6e\u6570\u636e\u6e90\uff0c\u5982\u5df2\u914d\u7f6e\uff0c\u8bf7\u5f15\u5165 spring-boot-starter-jdbc \u540e\u5728\u8bd5!");
        }
        MagicDynamicDataSource.DataSourceNode dataSourceNode = magicDynamicDataSource.getDataSource(resourceConfig.getDatasource());
        return new DatabaseResource(new JdbcTemplate(dataSourceNode.getDataSource()), resourceConfig.getTableName(), resourceConfig.getPrefix(), resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="file", matchIfMissing=true)
    public Resource magicResource() throws IOException {
        ResourceConfig resourceConfig = this.properties.getResource();
        return ResourceAdapter.getResource((String)resourceConfig.getLocation(), (boolean)resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicBackupService.class})
    @ConditionalOnProperty(prefix="magic-api", name={"backup-config.resource-type"}, havingValue="database")
    public MagicBackupService magicDatabaseBackupService(MagicDynamicDataSource magicDynamicDataSource) {
        BackupConfig backupConfig = this.properties.getBackupConfig();
        MagicDynamicDataSource.DataSourceNode dataSourceNode = magicDynamicDataSource.getDataSource(backupConfig.getDatasource());
        return new MagicDatabaseBackupService(new JdbcTemplate(dataSourceNode.getDataSource()), backupConfig.getTableName());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String web = this.properties.getWeb();
        if (web != null && !this.registerMapping) {
            this.registerMapping = true;
            LoggerManager.createMagicAppender();
            registry.addResourceHandler(new String[]{web + "/**"}).addResourceLocations(new String[]{"classpath:/magic-editor/"});
            try {
                Mapping mapping = Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping);
                mapping.register(mapping.paths(new String[]{web}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("redirectIndex", HttpServletRequest.class)).register(mapping.paths(new String[]{web + "/config.json"}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("readConfig", new Class[0])).register(mapping.paths(new String[]{web + "/classes.txt"}).produces(new String[]{"text/plain"}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("readClass", new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (!this.registerInterceptor) {
            this.registerInterceptor = true;
            registry.addInterceptor((HandlerInterceptor)new MagicWebRequestInterceptor(this.properties.isSupportCrossDomain() ? this.magicCorsFilter : null, (AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor))).addPathPatterns(new String[]{"/**"});
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", value={"support-cross-domain"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<MagicCorsFilter> magicCorsFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.magicCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("Magic Cors Filter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(value={PageProvider.class})
    public PageProvider pageProvider() {
        PageConfig pageConfig = this.properties.getPageConfig();
        logger.info("\u672a\u627e\u5230\u5206\u9875\u5b9e\u73b0,\u91c7\u7528\u9ed8\u8ba4\u5206\u9875\u5b9e\u73b0,\u5206\u9875\u914d\u7f6e:(\u9875\u7801={},\u9875\u5927\u5c0f={},\u9ed8\u8ba4\u9996\u9875={},\u9ed8\u8ba4\u9875\u5927\u5c0f={})", new Object[]{pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize()});
        return new DefaultPageProvider(pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={ResultProvider.class})
    public ResultProvider resultProvider() {
        return new DefaultResultProvider(this.properties.getResponse());
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlCache.class})
    public SqlCache sqlCache() {
        CacheConfig cacheConfig = this.properties.getCacheConfig();
        logger.info("\u672a\u627e\u5230SQL\u7f13\u5b58\u5b9e\u73b0\uff0c\u91c7\u7528\u9ed8\u8ba4\u7f13\u5b58\u5b9e\u73b0(LRU+TTL)\uff0c\u7f13\u5b58\u914d\u7f6e:(\u5bb9\u91cf={},TTL={})", (Object)cacheConfig.getCapacity(), (Object)cacheConfig.getTtl());
        return new DefaultSqlCache(cacheConfig.getCapacity(), cacheConfig.getTtl());
    }

    @Bean
    public MappingHandlerMapping mappingHandlerMapping() throws NoSuchMethodException {
        String prefix = StringUtils.isNotBlank((CharSequence)this.properties.getPrefix()) ? PathUtils.replaceSlash((String)("/" + this.properties.getPrefix() + "/")) : null;
        return new MappingHandlerMapping(prefix, this.properties.isAllowOverride());
    }

    @Bean
    @ConditionalOnMissingBean(value={FunctionServiceProvider.class})
    public FunctionServiceProvider functionServiceProvider(GroupServiceProvider groupServiceProvider, Resource magicResource) {
        return new DefaultFunctionServiceProvider(groupServiceProvider, magicResource);
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupServiceProvider.class})
    public GroupServiceProvider groupServiceProvider(Resource magicResource) {
        return new DefaultGroupServiceProvider(magicResource);
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiServiceProvider.class})
    public ApiServiceProvider apiServiceProvider(GroupServiceProvider groupServiceProvider, Resource magicResource) {
        return new DefaultApiServiceProvider(groupServiceProvider, magicResource);
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicNotifyService.class})
    public MagicNotifyService magicNotifyService() {
        logger.info("\u672a\u914d\u7f6e\u96c6\u7fa4\u901a\u77e5\u670d\u52a1\uff0c\u672c\u5b9e\u4f8b\u4e0d\u4f1a\u63a8\u9001\u901a\u77e5\uff0c\u96c6\u7fa4\u73af\u5883\u4e0b\u53ef\u80fd\u4f1a\u6709\u95ee\u9898\uff0c\u5982\u9700\u5f00\u542f\uff0c\u8bf7\u914d\u7f6emagic-api.cluster-config.enable=true\uff0c\u82e5\u5f00\u542f\u540e\u672c\u63d0\u793a\u8fd8\u5728\uff0c\u8bf7\u68c0\u67e5 spring-boot-starter-data-redis \u662f\u5426\u5f15\u5165");
        return magicNotify -> {};
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicBackupService.class})
    @ConditionalOnProperty(prefix="magic-api", name={"backup-config.resource-type"}, havingValue="file", matchIfMissing=true)
    public MagicBackupService magicFileBackupService() {
        return new MagicFileBackupService(new File(this.properties.getBackupConfig().getLocation()));
    }

    @Bean
    public MagicFunctionManager magicFunctionManager(GroupServiceProvider groupServiceProvider, FunctionServiceProvider functionServiceProvider) {
        return new MagicFunctionManager(groupServiceProvider, functionServiceProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public MagicAPIService magicAPIService(MappingHandlerMapping mappingHandlerMapping, ApiServiceProvider apiServiceProvider, FunctionServiceProvider functionServiceProvider, GroupServiceProvider groupServiceProvider, ResultProvider resultProvider, MagicDynamicDataSource magicDynamicDataSource, MagicFunctionManager magicFunctionManager, Resource workspace, MagicBackupService magicBackupService) {
        return new DefaultMagicAPIService(mappingHandlerMapping, apiServiceProvider, functionServiceProvider, groupServiceProvider, resultProvider, magicDynamicDataSource, magicFunctionManager, (MagicNotifyService)this.magicNotifyServiceProvider.getObject(), this.properties.getClusterConfig().getInstanceId(), workspace, magicBackupService, (DataSourceEncryptProvider)this.dataSourceEncryptProvider.getIfAvailable(), this.properties.isThrowException());
    }

    @Bean
    @ConditionalOnBean(value={MagicDynamicDataSource.class})
    public SQLModule magicSqlModule(MagicDynamicDataSource dynamicDataSource, ResultProvider resultProvider, PageProvider pageProvider, SqlCache sqlCache) {
        SQLModule sqlModule = new SQLModule(dynamicDataSource);
        if (!dynamicDataSource.isEmpty()) {
            sqlModule.setDataSourceNode(dynamicDataSource.getDataSource());
        }
        sqlModule.setResultProvider(resultProvider);
        sqlModule.setPageProvider(pageProvider);
        List sqlInterceptors = (List)this.sqlInterceptorsProvider.getIfAvailable(ArrayList::new);
        if (this.properties.isShowSql()) {
            sqlInterceptors.add(new DefaultSqlInterceptor());
        }
        sqlModule.setSqlInterceptors(sqlInterceptors);
        sqlModule.setNamedTableInterceptors((List)this.namedTableInterceptorsProvider.getIfAvailable(Collections::emptyList));
        ColumnMapperAdapter columnMapperAdapter = new ColumnMapperAdapter();
        ((List)this.columnMapperProvidersProvider.getIfAvailable(Collections::emptyList)).stream().filter(mapperProvider -> !"default".equals(mapperProvider.name())).forEach(arg_0 -> ((ColumnMapperAdapter)columnMapperAdapter).add(arg_0));
        columnMapperAdapter.setDefault(this.properties.getSqlColumnCase());
        sqlModule.setColumnMapperProvider(columnMapperAdapter);
        sqlModule.setColumnMapRowMapper(columnMapperAdapter.getDefaultColumnMapRowMapper());
        sqlModule.setRowMapColumnMapper(columnMapperAdapter.getDefaultRowMapColumnMapper());
        sqlModule.setSqlCache(sqlCache);
        DialectAdapter dialectAdapter = new DialectAdapter();
        ((List)this.dialectsProvider.getIfAvailable(Collections::emptyList)).forEach(arg_0 -> ((DialectAdapter)dialectAdapter).add(arg_0));
        sqlModule.setDialectAdapter(dialectAdapter);
        sqlModule.setLogicDeleteColumn(this.properties.getCrudConfig().getLogicDeleteColumn());
        sqlModule.setLogicDeleteValue(this.properties.getCrudConfig().getLogicDeleteValue());
        return sqlModule;
    }

    private void setupMagicModules(MagicDynamicDataSource dynamicDataSource, SQLModule sqlModule, ResultProvider resultProvider, List<MagicModule> magicModules, List<ExtensionMethod> extensionMethods, List<LanguageProvider> languageProviders) {
        MagicResourceLoader.setClassLoader(className -> {
            try {
                return this.applicationContext.getBean(className);
            }
            catch (Exception e) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                    return this.applicationContext.getBean(clazz);
                }
                catch (Exception ex) {
                    if (clazz == null) {
                        throw new MagicScriptRuntimeException((Throwable)new ClassNotFoundException((String)className));
                    }
                    return clazz;
                }
            }
        });
        MagicResourceLoader.addScriptLanguageLoader(language -> languageProviders.stream().filter(it -> it.support(language)).findFirst().map(languageProvider -> (context, script) -> {
            try {
                return languageProvider.execute(language, script, context);
            }
            catch (Exception e) {
                throw new MagicAPIException(e.getMessage(), (Throwable)e);
            }
        }).orElse(null));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"log", Logger.class);
        MagicResourceLoader.addModule((String)"log", (Object)new DynamicModuleImport(Logger.class, context -> LoggerFactory.getLogger((String)Objects.toString(context.getScriptName(), "Unknown"))));
        List<String> importModules = this.properties.getAutoImportModuleList();
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"env", EnvModule.class);
        MagicResourceLoader.addModule((String)"env", (Object)new EnvModule(this.environment));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"request", RequestModule.class);
        MagicResourceLoader.addModule((String)"request", (Object)new RequestModule(this.multipartResolver));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"response", ResponseModule.class);
        MagicResourceLoader.addModule((String)"response", (Object)new ResponseModule(resultProvider));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"assert", AssertModule.class);
        MagicResourceLoader.addModule((String)"assert", (Object)new AssertModule());
        magicModules.forEach(module -> {
            logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)module.getModuleName(), module.getClass());
            MagicResourceLoader.addModule((String)module.getModuleName(), (Object)module);
        });
        MagicResourceLoader.addModule((String)sqlModule.getModuleName(), (Object)new DynamicModuleImport(SQLModule.class, context -> {
            String dataSourceKey = context.getString(Options.DEFAULT_DATA_SOURCE.getValue());
            if (StringUtils.isEmpty((CharSequence)dataSourceKey)) {
                return sqlModule;
            }
            SQLModule newSqlModule = sqlModule.cloneSQLModule();
            newSqlModule.setDataSourceNode(dynamicDataSource.getDataSource(dataSourceKey));
            return newSqlModule;
        }));
        MagicResourceLoader.getModuleNames().stream().filter(importModules::contains).forEach(moduleName -> {
            logger.info("\u81ea\u52a8\u5bfc\u5165\u6a21\u5757\uff1a{}", moduleName);
            MagicScriptEngine.addDefaultImport((String)moduleName, (Object)MagicResourceLoader.loadModule((String)moduleName));
        });
        this.properties.getAutoImportPackageList().forEach(importPackage -> {
            logger.info("\u81ea\u52a8\u5bfc\u5305\uff1a{}", importPackage);
            MagicResourceLoader.addPackage((String)importPackage);
        });
        extensionMethods.forEach(extension -> extension.supports().forEach(support -> {
            logger.info("\u6ce8\u518c\u6269\u5c55:{} -> {}", support, extension.getClass());
            JavaReflection.registerMethodExtension((Class)support, (Object)extension);
        }));
    }

    @Bean
    public JSR223LanguageProvider jsr223LanguageProvider() {
        return new JSR223LanguageProvider();
    }

    @Bean
    public MagicConfiguration magicConfiguration(MagicDynamicDataSource dynamicDataSource, SQLModule sqlModule, List<MagicModule> magicModules, List<LanguageProvider> languageProviders, Resource magicResource, ResultProvider resultProvider, MagicAPIService magicAPIService, ApiServiceProvider apiServiceProvider, GroupServiceProvider groupServiceProvider, MappingHandlerMapping mappingHandlerMapping, FunctionServiceProvider functionServiceProvider, MagicNotifyService magicNotifyService, MagicFunctionManager magicFunctionManager, MagicBackupService magicBackupService) throws NoSuchMethodException {
        logger.info("magic-api\u5de5\u4f5c\u76ee\u5f55:{}", (Object)magicResource);
        AsyncCall.setThreadPoolExecutorSize((int)this.properties.getThreadPoolExecutorSize());
        DataType.DATE_PATTERNS = this.properties.getDatePattern();
        MagicScript.setCompileCache((int)this.properties.getCompileCacheSize());
        ResponseCodeConfig responseCodeConfig = this.properties.getResponseCodeConfig();
        Constants.RESPONSE_CODE_SUCCESS = responseCodeConfig.getSuccess();
        Constants.RESPONSE_CODE_INVALID = responseCodeConfig.getInvalid();
        Constants.RESPONSE_CODE_EXCEPTION = responseCodeConfig.getException();
        this.setupMagicModules(dynamicDataSource, sqlModule, resultProvider, magicModules, (List)this.extensionMethodsProvider.getIfAvailable(Collections::emptyList), languageProviders);
        MagicConfiguration configuration = new MagicConfiguration();
        configuration.setMagicAPIService(magicAPIService);
        configuration.setMagicNotifyService(magicNotifyService);
        configuration.setInstanceId(this.properties.getClusterConfig().getInstanceId());
        configuration.setApiServiceProvider(apiServiceProvider);
        configuration.setGroupServiceProvider(groupServiceProvider);
        configuration.setMappingHandlerMapping(mappingHandlerMapping);
        configuration.setFunctionServiceProvider(functionServiceProvider);
        configuration.setMagicBackupService(magicBackupService);
        SecurityConfig securityConfig = this.properties.getSecurityConfig();
        configuration.setDebugTimeout(this.properties.getDebugConfig().getTimeout());
        configuration.setHttpMessageConverters((List)this.httpMessageConvertersProvider.getIfAvailable(Collections::emptyList));
        configuration.setResultProvider(resultProvider);
        configuration.setThrowException(this.properties.isThrowException());
        configuration.setEditorConfig(this.properties.getEditorConfig());
        configuration.setWorkspace(magicResource);
        configuration.setAuthorizationInterceptor((AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor));
        ((List)this.magicFunctionsProvider.getIfAvailable(Collections::emptyList)).forEach(JavaReflection::registerFunction);
        securityConfig.setUsername(null);
        securityConfig.setPassword(null);
        String base = this.properties.getWeb();
        mappingHandlerMapping.setRequestMappingHandlerMapping(this.requestMappingHandlerMapping);
        MagicDataSourceController dataSourceController = new MagicDataSourceController(configuration);
        MagicWorkbenchController magicWorkbenchController = new MagicWorkbenchController(configuration, this.properties.getSecretKey());
        if (base != null) {
            configuration.setEnableWeb(true);
            ArrayList<MagicController> controllers = new ArrayList<MagicController>(Arrays.asList(new MagicAPIController(configuration), dataSourceController, magicWorkbenchController, new MagicGroupController(configuration), new MagicFunctionController(configuration)));
            controllers.forEach(item -> mappingHandlerMapping.registerController(item, base));
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties.getSecretKey())) {
            Mapping mapping = Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping);
            RequestMappingInfo requestMappingInfo = mapping.paths(new String[]{this.properties.getPushPath()}).build();
            Method method = MagicWorkbenchController.class.getDeclaredMethod("receivePush", MultipartFile.class, String.class, Long.class, String.class);
            mapping.register(requestMappingInfo, (Object)magicWorkbenchController, method);
        }
        magicAPIService.registerAllDataSource();
        ((List)this.requestInterceptorsProvider.getIfAvailable(Collections::emptyList)).forEach(interceptor -> {
            logger.info("\u6ce8\u518c\u8bf7\u6c42\u62e6\u622a\u5668\uff1a{}", interceptor.getClass());
            configuration.addRequestInterceptor(interceptor);
        });
        if (this.properties.isBanner()) {
            configuration.printBanner();
        }
        configuration.setMagicFunctionManager(magicFunctionManager);
        magicFunctionManager.registerFunctionLoader();
        magicFunctionManager.registerAllFunction();
        mappingHandlerMapping.setHandler((Object)new RequestHandler(configuration));
        mappingHandlerMapping.setMagicApiService(apiServiceProvider);
        mappingHandlerMapping.setGroupServiceProvider(groupServiceProvider);
        mappingHandlerMapping.registerAllMapping();
        if (this.properties.getBackupConfig().getMaxHistory() > 0) {
            long interval = (long)this.properties.getBackupConfig().getMaxHistory() * 86400000L;
            new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "magic-api-clean-task")).scheduleAtFixedRate(() -> {
                try {
                    long count = magicBackupService.removeBackupByTimestamp(System.currentTimeMillis() - interval);
                    if (count > 0L) {
                        logger.info("\u5df2\u5220\u9664\u5907\u4efd\u8bb0\u5f55{}\u6761", (Object)count);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5220\u9664\u5907\u4efd\u8bb0\u5f55\u65f6\u51fa\u9519", (Throwable)e);
                }
            }, 1L, 1L, TimeUnit.HOURS);
        }
        return configuration;
    }

    public AuthorizationInterceptor createAuthorizationInterceptor() {
        if (this.defaultAuthorizationInterceptor != null) {
            return this.defaultAuthorizationInterceptor;
        }
        SecurityConfig securityConfig = this.properties.getSecurityConfig();
        this.defaultAuthorizationInterceptor = new DefaultAuthorizationInterceptor(securityConfig.getUsername(), securityConfig.getPassword());
        return this.defaultAuthorizationInterceptor;
    }

    private RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new StringHttpMessageConverter(StandardCharsets.UTF_8){
            {
                this.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
            }

            public boolean supports(Class<?> clazz) {
                return true;
            }
        });
        return restTemplate;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
        String web = this.properties.getWeb();
        MagicNotifyService magicNotifyService = (MagicNotifyService)this.magicNotifyServiceProvider.getObject();
        WebSocketSessionManager.setMagicNotifyService((MagicNotifyService)magicNotifyService);
        if (web != null && !this.registerWebsocket) {
            this.registerWebsocket = true;
            MagicWebSocketDispatcher dispatcher = new MagicWebSocketDispatcher(this.properties.getClusterConfig().getInstanceId(), magicNotifyService, Arrays.asList(new MagicDebugHandler(), new MagicWorkbenchHandler((AuthorizationInterceptor)this.authorizationInterceptorProvider.getIfAvailable(this::createAuthorizationInterceptor))));
            WebSocketHandlerRegistration registration = webSocketHandlerRegistry.addHandler((WebSocketHandler)dispatcher, new String[]{web + "/console"});
            if (this.properties.isSupportCrossDomain()) {
                registration.setAllowedOrigins(new String[]{"*"});
            }
        }
    }
}

