/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.swagger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.MagicPluginConfiguration;
import org.ssssssss.magicapi.core.model.Plugin;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.swagger.SwaggerConfig;
import org.ssssssss.magicapi.swagger.entity.SwaggerEntity;
import org.ssssssss.magicapi.swagger.entity.SwaggerProvider;
import org.ssssssss.magicapi.utils.Mapping;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
@EnableConfigurationProperties(value={SwaggerConfig.class})
@ConditionalOnClass(name={"springfox.documentation.swagger.web.SwaggerResourcesProvider"})
public class MagicSwaggerConfiguration
implements MagicPluginConfiguration {
    private final MagicAPIProperties properties;
    private final SwaggerConfig swaggerConfig;
    private final ApplicationContext applicationContext;
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public MagicSwaggerConfiguration(MagicAPIProperties properties, SwaggerConfig swaggerConfig, ApplicationContext applicationContext) {
        this.properties = properties;
        this.swaggerConfig = swaggerConfig;
        this.applicationContext = applicationContext;
    }

    public Plugin plugin() {
        return new Plugin("Swagger");
    }

    @Bean
    @Primary
    public SwaggerResourcesProvider magicSwaggerResourcesProvider(RequestMagicDynamicRegistry requestMagicDynamicRegistry, MagicResourceService magicResourceService, ServletContext servletContext) throws NoSuchMethodException {
        Mapping mapping = Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping);
        RequestMappingInfo requestMappingInfo = mapping.paths(new String[]{this.swaggerConfig.getLocation()}).build();
        SwaggerEntity.License license = new SwaggerEntity.License("MIT", "https://gitee.com/ssssssss-team/magic-api/blob/master/LICENSE");
        SwaggerEntity.Info info = new SwaggerEntity.Info(this.swaggerConfig.getDescription(), this.swaggerConfig.getVersion(), this.swaggerConfig.getTitle(), license, this.swaggerConfig.getConcat());
        SwaggerProvider swaggerProvider = new SwaggerProvider(requestMagicDynamicRegistry, magicResourceService, servletContext.getContextPath(), info, this.properties.isPersistenceResponseBody());
        mapping.register(requestMappingInfo, (Object)swaggerProvider, SwaggerProvider.class.getDeclaredMethod("swaggerJson", new Class[0]));
        return () -> {
            ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
            resources.add(this.swaggerResource(this.swaggerConfig.getName(), this.swaggerConfig.getLocation()));
            Map beans = this.applicationContext.getBeansOfType(SwaggerResourcesProvider.class);
            for (Map.Entry entry : beans.entrySet()) {
                if ("magicSwaggerResourcesProvider".equalsIgnoreCase((String)entry.getKey())) continue;
                resources.addAll((Collection)((SwaggerResourcesProvider)entry.getValue()).get());
            }
            return resources;
        };
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource resource = new SwaggerResource();
        resource.setName(name);
        resource.setLocation(location);
        resource.setSwaggerVersion("2.0");
        return resource;
    }
}

