/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.srplib.validation.Validatable;
import org.srplib.validation.Validator;

public class CompositeValidator<T>
implements Validator<T> {
    private List<Validator<T>> validators;

    public CompositeValidator(List<Validator<T>> validators) {
        if (validators == null) {
            throw new IllegalArgumentException("Validators collection must not be null.");
        }
        this.validators = new ArrayList<Validator<T>>(validators);
    }

    public CompositeValidator(Validator<T> ... validators) {
        this(Arrays.asList(validators));
    }

    public void add(Validator<T> ... validators) {
        this.validators.addAll(Arrays.asList(validators));
    }

    public void validate(Validatable<T> validatable) {
        for (Validator<T> validator : this.validators) {
            validator.validate(validatable);
        }
    }
}

