/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection;

import org.srplib.contract.Argument;
import org.srplib.contract.Utils;

public class ToStringHelper {
    public static String toString(Class<?> clazz, String methodName, Class<?>[] parameters, Object[] arguments) {
        Argument.checkNotNull(clazz, (String)"clazz must not be null!", (Object[])new Object[0]);
        Argument.checkNotNull(parameters, (String)"parameters must not be null!", (Object[])new Object[0]);
        String result = String.format("%s.%s(%s)", clazz.getName(), Utils.getDefaultIfNull((Object)methodName, (Object)"constructor"), ToStringHelper.joinClassNames(",", parameters));
        if (arguments != null) {
            result = result + " arguments: [" + ToStringHelper.join(",", arguments) + "]";
            if (parameters.length != arguments.length) {
                result = result + " Number of arguments doesn't match number of parameters.";
            }
        }
        return result;
    }

    public static String toString(Class<?> clazz, String methodName, Class<?>[] parameters) {
        return ToStringHelper.toString(clazz, methodName, parameters, null);
    }

    public static String toString(Class<?> declaringClass, String fieldName) {
        return declaringClass.getName() + "." + fieldName;
    }

    public static String joinClassNames(String separator, Class<?> ... classes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            sb.append(classes[i].getName());
            if (i >= classes.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String join(String separator, Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

