/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;
import org.srplib.reflection.ReflectionException;
import org.srplib.reflection.ReflectionInvoker;
import org.srplib.reflection.ToStringHelper;
import org.srplib.reflection.Types;
import org.srplib.support.Path;

public class ReflectionUtils {
    public static final Object[] EMPTY_ARGUMENTS = new Object[0];
    public static final Class<?>[] EMPTY_TYPES = new Class[0];
    public static final Set<Class<?>> WRAPPERS = new HashSet();

    public static Object getInitValue(Class<?> type) {
        return Types.getDefaultValue(type);
    }

    public static List<Class<?>> getTypeParameters(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
        if (!ReflectionUtils.isParameterizedType(clazz.getGenericSuperclass())) {
            return null;
        }
        Type[] typeArguments = ReflectionUtils.asParameterizedType(clazz).getActualTypeArguments();
        List<Type> types = Arrays.asList(typeArguments);
        return types;
    }

    public static <T> Class<T> getTypeParameter(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
        if (!ReflectionUtils.isParameterizedType(clazz.getGenericSuperclass())) {
            return null;
        }
        Type[] typeArguments = ReflectionUtils.asParameterizedType(clazz).getActualTypeArguments();
        if (typeArguments.length == 0) {
            return null;
        }
        Type firstTypeArgument = typeArguments[0];
        return ReflectionUtils.isParameterizedType(firstTypeArgument) ? (Class)((ParameterizedType)firstTypeArgument).getRawType() : (Class)firstTypeArgument;
    }

    private static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    private static ParameterizedType asParameterizedType(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
        return (ParameterizedType)clazz.getGenericSuperclass();
    }

    public static <T> Class<T> getTypeParameter(Class<?> clazz, String message, Object ... parameters) {
        Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
        Class<T> type = ReflectionUtils.getTypeParameter(clazz);
        Assert.checkNotNull(type, (String)message, (Object[])parameters);
        return type;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
            Argument.checkNotNull(clazz, (String)"'methodName' must not be null!", (Object[])new Object[0]);
            return clazz.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Argument.checkNotNull(clazz, (String)"'clazz' must not be null!", (Object[])new Object[0]);
            return clazz.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("No such method " + ToStringHelper.toString(clazz, methodName, parameters), e);
        }
    }

    public static Method findMethodRecursively(Class<?> clazz, String methodName, Class<?> ... parameters) {
        Argument.checkNotNull((Object)methodName, (String)"'methodName' must not be null!", (Object[])new Object[0]);
        if (clazz == null) {
            return null;
        }
        Method method = ReflectionUtils.findMethod(clazz, methodName, parameters);
        if (method == null) {
            method = ReflectionUtils.findMethodRecursively(clazz.getSuperclass(), methodName, parameters);
        }
        return method;
    }

    public static Method getMethodRecursively(Class<?> clazz, String methodName, Class<?> ... parameters) {
        Method method = ReflectionUtils.findMethodRecursively(clazz, methodName, parameters);
        if (method == null) {
            throw new ReflectionException("No such method " + ToStringHelper.toString(clazz, methodName, parameters));
        }
        return method;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        Argument.checkNotNull(clazz, (String)"Can't get field from null class.", (Object[])new Object[0]);
        Argument.checkNotNull((Object)fieldName, (String)"Can't get field with null name.", (Object[])new Object[0]);
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = ReflectionUtils.findField(clazz, fieldName);
        if (field == null) {
            throw new ReflectionException(String.format("No declared field '%s' in class '%s'.", fieldName, clazz.getName()));
        }
        return field;
    }

    public static Field findFieldRecursively(Class<?> clazz, String fieldName) {
        Field field;
        if (Path.isComplex((String)fieldName)) {
            Path path = Path.parse((String)fieldName);
            field = ReflectionUtils.findFieldRecursively(clazz, path);
        } else {
            field = ReflectionUtils.findField(clazz, fieldName);
            if (field == null && clazz.getSuperclass() != null) {
                field = ReflectionUtils.findFieldRecursively(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Field findFieldRecursively(Class<?> clazz, Path path) {
        Assert.checkNotNull(clazz, (String)"class must not be null!", (Object[])new Object[0]);
        Assert.checkNotNull((Object)path, (String)"Property name must not be null!", (Object[])new Object[0]);
        String fieldName = path.getFirst();
        Field field = ReflectionUtils.findFieldRecursively(clazz, fieldName);
        if (field != null && path.isComplex()) {
            field = ReflectionUtils.findFieldRecursively(field.getType(), path.subpath());
        }
        return field;
    }

    public static Field getFieldRecursively(Class<?> clazz, Path path) {
        Assert.checkNotNull(clazz, (String)"class must not be null!", (Object[])new Object[0]);
        Assert.checkNotNull((Object)path, (String)"Property name must not be null!", (Object[])new Object[0]);
        String fieldName = path.getFirst();
        Field field = ReflectionUtils.findFieldRecursively(clazz, fieldName);
        if (field != null && path.isComplex()) {
            field = ReflectionUtils.findFieldRecursively(field.getType(), path.subpath());
        }
        if (field == null) {
            throw new ReflectionException(String.format("Can't find field path '%s'. No declared field '%s' in class '%s' or its superclasses.", path.toString(), fieldName, clazz));
        }
        return field;
    }

    public static Field getFieldRecursively(Class<?> clazz, String fieldName) {
        Assert.checkNotNull((Object)fieldName, (String)"Field name must not be null!", (Object[])new Object[0]);
        return ReflectionUtils.getFieldRecursively(clazz, Path.parse((String)fieldName));
    }

    public static List<Field> getFields(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't get fields from null class.", (Object[])new Object[0]);
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (ReflectionUtils.isSyntheticName(field.getName())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getFieldsRecursively(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        ReflectionUtils.collectFieldsRecursively(clazz, fields);
        return fields;
    }

    private static void collectFieldsRecursively(Class<?> type, List<Field> fields) {
        if (type != null) {
            fields.addAll(ReflectionUtils.getFields(type));
            ReflectionUtils.collectFieldsRecursively(type.getSuperclass(), fields);
        }
    }

    public static void setFieldValue(Object target, Field field, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("Can't set value to field '" + field + "'", e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        Argument.checkNotNull((Object)target, (String)"'target' must not be null!", (Object[])new Object[0]);
        Argument.checkNotNull((Object)fieldName, (String)"'fieldName' must not be null!", (Object[])new Object[0]);
        Path path = Path.parse((String)fieldName);
        ReflectionUtils.setFieldValue(target, path, value);
    }

    public static void setFieldValue(Object target, Path path, Object value) {
        Argument.checkNotNull((Object)target, (String)"Can't set value to field '%s' of null object.", (Object[])new Object[]{path});
        Argument.checkNotNull((Object)path, (String)"path must not be null.", (Object[])new Object[0]);
        Object parentObject = target;
        for (int i = 0; i < path.size() - 1; ++i) {
            String fieldName = path.get(i);
            if (parentObject == null) {
                throw new ReflectionException(String.format("Can't set value to field '%s'. Object for path '%s' is null.", path, path.subpath(0, i)));
            }
            Field field = ReflectionUtils.findFieldRecursively(parentObject.getClass(), fieldName);
            if (field == null) {
                throw new ReflectionException(String.format("Can't set value to field '%s'. No field '%s' (full path '%s') in class '%s'. ", path, fieldName, path.subpath(0, i + 1), target.getClass()));
            }
            parentObject = ReflectionUtils.getFieldValue(parentObject, field);
        }
        if (parentObject == null) {
            throw new ReflectionException(String.format("Can't set value to field '%s'. Parent object (%s) is null", path, path.parent()));
        }
        Field field = ReflectionUtils.getFieldRecursively(parentObject.getClass(), path.getLast());
        ReflectionUtils.setFieldValue(parentObject, field, value);
    }

    private static void setFieldValueInternal(Object target, String fieldName, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            ReflectionUtils.setFieldValue(target, field, value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(String.format("Can't set value to field '%s'. No such field.", ToStringHelper.toString(target.getClass(), fieldName)), e);
        }
    }

    public static <T> T getFieldValue(Object target, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Can't get value of field '%s'.", field), e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) {
        Path path = Path.parse((String)fieldName);
        return ReflectionUtils.getFieldValue(target, path);
    }

    public static <T> T getFieldValue(Object target, Path path) {
        Argument.checkNotNull((Object)target, (String)"Can't get value of field '%s' of null object.", (Object[])new Object[]{path});
        Argument.checkNotNull((Object)path, (String)"path must not be null.", (Object[])new Object[0]);
        Argument.checkFalse((boolean)path.isEmpty(), (String)"path must not be empty.", (Object[])new Object[0]);
        Object fieldValue = target;
        for (int i = 0; i < path.size(); ++i) {
            String fieldName = path.get(i);
            if (fieldValue == null) {
                throw new ReflectionException(String.format("Can't get value of field '%s'. Object for path '%s' is null.", path, path.subpath(0, i)));
            }
            Field field = ReflectionUtils.findFieldRecursively(fieldValue.getClass(), fieldName);
            if (field == null) {
                throw new ReflectionException(String.format("Can't get value of field '%s'. No field '%s' (full path '%s') in class '%s'. ", path, fieldName, path.subpath(0, i + 1), target.getClass()));
            }
            fieldValue = ReflectionUtils.getFieldValue(fieldValue, field);
        }
        return (T)fieldValue;
    }

    public static <T> Class<T> getFieldType(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(String.format("No such field '%s'.", ToStringHelper.toString(clazz, fieldName)), e);
        }
    }

    @Deprecated
    public static <T> T invokeMethod(Method method, Object object, Object ... arguments) {
        return ReflectionUtils.invokeMethod(object, method, arguments);
    }

    public static <T> T invokeMethod(Object target, Method method, Object ... arguments) {
        return ReflectionInvoker.invokeMethod(target, method, arguments);
    }

    public static <T> T newInstance(Class<T> clazz, Class[] parameters, Object[] arguments) {
        return ReflectionInvoker.newInstance(clazz, parameters, arguments);
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectionUtils.newInstance(clazz, EMPTY_TYPES, EMPTY_ARGUMENTS);
    }

    public static <T> T newInstance(String className) {
        return ReflectionUtils.newInstance(ReflectionUtils.classForName(className));
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        try {
            clazz.getDeclaredConstructor(parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T> Class<T> classForName(String className) {
        try {
            Argument.checkNotNull((Object)className, (String)"Can't create class from 'null' class name.", (Object[])new Object[0]);
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(String.format("Class '%s' not found.", className), e);
        }
    }

    public static boolean isArray(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return clazz.isArray();
    }

    public static boolean isCollection(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isSimpleType(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return clazz.isPrimitive() || ReflectionUtils.isPrimitiveWrapper(clazz) || clazz == String.class || clazz == Date.class || Enum.class.isAssignableFrom(clazz);
    }

    public static boolean isComplexType(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return !ReflectionUtils.isSimpleType(clazz);
    }

    public static boolean isSyntheticName(String name) {
        return name != null && name.indexOf(36) != -1;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return WRAPPERS.contains(clazz);
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return ReflectionUtils.isArray(clazz) && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return ReflectionUtils.isArray(clazz) && ReflectionUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    static {
        WRAPPERS.addAll(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class));
    }
}

