/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.util.HashMap;
import java.util.Map;
import org.srplib.contract.Assert;
import org.srplib.conversion.ConvertBackConverter;
import org.srplib.conversion.Converter;
import org.srplib.conversion.TwoWayConverter;

public class ConverterRegistry {
    private Map<MappingKey, Converter> converters = new HashMap<MappingKey, Converter>();

    public <I, O> ConverterRegistry registerConverter(Class<I> source, Class<O> target, Converter<I, O> converter) {
        this.registerConverterUntyped(source, target, converter);
        return this;
    }

    public ConverterRegistry registerConverterUntyped(Class<?> source, Class<?> target, Converter<?, ?> converter) {
        this.registerConverterInternal(source, target, converter);
        if (converter instanceof TwoWayConverter) {
            this.registerConverterInternal(target, source, new ConvertBackConverter((TwoWayConverter)converter));
        }
        return this;
    }

    private ConverterRegistry registerConverterInternal(Class<?> source, Class<?> target, Converter<?, ?> converter) {
        MappingKey mappingKey = this.createKey(source, target);
        Assert.checkTrue((!this.converters.containsKey(mappingKey) ? 1 : 0) != 0, (String)"Converter from '%s' to '%s' already registered.", (Object[])new Object[]{source.getName(), target.getName()});
        this.converters.put(mappingKey, converter);
        return this;
    }

    public <I, O> Converter<I, O> getConverter(Class<I> source, Class<O> target) {
        return this.converters.get(this.createKey(source, target));
    }

    private MappingKey createKey(Class<?> source, Class<?> target) {
        return new MappingKey(source, target);
    }

    private static final class MappingKey {
        private Class source;
        private Class target;

        private MappingKey(Class source, Class target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            MappingKey key = (MappingKey)that;
            return this.source == key.source && this.target == key.target;
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public String toString() {
            return "MappingKey [source:" + this.source + ", target:" + this.target + ']';
        }
    }
}

